# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .permissions import Permissions


class WorkspaceManifest(UniversalBaseModel):
    type: typing.Literal["workspace"] = pydantic.Field(default="workspace")
    """
    +value=workspace
    """

    cluster_fqn: str = pydantic.Field()
    """
    +label=Cluster FQN
    +sort=150
    +icon=fa-spider-web:#326ce5
    +uiProps={"disableCloudProvider": true}
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=200
    +icon=fa-desktop:#black
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    environment_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Environment
    +sort=300
    +icon=fa-tags:#black
    +usage=Tag the environment like dev, staging or production. You will need to [create environments](https://docs.truefoundry.com/docs/key-concepts#creating-environments) if you don't have already.
    """

    labels: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +sort=700
    """

    annotations: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +sort=750
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=500
    """

    permissions: typing.Optional[typing.List[Permissions]] = pydantic.Field(default=None)
    """
    +label=Permissions
    +sort=500
    +uiType=Permissions
    +uiProps={"allowedResources": {"mlf-project": {"title": "ML Repo", "description": "ML Repos are used to store models and artifacts like git repos. MLRepos are backed by S3 / GCS / Azure bucket and you can have different ml repos with different set of permissions. [View Docs](https://docs.truefoundry.com/docs/introduction-to-ml-repo)"}}}
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
