# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.get_workspace_response import GetWorkspaceResponse
from ..types.workspace import Workspace
from ..types.workspace_manifest import WorkspaceManifest
from .raw_client import AsyncRawWorkspacesClient, RawWorkspacesClient
from .types.workspaces_delete_response import WorkspacesDeleteResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkspacesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkspacesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkspacesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkspacesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        cluster_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Workspace]:
        """
        List workspaces associated with the user. Optional filters include clusterId, fqn, and workspace name. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        cluster_id : typing.Optional[str]
            ClusterId of the Cluster

        name : typing.Optional[str]
            Workspace Name

        fqn : typing.Optional[str]
            Workspace FQN

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Workspace]
            Returns all the workspaces associated with a user and also the response includes paginated data.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.workspaces.list(
            limit=10,
            offset=0,
            cluster_id="clusterId",
            name="name",
            fqn="fqn",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            limit=limit, offset=offset, cluster_id=cluster_id, name=name, fqn=fqn, request_options=request_options
        )

    def create_or_update(
        self,
        *,
        manifest: WorkspaceManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetWorkspaceResponse:
        """
        Creates a new workspace or updates an existing one based on the provided manifest.

        Parameters
        ----------
        manifest : WorkspaceManifest
            Workspace manifest

        dry_run : typing.Optional[bool]
            Dry run the request

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetWorkspaceResponse
            - Creates or updates a workspace with given manifest
                - Corresponding authorization entry with admin role is made using newly created workspace
                - Attached with the cluster id where the workspace is created

        Examples
        --------
        from truefoundry_sdk import TrueFoundry, WorkspaceManifest

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.workspaces.create_or_update(
            manifest=WorkspaceManifest(
                cluster_fqn="cluster_fqn",
                name="name",
            ),
        )
        """
        _response = self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetWorkspaceResponse:
        """
        Get workspace associated with provided workspace id

        Parameters
        ----------
        id : str
            Workspace id of the space

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetWorkspaceResponse
            Returns the workspaces associated with provided workspace id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.workspaces.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> WorkspacesDeleteResponse:
        """
        Deletes the workspace with the given workspace ID.
            - Removes the associated namespace from the cluster.
            - Deletes the corresponding authorization entry.

        Parameters
        ----------
        id : str
            Workspace id of the space

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspacesDeleteResponse
            Successfully deletes the workspace and returns the workspace details along with a confirmation message.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.workspaces.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncWorkspacesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkspacesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkspacesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkspacesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        cluster_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Workspace]:
        """
        List workspaces associated with the user. Optional filters include clusterId, fqn, and workspace name. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        cluster_id : typing.Optional[str]
            ClusterId of the Cluster

        name : typing.Optional[str]
            Workspace Name

        fqn : typing.Optional[str]
            Workspace FQN

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Workspace]
            Returns all the workspaces associated with a user and also the response includes paginated data.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.workspaces.list(
                limit=10,
                offset=0,
                cluster_id="clusterId",
                name="name",
                fqn="fqn",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            limit=limit, offset=offset, cluster_id=cluster_id, name=name, fqn=fqn, request_options=request_options
        )

    async def create_or_update(
        self,
        *,
        manifest: WorkspaceManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetWorkspaceResponse:
        """
        Creates a new workspace or updates an existing one based on the provided manifest.

        Parameters
        ----------
        manifest : WorkspaceManifest
            Workspace manifest

        dry_run : typing.Optional[bool]
            Dry run the request

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetWorkspaceResponse
            - Creates or updates a workspace with given manifest
                - Corresponding authorization entry with admin role is made using newly created workspace
                - Attached with the cluster id where the workspace is created

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, WorkspaceManifest

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.workspaces.create_or_update(
                manifest=WorkspaceManifest(
                    cluster_fqn="cluster_fqn",
                    name="name",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetWorkspaceResponse:
        """
        Get workspace associated with provided workspace id

        Parameters
        ----------
        id : str
            Workspace id of the space

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetWorkspaceResponse
            Returns the workspaces associated with provided workspace id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.workspaces.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspacesDeleteResponse:
        """
        Deletes the workspace with the given workspace ID.
            - Removes the associated namespace from the cluster.
            - Deletes the corresponding authorization entry.

        Parameters
        ----------
        id : str
            Workspace id of the space

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspacesDeleteResponse
            Successfully deletes the workspace and returns the workspace details along with a confirmation message.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.workspaces.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
