# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..types.app import App
from ..types.get_app_response import GetAppResponse
from ..types.list_apps_response import ListAppsResponse
from .types.apps_list_request_sort_direction import AppsListRequestSortDirection
from .types.apps_list_request_sort_key import AppsListRequestSortKey


class RawAppsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        sort_key: typing.Optional[AppsListRequestSortKey] = None,
        sort_direction: typing.Optional[AppsListRequestSortDirection] = None,
        category_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[App]:
        """
        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the apps

        sort_key : typing.Optional[AppsListRequestSortKey]
            The key to sort the apps by

        sort_direction : typing.Optional[AppsListRequestSortDirection]
            The direction to sort the apps

        category_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Only return apps in these categories

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[App]
            apps listed
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/connect/apps",
            method="GET",
            params={
                "after": after,
                "before": before,
                "limit": limit,
                "q": q,
                "sort_key": sort_key,
                "sort_direction": sort_direction,
                "category_ids": category_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListAppsResponse,
                    parse_obj_as(
                        type_=ListAppsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""
                    _get_next = lambda: self.list(
                        after=_parsed_next,
                        before=before,
                        limit=limit,
                        q=q,
                        sort_key=sort_key,
                        sort_direction=sort_direction,
                        category_ids=category_ids,
                        request_options=request_options,
                    )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetAppResponse]:
        """
        Parameters
        ----------
        app_id : str
            The name slug or ID of the app (e.g., 'slack', 'github')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetAppResponse]
            app retrieved
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/apps/{jsonable_encoder(app_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAppResponse,
                    parse_obj_as(
                        type_=GetAppResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAppsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        sort_key: typing.Optional[AppsListRequestSortKey] = None,
        sort_direction: typing.Optional[AppsListRequestSortDirection] = None,
        category_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[App]:
        """
        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the apps

        sort_key : typing.Optional[AppsListRequestSortKey]
            The key to sort the apps by

        sort_direction : typing.Optional[AppsListRequestSortDirection]
            The direction to sort the apps

        category_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Only return apps in these categories

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[App]
            apps listed
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/connect/apps",
            method="GET",
            params={
                "after": after,
                "before": before,
                "limit": limit,
                "q": q,
                "sort_key": sort_key,
                "sort_direction": sort_direction,
                "category_ids": category_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListAppsResponse,
                    parse_obj_as(
                        type_=ListAppsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""

                    async def _get_next():
                        return await self.list(
                            after=_parsed_next,
                            before=before,
                            limit=limit,
                            q=q,
                            sort_key=sort_key,
                            sort_direction=sort_direction,
                            category_ids=category_ids,
                            request_options=request_options,
                        )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetAppResponse]:
        """
        Parameters
        ----------
        app_id : str
            The name slug or ID of the app (e.g., 'slack', 'github')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetAppResponse]
            app retrieved
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/apps/{jsonable_encoder(app_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAppResponse,
                    parse_obj_as(
                        type_=GetAppResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
