# This file was auto-generated by Fern from our API Definition.

import os
import typing

import httpx
from .types.project_environment import ProjectEnvironment
from .accounts.client import AccountsClient, AsyncAccountsClient
from .actions.client import ActionsClient, AsyncActionsClient
from .app_categories.client import AppCategoriesClient, AsyncAppCategoriesClient
from .apps.client import AppsClient, AsyncAppsClient
from .components.client import AsyncComponentsClient, ComponentsClient
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.oauth_token_provider import OAuthTokenProvider
from .deployed_triggers.client import AsyncDeployedTriggersClient, DeployedTriggersClient
from .environment import PipedreamEnvironment
from .oauth_tokens.client import AsyncOauthTokensClient, OauthTokensClient
from .projects.client import AsyncProjectsClient, ProjectsClient
from .proxy.client import AsyncProxyClient, ProxyClient
from .tokens.client import AsyncTokensClient, TokensClient
from .triggers.client import AsyncTriggersClient, TriggersClient
from .users.client import AsyncUsersClient, UsersClient


class Client:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PipedreamEnvironment
        The environment to use for requests from the client. from .environment import PipedreamEnvironment



        Defaults to PipedreamEnvironment.PROD



    project_id : str
    project_environment : typing.Optional[ProjectEnvironment]
    client_id : typing.Optional[str]
    client_secret : typing.Optional[str]
    _token_getter_override : typing.Optional[typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from pipedream import Pipedream

    client = Pipedream(
        project_id="YOUR_PROJECT_ID",
        project_environment="YOUR_PROJECT_ENVIRONMENT",
        client_id="YOUR_CLIENT_ID",
        client_secret="YOUR_CLIENT_SECRET",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PipedreamEnvironment = PipedreamEnvironment.PROD,
        project_id: str,
        project_environment: typing.Optional[ProjectEnvironment] = os.getenv("PIPEDREAM_PROJECT_ENVIRONMENT"),
        client_id: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_ID"),
        client_secret: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_SECRET"),
        _token_getter_override: typing.Optional[typing.Callable[[], str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if client_id is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_id or setting PIPEDREAM_CLIENT_ID"
            )
        if client_secret is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_secret or setting PIPEDREAM_CLIENT_SECRET"
            )
        oauth_token_provider = OAuthTokenProvider(
            client_id=client_id,
            client_secret=client_secret,
            client_wrapper=SyncClientWrapper(
                base_url=_get_base_url(base_url=base_url, environment=environment),
                project_id=project_id,
                project_environment=project_environment,
                httpx_client=httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
                if follow_redirects is not None
                else httpx.Client(timeout=_defaulted_timeout),
                timeout=_defaulted_timeout,
            ),
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            project_id=project_id,
            project_environment=project_environment,
            token=_token_getter_override if _token_getter_override is not None else oauth_token_provider.get_token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.app_categories = AppCategoriesClient(client_wrapper=self._client_wrapper)
        self.apps = AppsClient(client_wrapper=self._client_wrapper)
        self.accounts = AccountsClient(client_wrapper=self._client_wrapper)
        self.users = UsersClient(client_wrapper=self._client_wrapper)
        self.components = ComponentsClient(client_wrapper=self._client_wrapper)
        self.actions = ActionsClient(client_wrapper=self._client_wrapper)
        self.triggers = TriggersClient(client_wrapper=self._client_wrapper)
        self.deployed_triggers = DeployedTriggersClient(client_wrapper=self._client_wrapper)
        self.projects = ProjectsClient(client_wrapper=self._client_wrapper)
        self.proxy = ProxyClient(client_wrapper=self._client_wrapper)
        self.tokens = TokensClient(client_wrapper=self._client_wrapper)
        self.oauth_tokens = OauthTokensClient(client_wrapper=self._client_wrapper)


class AsyncClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PipedreamEnvironment
        The environment to use for requests from the client. from .environment import PipedreamEnvironment



        Defaults to PipedreamEnvironment.PROD



    project_id : str
    project_environment : typing.Optional[ProjectEnvironment]
    client_id : typing.Optional[str]
    client_secret : typing.Optional[str]
    _token_getter_override : typing.Optional[typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from pipedream import AsyncPipedream

    client = AsyncPipedream(
        project_id="YOUR_PROJECT_ID",
        project_environment="YOUR_PROJECT_ENVIRONMENT",
        client_id="YOUR_CLIENT_ID",
        client_secret="YOUR_CLIENT_SECRET",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PipedreamEnvironment = PipedreamEnvironment.PROD,
        project_id: str,
        project_environment: typing.Optional[ProjectEnvironment] = os.getenv("PIPEDREAM_PROJECT_ENVIRONMENT"),
        client_id: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_ID"),
        client_secret: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_SECRET"),
        _token_getter_override: typing.Optional[typing.Callable[[], str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if client_id is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_id or setting PIPEDREAM_CLIENT_ID"
            )
        if client_secret is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_secret or setting PIPEDREAM_CLIENT_SECRET"
            )
        oauth_token_provider = OAuthTokenProvider(
            client_id=client_id,
            client_secret=client_secret,
            client_wrapper=SyncClientWrapper(
                base_url=_get_base_url(base_url=base_url, environment=environment),
                project_id=project_id,
                project_environment=project_environment,
                httpx_client=httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
                if follow_redirects is not None
                else httpx.Client(timeout=_defaulted_timeout),
                timeout=_defaulted_timeout,
            ),
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            project_id=project_id,
            project_environment=project_environment,
            token=_token_getter_override if _token_getter_override is not None else oauth_token_provider.get_token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.app_categories = AsyncAppCategoriesClient(client_wrapper=self._client_wrapper)
        self.apps = AsyncAppsClient(client_wrapper=self._client_wrapper)
        self.accounts = AsyncAccountsClient(client_wrapper=self._client_wrapper)
        self.users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        self.components = AsyncComponentsClient(client_wrapper=self._client_wrapper)
        self.actions = AsyncActionsClient(client_wrapper=self._client_wrapper)
        self.triggers = AsyncTriggersClient(client_wrapper=self._client_wrapper)
        self.deployed_triggers = AsyncDeployedTriggersClient(client_wrapper=self._client_wrapper)
        self.projects = AsyncProjectsClient(client_wrapper=self._client_wrapper)
        self.proxy = AsyncProxyClient(client_wrapper=self._client_wrapper)
        self.tokens = AsyncTokensClient(client_wrapper=self._client_wrapper)
        self.oauth_tokens = AsyncOauthTokensClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: PipedreamEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
