# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.deployed_component import DeployedComponent
from ..types.emitted_event import EmittedEvent
from ..types.get_trigger_webhooks_response import GetTriggerWebhooksResponse
from ..types.get_trigger_workflows_response import GetTriggerWorkflowsResponse
from .raw_client import AsyncRawDeployedTriggersClient, RawDeployedTriggersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DeployedTriggersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDeployedTriggersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDeployedTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDeployedTriggersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        external_user_id: str,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DeployedComponent]:
        """
        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DeployedComponent]
            deployed triggers listed

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        response = client.deployed_triggers.list(
            external_user_id="external_user_id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            external_user_id=external_user_id, after=after, before=before, limit=limit, request_options=request_options
        )

    def retrieve(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeployedComponent:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployedComponent
            deployed trigger retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.retrieve(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.retrieve(
            trigger_id, external_user_id=external_user_id, request_options=request_options
        )
        return _response.data

    def update(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        active: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeployedComponent:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        active : typing.Optional[bool]
            Whether the trigger should be active

        configured_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The configured properties for the trigger

        name : typing.Optional[str]
            The name of the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployedComponent
            deployed trigger updated

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.update(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.update(
            trigger_id,
            external_user_id=external_user_id,
            active=active,
            configured_props=configured_props,
            name=name,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        ignore_hook_errors: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        ignore_hook_errors : typing.Optional[bool]
            Whether to ignore errors during deactivation hook

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.delete(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.delete(
            trigger_id,
            external_user_id=external_user_id,
            ignore_hook_errors=ignore_hook_errors,
            request_options=request_options,
        )
        return _response.data

    def list_events(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        n: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[EmittedEvent]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        n : typing.Optional[int]
            The number of events to retrieve (defaults to 20 if not provided)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EmittedEvent]
            trigger events retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.list_events(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.list_events(
            trigger_id, external_user_id=external_user_id, n=n, request_options=request_options
        )
        return _response.data

    def list_workflows(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTriggerWorkflowsResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWorkflowsResponse
            trigger workflows retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.list_workflows(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.list_workflows(
            trigger_id, external_user_id=external_user_id, request_options=request_options
        )
        return _response.data

    def update_workflows(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        workflow_ids: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTriggerWorkflowsResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        workflow_ids : typing.Sequence[str]
            Array of workflow IDs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWorkflowsResponse
            trigger workflows updated

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.update_workflows(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
            workflow_ids=["workflow_ids"],
        )
        """
        _response = self._raw_client.update_workflows(
            trigger_id, external_user_id=external_user_id, workflow_ids=workflow_ids, request_options=request_options
        )
        return _response.data

    def list_webhooks(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTriggerWebhooksResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWebhooksResponse
            trigger webhooks retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.list_webhooks(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.list_webhooks(
            trigger_id, external_user_id=external_user_id, request_options=request_options
        )
        return _response.data

    def update_webhooks(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        webhook_urls: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTriggerWebhooksResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        webhook_urls : typing.Sequence[str]
            Array of webhook URLs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWebhooksResponse
            trigger webhooks updated

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.deployed_triggers.update_webhooks(
            trigger_id="trigger_id",
            external_user_id="external_user_id",
            webhook_urls=["webhook_urls"],
        )
        """
        _response = self._raw_client.update_webhooks(
            trigger_id, external_user_id=external_user_id, webhook_urls=webhook_urls, request_options=request_options
        )
        return _response.data


class AsyncDeployedTriggersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDeployedTriggersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDeployedTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDeployedTriggersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        external_user_id: str,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DeployedComponent]:
        """
        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DeployedComponent]
            deployed triggers listed

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            response = await client.deployed_triggers.list(
                external_user_id="external_user_id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            external_user_id=external_user_id, after=after, before=before, limit=limit, request_options=request_options
        )

    async def retrieve(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeployedComponent:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployedComponent
            deployed trigger retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.retrieve(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            trigger_id, external_user_id=external_user_id, request_options=request_options
        )
        return _response.data

    async def update(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        active: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeployedComponent:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        active : typing.Optional[bool]
            Whether the trigger should be active

        configured_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The configured properties for the trigger

        name : typing.Optional[str]
            The name of the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployedComponent
            deployed trigger updated

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.update(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            trigger_id,
            external_user_id=external_user_id,
            active=active,
            configured_props=configured_props,
            name=name,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        ignore_hook_errors: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        ignore_hook_errors : typing.Optional[bool]
            Whether to ignore errors during deactivation hook

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.delete(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(
            trigger_id,
            external_user_id=external_user_id,
            ignore_hook_errors=ignore_hook_errors,
            request_options=request_options,
        )
        return _response.data

    async def list_events(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        n: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[EmittedEvent]:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            Your end user ID, for whom you deployed the trigger

        n : typing.Optional[int]
            The number of events to retrieve (defaults to 20 if not provided)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EmittedEvent]
            trigger events retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.list_events(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_events(
            trigger_id, external_user_id=external_user_id, n=n, request_options=request_options
        )
        return _response.data

    async def list_workflows(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTriggerWorkflowsResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWorkflowsResponse
            trigger workflows retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.list_workflows(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_workflows(
            trigger_id, external_user_id=external_user_id, request_options=request_options
        )
        return _response.data

    async def update_workflows(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        workflow_ids: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTriggerWorkflowsResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        workflow_ids : typing.Sequence[str]
            Array of workflow IDs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWorkflowsResponse
            trigger workflows updated

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.update_workflows(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
                workflow_ids=["workflow_ids"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_workflows(
            trigger_id, external_user_id=external_user_id, workflow_ids=workflow_ids, request_options=request_options
        )
        return _response.data

    async def list_webhooks(
        self, trigger_id: str, *, external_user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTriggerWebhooksResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWebhooksResponse
            trigger webhooks retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.list_webhooks(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_webhooks(
            trigger_id, external_user_id=external_user_id, request_options=request_options
        )
        return _response.data

    async def update_webhooks(
        self,
        trigger_id: str,
        *,
        external_user_id: str,
        webhook_urls: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTriggerWebhooksResponse:
        """
        Parameters
        ----------
        trigger_id : str

        external_user_id : str
            The external user ID who owns the trigger

        webhook_urls : typing.Sequence[str]
            Array of webhook URLs to set

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTriggerWebhooksResponse
            trigger webhooks updated

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.deployed_triggers.update_webhooks(
                trigger_id="trigger_id",
                external_user_id="external_user_id",
                webhook_urls=["webhook_urls"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_webhooks(
            trigger_id, external_user_id=external_user_id, webhook_urls=webhook_urls, request_options=request_options
        )
        return _response.data
