# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.project_info_response import ProjectInfoResponse
from .raw_client import AsyncRawProjectsClient, RawProjectsClient


class ProjectsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProjectsClient
        """
        return self._raw_client

    def retrieve_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> ProjectInfoResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectInfoResponse
            project info retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.projects.retrieve_info()
        """
        _response = self._raw_client.retrieve_info(request_options=request_options)
        return _response.data


class AsyncProjectsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProjectsClient
        """
        return self._raw_client

    async def retrieve_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> ProjectInfoResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectInfoResponse
            project info retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.projects.retrieve_info()


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_info(request_options=request_options)
        return _response.data
