# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawProxyClient, RawProxyClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProxyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProxyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProxyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProxyClient
        """
        return self._raw_client

    def get(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.get(
            url_64="url_64",
            external_user_id="external_user_id",
            account_id="account_id",
        )
        """
        _response = self._raw_client.get(
            url_64, external_user_id=external_user_id, account_id=account_id, request_options=request_options
        )
        return _response.data

    def post(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.post(
            url_64="url_64",
            external_user_id="external_user_id",
            account_id="account_id",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.post(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=request,
            request_options=request_options,
        )
        return _response.data

    def put(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.put(
            url_64="url_64",
            external_user_id="external_user_id",
            account_id="account_id",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.put(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=request,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.delete(
            url_64="url_64",
            external_user_id="external_user_id",
            account_id="account_id",
        )
        """
        _response = self._raw_client.delete(
            url_64, external_user_id=external_user_id, account_id=account_id, request_options=request_options
        )
        return _response.data

    def patch(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.patch(
            url_64="url_64",
            external_user_id="external_user_id",
            account_id="account_id",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.patch(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=request,
            request_options=request_options,
        )
        return _response.data


class AsyncProxyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProxyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProxyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProxyClient
        """
        return self._raw_client

    async def get(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.get(
                url_64="url_64",
                external_user_id="external_user_id",
                account_id="account_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            url_64, external_user_id=external_user_id, account_id=account_id, request_options=request_options
        )
        return _response.data

    async def post(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.post(
                url_64="url_64",
                external_user_id="external_user_id",
                account_id="account_id",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.post(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=request,
            request_options=request_options,
        )
        return _response.data

    async def put(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.put(
                url_64="url_64",
                external_user_id="external_user_id",
                account_id="account_id",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.put(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=request,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.delete(
                url_64="url_64",
                external_user_id="external_user_id",
                account_id="account_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(
            url_64, external_user_id=external_user_id, account_id=account_id, request_options=request_options
        )
        return _response.data

    async def patch(
        self,
        url_64: str,
        *,
        external_user_id: str,
        account_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        url_64 : str
            Base64-encoded target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.patch(
                url_64="url_64",
                external_user_id="external_user_id",
                account_id="account_id",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=request,
            request_options=request_options,
        )
        return _response.data
