# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AppCategory(UniversalBaseModel):
    """
    Response object for a Pipedream app category
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the app category
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-readable name of the app category
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short description of the app category
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
