# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .prop_option import PropOption


class ConfigurePropResponse(UniversalBaseModel):
    """
    Response received after configuring a component's prop
    """

    options: typing.Optional[typing.List[PropOption]] = pydantic.Field(default=None)
    """
    Available options for the configured prop
    """

    errors: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Any errors that occurred during configuration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
