# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ConnectTokenCreateOpts(UniversalBaseModel):
    """
    Options for creating a Connect token
    """

    external_user_id: str = pydantic.Field()
    """
    Your end user ID, for whom you're creating the token
    """

    project_id: str = pydantic.Field()
    """
    The ID of the project
    """

    allowed_origins: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of allowed origins for CORS
    """

    error_redirect_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    URI to redirect to on error
    """

    success_redirect_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    URI to redirect to on success
    """

    webhook_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    Webhook URI for notifications
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
