# coding: utf-8

"""
    College Football Data API

    This is an API for accessing all sorts of college football data.  Please note that API keys should be supplied with \"Bearer \" prepended (e.g. \"Bearer your_key\"). API keys can be acquired from the CollegeFootballData.com website.  # noqa: E501

    OpenAPI spec version: 4.1.14
    Contact: admin@collegefootballdata.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cfbd.api_client import ApiClient


class RatingsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_conference_sp_ratings(self, **kwargs):  # noqa: E501
        """Historical SP+ ratings by conference  # noqa: E501

        Get average SP+ historical rating data by conference  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conference_sp_ratings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter
        :param str conference: Conference abbreviation filter
        :return: list[ConferenceSPRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_conference_sp_ratings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_conference_sp_ratings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_conference_sp_ratings_with_http_info(self, **kwargs):  # noqa: E501
        """Historical SP+ ratings by conference  # noqa: E501

        Get average SP+ historical rating data by conference  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conference_sp_ratings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter
        :param str conference: Conference abbreviation filter
        :return: list[ConferenceSPRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['year', 'conference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conference_sp_ratings" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('year' in params and params['year'] < 1970):  # noqa: E501
            raise ValueError("Invalid value for parameter `year` when calling `get_conference_sp_ratings`, must be a value greater than or equal to `1970`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'conference' in params:
            query_params.append(('conference', params['conference']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ratings/sp/conferences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ConferenceSPRating]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_elo_ratings(self, **kwargs):  # noqa: E501
        """Historical Elo ratings  # noqa: E501

        Elo rating data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elo_ratings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter
        :param int week: Maximum week filter
        :param str team: Team filter
        :param str conference: Conference filter
        :return: list[TeamEloRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_elo_ratings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_elo_ratings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_elo_ratings_with_http_info(self, **kwargs):  # noqa: E501
        """Historical Elo ratings  # noqa: E501

        Elo rating data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elo_ratings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter
        :param int week: Maximum week filter
        :param str team: Team filter
        :param str conference: Conference filter
        :return: list[TeamEloRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['year', 'week', 'team', 'conference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_elo_ratings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'week' in params:
            query_params.append(('week', params['week']))  # noqa: E501
        if 'team' in params:
            query_params.append(('team', params['team']))  # noqa: E501
        if 'conference' in params:
            query_params.append(('conference', params['conference']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ratings/elo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TeamEloRating]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sp_ratings(self, **kwargs):  # noqa: E501
        """Historical SP+ ratings  # noqa: E501

        SP+ rating data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sp_ratings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter (required if team not specified)
        :param str team: Team filter (required if year not specified)
        :return: list[TeamSPRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sp_ratings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sp_ratings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sp_ratings_with_http_info(self, **kwargs):  # noqa: E501
        """Historical SP+ ratings  # noqa: E501

        SP+ rating data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sp_ratings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter (required if team not specified)
        :param str team: Team filter (required if year not specified)
        :return: list[TeamSPRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['year', 'team']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sp_ratings" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('year' in params and params['year'] < 1970):  # noqa: E501
            raise ValueError("Invalid value for parameter `year` when calling `get_sp_ratings`, must be a value greater than or equal to `1970`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'team' in params:
            query_params.append(('team', params['team']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ratings/sp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TeamSPRating]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_srs_ratings(self, **kwargs):  # noqa: E501
        """Historical SRS ratings  # noqa: E501

        SRS rating data (requires either a year or team specified)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_srs_ratings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter (required if team not specified)
        :param str team: Team filter (required if year not specified)
        :param str conference: Conference filter
        :return: list[TeamSRSRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_srs_ratings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_srs_ratings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_srs_ratings_with_http_info(self, **kwargs):  # noqa: E501
        """Historical SRS ratings  # noqa: E501

        SRS rating data (requires either a year or team specified)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_srs_ratings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int year: Season filter (required if team not specified)
        :param str team: Team filter (required if year not specified)
        :param str conference: Conference filter
        :return: list[TeamSRSRating]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['year', 'team', 'conference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_srs_ratings" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('year' in params and params['year'] < 1897):  # noqa: E501
            raise ValueError("Invalid value for parameter `year` when calling `get_srs_ratings`, must be a value greater than or equal to `1897`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'team' in params:
            query_params.append(('team', params['team']))  # noqa: E501
        if 'conference' in params:
            query_params.append(('conference', params['conference']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ratings/srs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TeamSRSRating]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
