# Contributing to PySploit

Thank you for your interest in contributing to PySploit! This document provides guidelines for contributing to the project.

## Development Setup

1. Clone the repository:
```bash
git clone https://github.com/D14b0l1c/PySploit.git
cd PySploit
```

2. Create a virtual environment:
```bash
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

3. Install development dependencies:
```bash
pip install -e .[dev]
```

## Code Standards

- Follow PEP 8 style guidelines
- Use Black for code formatting: `black src/`
- Use flake8 for linting: `flake8 src/`
- Add type hints where appropriate
- Include docstrings for all public functions

## Testing

Run tests with:
```bash
pytest tests/
```

## Submitting Changes

1. Fork the repository
2. Create a feature branch: `git checkout -b feature-name`
3. Make your changes
4. Add tests for new functionality
5. Ensure all tests pass
6. Submit a pull request

## Vulnerability Data Updates

When updating vulnerability datasets:
- Ensure data integrity and validation
- Update statistics in documentation
- Test deduplication algorithms
- Verify memory usage optimization

## License

By contributing, you agree that your contributions will be licensed under the MIT License.