"""
PySploit Analysis Module
Comprehensive analysis capabilities for vulnerability detection
"""

from .core import PySploitAnalyzer, analyze_host, analyze_traffic, quick_scan

try:
    from .pcap import PcapAnalyzer
    from .nmap import NmapAnalyzer
except ImportError:
    # Optional advanced analyzers
    pass

__all__ = [
    'PySploitAnalyzer',
    'analyze_host',
    'analyze_traffic', 
    'quick_scan',
    'PcapAnalyzer',
    'NmapAnalyzer'
]