"""
PySploit Database Module
Embedded and external database management for vulnerability data
"""

from .embedded import EmbeddedVulnerabilityDatabase, get_embedded_database

try:
    from .database import VulnerabilityDatabase
except ImportError:
    # Optional external database
    pass

__all__ = [
    'EmbeddedVulnerabilityDatabase',
    'get_embedded_database',
    'VulnerabilityDatabase'
]