"""
Basic tests for PySploit library functionality
"""
import pytest
import sys
import os

# Add src to path for testing
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..', 'src'))

import pysploit


def test_pysploit_import():
    """Test that PySploit can be imported successfully"""
    assert pysploit is not None


def test_analyzer_initialization():
    """Test that PySploitAnalyzer can be initialized"""
    analyzer = pysploit.PySploitAnalyzer()
    assert analyzer is not None


def test_database_info():
    """Test that database info can be retrieved"""
    analyzer = pysploit.PySploitAnalyzer()
    info = analyzer.get_database_info()
    
    assert 'statistics' in info
    assert 'total_vulnerabilities' in info['statistics']
    assert info['statistics']['total_vulnerabilities'] > 0


def test_vulnerability_count():
    """Test that the expected number of vulnerabilities are loaded"""
    analyzer = pysploit.PySploitAnalyzer()
    info = analyzer.get_database_info()
    
    # Should have loaded 55,712 vulnerabilities
    assert info['statistics']['total_vulnerabilities'] == 55712


def test_analyze_host_function():
    """Test basic host analysis functionality"""
    # Test with simple service
    results = pysploit.analyze_host('192.168.1.1', [
        {'port': 80, 'service': 'http', 'version': '1.0', 'banner': 'test'}
    ])
    
    assert 'host' in results
    assert 'risk_score' in results
    assert 'vulnerabilities_found' in results
    assert results['host'] == '192.168.1.1'


if __name__ == "__main__":
    pytest.main([__file__])