from setuptools import setup, find_packages

setup(
    name="terminalgpt-pro",
    version="0.1.0",
    description="AI chat assistant in your terminal powered by OpenAI ChatGPT models.",
    author="Adam Yodinsky, Shabernev Fedor",
    author_email="quantumstack01@gmail.com",
    keywords=[
        "ai",
        "chat",
        "terminal",
        "openai",
        "gpt-3",
        "gpt-4",
        "gpt4",
        "gpt3",
        "chatGPT",
        "assistant",
        "gpt-3.5",
        "gpt-3.5-turbo",
        "terminalGPT-Pro",
    ],
    packages=find_packages(),
    python_requires=">=3.9",
    install_requires=[
        "openai==0.27.6",
        "tiktoken>=0.2,<0.6",
        "colorama==0.4.6",
        "cryptography>=40.0.2,<42.0.0",
        "click==8.1.3",
        "prompt-toolkit==3.0.38",
        "yaspin==2.3.0",
        "rich==13.3.5",
        "isort==5.12.0",
        "pytest==7.3.1",
        "pylint==3.0.2",
    ],
    entry_points={
        "console_scripts": [
            "terminalgptpro=terminalgptpro.main:cli",
        ],
    },
    extras_require={
        "dev": [
            "black==23.1.0",
            "pytest==7.2.2",
            "pylint==3.0.2",
            "pexpect==4.8.0",
            "pytest-cov==4.0.0",
        ],
    },
)
