from typing import Protocol, runtime_checkable

@runtime_checkable
class AuthService(Protocol):
    def has_access(self, token: str, permissions: list[str]) -> bool: ...
    def verify_token(self, token: str) -> dict | None: ...
    def get_client_token(self) -> dict | None: ...
    def is_client_token(self, token: str, allowed_clients: set[str] | None = None) -> bool: ...
    def client_has_access(self, token: str, perms: list[str], allowed_clients: set[str] | None = None) -> bool: ...
