# mypy-boto3-signer<a id="mypy-boto3-signer"></a>

[![PyPI - mypy-boto3-signer](https://img.shields.io/pypi/v/mypy-boto3-signer.svg?color=blue)](https://pypi.org/project/mypy-boto3-signer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-signer.svg?color=blue)](https://pypi.org/project/mypy-boto3-signer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-signer?color=blue)](https://pypistats.org/packages/mypy-boto3-signer)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.signer 1.17.81](https://boto3.amazonaws.com/v1/documentation/api/1.17.81/reference/services/signer.html#signer)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-signer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_signer/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-signer](#mypy-boto3-signer)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `signer` service.

```bash
python -m pip install boto3-stubs[signer]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[signer]` in your environment:
  `python -m pip install 'boto3-stubs[signer]'`

Both type checking and auto-complete should work for `signer` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[signer]` in your environment:
  `python -m pip install 'boto3-stubs[signer]'`

Both type checking and auto-complete should work for `signer` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[signer]` in your environment:
  `python -m pip install 'boto3-stubs[signer]'`
- Run `mypy` as usual

Type checking should work for `signer` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[signer]` in your environment:
  `python -m pip install 'boto3-stubs[signer]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `signer` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`signerClient` provides annotations for `boto3.client("signer")`.

```python
import boto3

from mypy_boto3_signer import signerClient

client: signerClient = boto3.client("signer")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: signerClient = session.client("signer")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_signer.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_signer import signerClient
from mypy_boto3_signer.paginator import (
    ListSigningJobsPaginator,
    ListSigningPlatformsPaginator,
    ListSigningProfilesPaginator,
)

client: signerClient = boto3.client("signer")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_signing_jobs_paginator: ListSigningJobsPaginator = client.get_paginator("list_signing_jobs")
list_signing_platforms_paginator: ListSigningPlatformsPaginator = client.get_paginator("list_signing_platforms")
list_signing_profiles_paginator: ListSigningProfilesPaginator = client.get_paginator("list_signing_profiles")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_signer.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_signer import signerClient
from mypy_boto3_signer.waiter import (
    SuccessfulSigningJobWaiter,
)

client: signerClient = boto3.client("signer")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
successful_signing_job_waiter: SuccessfulSigningJobWaiter = client.get_waiter("successful_signing_job")
```

### Literals<a id="literals"></a>

`mypy_boto3_signer.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_signer.literals import (
    CategoryType,
    EncryptionAlgorithmType,
    HashAlgorithmType,
    ImageFormatType,
    ListSigningJobsPaginatorName,
    ListSigningPlatformsPaginatorName,
    ListSigningProfilesPaginatorName,
    SigningProfileStatusType,
    SigningStatusType,
    SuccessfulSigningJobWaiterName,
    ValidityTypeType,
)

def check_value(value: CategoryType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_signer.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_signer.type_defs import (
    AddProfilePermissionResponseTypeDef,
    DescribeSigningJobResponseTypeDef,
    DestinationTypeDef,
    EncryptionAlgorithmOptionsTypeDef,
    GetSigningPlatformResponseTypeDef,
    GetSigningProfileResponseTypeDef,
    HashAlgorithmOptionsTypeDef,
    ListProfilePermissionsResponseTypeDef,
    ListSigningJobsResponseTypeDef,
    ListSigningPlatformsResponseTypeDef,
    ListSigningProfilesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    PermissionTypeDef,
    PutSigningProfileResponseTypeDef,
    RemoveProfilePermissionResponseTypeDef,
    S3DestinationTypeDef,
    S3SignedObjectTypeDef,
    S3SourceTypeDef,
    SignatureValidityPeriodTypeDef,
    SignedObjectTypeDef,
    SigningConfigurationOverridesTypeDef,
    SigningConfigurationTypeDef,
    SigningImageFormatTypeDef,
    SigningJobRevocationRecordTypeDef,
    SigningJobTypeDef,
    SigningMaterialTypeDef,
    SigningPlatformOverridesTypeDef,
    SigningPlatformTypeDef,
    SigningProfileRevocationRecordTypeDef,
    SigningProfileTypeDef,
    SourceTypeDef,
    StartSigningJobResponseTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddProfilePermissionResponseTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-signer` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-signer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_signer/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
