from nicegui import ui

output_label = None

# Function to be triggered when the link is clicked
def show_verse_details(reference: str):
    """Updates the output label with information about the clicked reference."""
    global output_label
    # A UI element to display the output
    output_label = ui.label("Click a Bible link below to see its details.").classes('mt-4 text-lg text-green-700')
    print(f"Python function triggered for: {reference}")
    output_label.set_text(f"Details for {reference}: You clicked the link! In a real app, this function could load verse text from a database or API.")

# Function to create the clickable link component
def create_internal_link(reference: str):
    # 1. Create the ui.link component (it looks like a link)
    link_component = ui.link(
        text=reference,
        target='#' # Set target to '#' or omit it since we are not opening a URL
    ).classes('text-blue-600 hover:text-blue-800 underline')
    # 2. Attach the Python function to the 'click' event
    # We use a lambda to pass the specific 'reference' string argument to the function
    link_component.on('click', lambda: show_verse_details(reference))
    
    return link_component

def bible_chronology(**_):
    global output_label
    ui.page_title('Bible Chronology')
    
    bible_events = [
        {'year': '2166  BC', 'event': "Abram born", 'reference': 'Gen 11:26; 21:5'},
        {'year': '2156  BC', 'event': "Sarai born", 'reference': 'Gen 17:1, 17'},
        {'year': '2091  BC', 'event': "Abram moves from Haran to Canaan", 'reference': 'Gen 12:4'},
        {'year': '2081  BC', 'event': "Abram marries Hagar", 'reference': 'Gen 16:3'},
        {'year': '2080  BC', 'event': "Ishmael born", 'reference': 'Gen 16:16'},
        {'year': '2067  BC', 'event': "Abram given the name Abraham/Abraham and Ishmael circumcised", 'reference': 'Gen 17:1, 21, 24-25'},
        {'year': '2066  BC', 'event': "Isaac born", 'reference': 'Gen 21:5; 25:26'},
        {'year': '2029  BC', 'event': "Sarah dies", 'reference': 'Gen 23:1'},
        {'year': '2026  BC', 'event': "Isaac marries Rebekah", 'reference': 'Gen 25:20'},
        {'year': '2006  BC', 'event': "Jacob and Esau born", 'reference': 'Gen 25:26'},
        {'year': '1991  BC', 'event': "Abraham dies", 'reference': 'Gen 25:7'},
        {'year': '1966  BC', 'event': "Esau marries Judith and Basemath", 'reference': 'Gen 26:34'},
        {'year': '1943  BC', 'event': "Ishmael dies", 'reference': 'Gen 25:17'},
        {'year': '1930  BC', 'event': "Jacob flees to Paddan Aram", 'reference': 'Gen 29:15-30'},
        {'year': '1923  BC', 'event': "Jacob marries Leah and Rachel", 'reference': 'Gen 29:15-30'},
        {'year': '1922  BC', 'event': "Reuben born", 'reference': 'Gen 29:32'},
        {'year': '1921  BC', 'event': "Simeon born", 'reference': 'Gen 29:33'},
        {'year': '1920  BC', 'event': "Levi born", 'reference': 'Gen 29:34'},
        {'year': '1919  BC', 'event': "Judah born", 'reference': 'Gen 29:35'},
        {'year': '1919  BC', 'event': "Dan born", 'reference': 'Gen 30:1-6'},
        {'year': '1918  BC', 'event': "Naphtali born", 'reference': 'Gen 30:7-8'},
        {'year': '1917  BC', 'event': "Gad born", 'reference': 'Gen 30:9-11'},
        {'year': '1917  BC', 'event': "Issachar born", 'reference': 'Gen 30:17-18'},
        {'year': '1916  BC', 'event': "Zebulun born", 'reference': 'Gen 30: 19-20'},
        {'year': '1916  BC', 'event': "Asher born", 'reference': 'Gen 30:12-13'},
        {'year': '1916  BC', 'event': "Joseph born", 'reference': 'Gen 37:2; 41:46'},
        {'year': '1915  BC', 'event': "Dinah born", 'reference': 'Gen 30:21'},
        {'year': '1910  BC', 'event': "Jacob returns to Canaan", 'reference': 'Gen 31:38, 41'},
        {'year': '1902  BC', 'event': "Jacob moves to Bethel", 'reference': 'Gen 35:1'},
        {'year': '1901  BC', 'event': "Rachel dies; Benjamin born", 'reference': 'Gen 35:16-20'},
        {'year': '1900  BC', 'event': "Jacob settles in Mamre", 'reference': 'Hebron; Gen 35:27'},
        {'year': '1900  BC', 'event': "Judah marries", 'reference': 'Gen 38:1-2'},
        {'year': '1899  BC', 'event': "Joseph sold into slavery in Egypt", 'reference': 'Gen 37:2'},
        {'year': '1899  BC', 'event': "Er born", 'reference': 'Gen 38:3'},
        {'year': '1899-1890  BC', 'event': "Joseph serves Potiphar", 'reference': 'Gen 37:36'},
        {'year': '1897  BC', 'event': "Onan born", 'reference': 'Gen 38:4'},
        {'year': '1895  BC', 'event': "Shelah born", 'reference': 'Gen 38:5'},
        {'year': '1889-1886  BC', 'event': "Joseph in Prison", 'reference': 'Gen 39:20'},
        {'year': '1888  BC', 'event': "Baker and Cupbearer's dreams", 'reference': 'Gen 41:1'},
        {'year': '1886  BC', 'event': "Isaac dies", 'reference': 'Gen 35:28'},
        {'year': '1886  BC', 'event': "Joseph enters Pharaoh's service", 'reference': 'Gen 41:46'},
        {'year': '1885-1879  BC', 'event': "Years of Plenty", 'reference': 'Gen 41:47'},
        {'year': '1879  BC', 'event': "Er and Onan marry Tamar", 'reference': 'Gen 38:6-10'},
        {'year': '1878-1872  BC', 'event': "Years of famiine", 'reference': 'Gen 41:54'},
        {'year': '1878  BC', 'event': "Judah's wife dies", 'reference': 'Gen 38:12'},
        {'year': '1877  BC', 'event': "Perez and Zerah born", 'reference': 'Gen 38:27-30'},
        {'year': '1876  BC', 'event': "Jacob goes to Egypt", 'reference': 'Gen 47:9, 28; Exod 12:40-41'},
        {'year': '1859  BC', 'event': "Jacob dies", 'reference': 'Gen 47:28'},
        {'year': '1806  BC', 'event': "Joseph dies", 'reference': 'Gen 50:22'},
        {'year': '1529  BC', 'event': "Aaron born", 'reference': '1406+123; Exod 7:7; Num 33:39'},
        {'year': '1526  BC', 'event': "Moses born", 'reference': '1406+120; Exod 7:7; Deut 34:7'},
        {'year': '1486  BC', 'event': "Moses flees Egypt", 'reference': 'Acts 7:23'},
        {'year': '1485  BC', 'event': "Caleb born", 'reference': '1400+85; Josh 14:7'},
        {'year': '1446  BC', 'event': "Exodus from Egypt", 'reference': '1 Kgs 6:1'},
        {'year': '1445  BC', 'event': "Tabernacle completed", 'reference': 'Exod 40:2, 17'},
        {'year': '1444  BC', 'event': "Israel leaves Kadesh", 'reference': 'Deut 2:14'},
        {'year': '1407  BC', 'event': "Israel arrives at the Wilderness of Zin; Miriam and Aaron die", 'reference': 'Num 20:1'},
        {'year': '1406  BC', 'event': "Israel enters the Promised Land", 'reference': '1446-40; Josh 4:19'},
        {'year': '1400  BC', 'event': "Joshua gives Hebron to Caleb", 'reference': 'Josh 14:10'},
        {'year': '1332  BC', 'event': "Othniel dies", 'reference': 'Judg 3:11'},
        {'year': '1236  BC', 'event': "Latest possible date for Ehud's death", 'reference': 'Judg 4:1'},
        {'year': '1157  BC', 'event': "Eli born", 'reference': '1 Sam 4:15; Josephus Ant 6:294'},
        {'year': '1133  BC', 'event': "Gideon dies", 'reference': 'Judg 8:34'},
        {'year': '1131  BC', 'event': "Abimelech killed in battle", 'reference': 'Judg 9:54-55'},
        {'year': '1109  BC', 'event': "Tola dies", 'reference': 'Judg 10:2'},
        {'year': '1099  BC', 'event': "Eli begins as high priest/judge", 'reference': '1 Sam 4:18; Josephus Ant. 6:294'},
        {'year': '1088  BC', 'event': "Jair dies", 'reference': 'Judg 10:5'},
        {'year': '1083  BC', 'event': "Jephthah dies", 'reference': 'Judg 12:7'},
        {'year': '1080 BC', 'event': "Birth of Saul", 'reference': 'Birth of Saul'},
        {'year': '1077  BC', 'event': "Ibzan dies", 'reference': 'Judg 12:10'},
        {'year': '1068  BC', 'event': "Elon dies", 'reference': 'Judg 12:11'},
        {'year': '1068  BC', 'event': "Ark in Philistine territory", 'reference': '1 Sam 6:1'},
        {'year': '1067-1049  BC', 'event': "Samson as Judge", 'reference': 'Judg 15:20; 16:31'},
        {'year': '1061  BC', 'event': "Abdon dies", 'reference': 'Judg 12:15'},
        {'year': '1048  BC', 'event': "Saul's reign 40 years", 'reference': 'Acts 13:21; Josephus Ant. 6:378'},
        {'year': '1045  BC', 'event': "Eshbaal/Ishbosheth born", 'reference': '2 Sam 2:10'},
        {'year': '1040  BC', 'event': "David born", 'reference': '2 Sam 5:2'},
        {'year': '1013  BC', 'event': "Mephibosheth born", 'reference': '2 Sam 4:4'},
        {'year': '1010-1009  BC', 'event': "David lives in Philistine territory", 'reference': '1 Sam 27:7'},
        {'year': '1002  BC', 'event': "Jerusalem conquered/Philistines defeated", 'reference': '1 Sam 5 || 1 Chr 11:4-9; 1 Chr 14'},
        {'year': '998  BC', 'event': "Ammonite War begins", 'reference': '2 Sam 10:1–11:1; 12:29–31 || 1 Chr 19:1–20:3'},
        {'year': '997  BC', 'event': "Siege of Ramah", 'reference': '2 Sam 11:1 || 1 Chr 20:1'},
        {'year': '997  BC', 'event': "David and Bathsheba", 'reference': '1 Sam 11'},
        {'year': '994  BC', 'event': "Birth of Solomon", 'reference': '2 Sam 12:24'},
        {'year': '985  BC', 'event': "Amnon rapes Tamar", 'reference': '2 Sam 13:1–22'},
        {'year': '983  BC', 'event': "Absalom murders Amnon", 'reference': '2 Sam 13:23–33'},
        {'year': '982-980  BC', 'event': "Absalom in exile", 'reference': '2 Sam 13:38'},
        {'year': '979-976 BC', 'event': "David's Palace Built", 'reference': ''},
        {'year': '978  BC', 'event': "Absalom received by David", 'reference': '2 Sam 14:28-33'},
        {'year': '975  BC', 'event': "Ark moved to Jerusalem", 'reference': '2 Sam 6 || 1 Chr 13; 16'},
        {'year': '975  BC', 'event': "God's Covenant with David", 'reference': '2 Sam 7 || 1 Chr 17'},
        {'year': '974  BC', 'event': "Absalom's rebellion", 'reference': '2 Sam 15:13–19:43'},
        {'year': '973  BC', 'event': "Sheba's rebellion", 'reference': '2 Sam 20'},
        {'year': '973  BC', 'event': "Rehoboam born", 'reference': '1 Kgs 14:21 || 2 Chr 12:13'},
        {'year': '972  BC', 'event': "David orders a census taken", 'reference': '2 Sam 24 || 1 Chr 21'},
        {'year': '969  BC', 'event': "Adonijah & Joab executed; Abiathar banished; Shimei confined", 'reference': '1 Kgs 2:13-46'},
        {'year': '967  BC', 'event': "Temple begun", 'reference': '1 Kgs 6:1; 2 Chr 3:2'},
        {'year': '966  BC', 'event': "Shimei executed", 'reference': '1 Kgs 2:39'},
        {'year': '961  BC', 'event': "Temple finished", 'reference': '1 Kgs 6:38'},
        {'year': '960  BC', 'event': "Solomon's palace begun", 'reference': '1 Kgs 9:10; 2 Chr 8:1'},
        {'year': '948  BC', 'event': "Solomon's palace finished", 'reference': '1 Kgs 7:1; 9:10; 2 Chr 8:1'},
        {'year': '948  BC', 'event': "Hiram given 20 cities", 'reference': '1 Kgs 9:10-14'},
        {'year': '926  BC', 'event': "Shishak invades", 'reference': '1 Kgs 14:25; 2 Chr 2:12'},
        {'year': '908  BC', 'event': "Jehoshaphat born", 'reference': '1 Kgs 22:42; 2 Chr 20:31'},
        {'year': '906  BC', 'event': "Jehoshaphat born", 'reference': '1 Kgs 22:42; 2 Chr 20:31'},
        {'year': '906-897  BC', 'event': "A decade of rest for Judah", 'reference': '2 Chr 14:1'},
        {'year': '896  BC', 'event': "Zerah defeated by Asa", 'reference': '2 Chr 14:9-15'},
        {'year': '896  BC', 'event': "Shemiah's prophecy & Asa's reforms", 'reference': '2 Chr 15:1-18'},
        {'year': '895  BC', 'event': "Baasha rebuilds Ramah", 'reference': '2 Chr 16:1-6'},
        {'year': '895  BC', 'event': "Hanani's prophecy and imprisonment", 'reference': '2 Chr 16:7-10'},
        {'year': '886  BC', 'event': "Jehoram born", 'reference': '2 Kgs 8:17; 2 Chr 21:5, 20'},
        {'year': '880  BC', 'event': "Jehoram born", 'reference': '2 Kgs 8:17; 2 Chr 21:5, 20'},
        {'year': '874  BC', 'event': "Asa develops a foot disease", 'reference': '2 Chr 16:12'},
        {'year': '868  BC', 'event': "Jehoshaphat sends teachers throughout Israel", 'reference': '2 Chr 17:7'},
        {'year': '863  BC', 'event': "Ahaziah born", 'reference': '2 Kgs 8:26; 2 Chr 22:2'},
        {'year': '855-853  BC', 'event': "No war between Israel and the Armeans", 'reference': '1 Kgs 22:1'},
        {'year': '853  BC', 'event': "Ahab and Jehoshaphat attack Ramoth-Gilead", 'reference': '1 Kgs 22:2'},
        {'year': '853  BC', 'event': "Jehu's prophecy", 'reference': '2 Chr 19:1-3'},
        {'year': '852  BC', 'event': "Jehoshaphat's fleet wrecked", 'reference': '1 Kgs 22:48-49; 2 Chr 20:35-37'},
        {'year': '852  BC', 'event': "Elijah taken to heaven", 'reference': '2 Kgs 2:1-14'},
        {'year': '842  BC', 'event': "Joash born", 'reference': '2 Kgs 11:21; 2 Chr 24:1'},
        {'year': '842-841  BC', 'event': "Jehoram suffers from a bowel disease", 'reference': '2 Chr 21:19'},
        {'year': '840-835  BC', 'event': "Joash hidden in the Temple", 'reference': '2 Kgs 11:3; 2 Chr 22:12'},
        {'year': '821  BC', 'event': "Amaziah born", 'reference': '2 Kgs 14:1; 2 Chr 25:1'},
        {'year': '813  BC', 'event': "Joash admonishes the priests", 'reference': '2 Kgs 12:4-8'},
        {'year': '813  BC', 'event': "Joash pays tribute to Hazael", 'reference': '2 Kgs 12:17-18'},
        {'year': '807  BC', 'event': "Azariah/Uzziah born", 'reference': '2 Kgs 14:21; 15:2; 2 Chr 26:1, 3'},
        {'year': '796  BC', 'event': "Prophecy and assassination of the high priest Zechariah", 'reference': '2 Chr 24:2022'},
        {'year': '775  BC', 'event': "Jotham born", 'reference': '2 Kgs 15:33; 2 Chr 27:1'},
        {'year': '755  BC', 'event': "Ahaz born", 'reference': '2 Kgs 16:2; 2 Chr 28:1'},
        {'year': '750  BC', 'event': "Uzziah attempts to burn incense before the Lord", 'reference': '2 Kgs 15:5-6; 2 Chr 26:16-21'},
        {'year': '741  BC', 'event': "Hezekiah born", 'reference': '2 Kgs 18:2; 2 Chr 29:1 / Isaiah 6'},
        {'year': '740 BC', 'event': "Isaiah 6", 'reference': 'Isaiah 6'},
        {'year': '738  BC', 'event': "Jotham defeats Ammon", 'reference': '2 Chr 27:5'},
        {'year': '738-736 BC', 'event': "Jotham recieves tribute from Ammon", 'reference': 'Jotham recieves tribute from Ammon'},
        {'year': '725-723  BC', 'event': "Samaria besieged", 'reference': '2 Kgs 18:9'},
        {'year': '723  BC', 'event': "Fall of Samaria", 'reference': '2 Kgs 18:10'},
        {'year': '715  BC', 'event': "Hezekiah repairs the doors of the Temple", 'reference': '2 Chr 29:3 / Isaiah 14:28-32'},
        {'year': '711-709  BC', 'event': "Isaiah naked and barefoot", 'reference': 'Isa 20:1-2'},
        {'year': '709  BC', 'event': "Manasseh born", 'reference': '2 Kgs 21:1; 2 Chr 33:1'},
        {'year': '701  BC', 'event': "Sennacherib besieges Jerusalem", 'reference': '2 Kgs 18:13; Isa 36:1'},
        {'year': '701  BC', 'event': "Hezekiah's sickness", 'reference': '2 Kgs 20:1–11'},
        {'year': '665  BC', 'event': "Amon born", 'reference': '2 Kgs 21:19; 2 Chr 33:21'},
        {'year': '649  BC', 'event': "Josiah born", 'reference': '2 Kgs 22:1; 2 Chr 34:1'},
        {'year': '634 BC', 'event': "Jehoiakim born", 'reference': 'Jehoiakim born'},
        {'year': '633  BC', 'event': "Josiah seeks the Lord", 'reference': '2 Chr 34:3'},
        {'year': '632  BC', 'event': "Jehoahaz born", 'reference': '2 Kgs 23:31; 2 Chr 36:2'},
        {'year': '629  BC', 'event': "Josiah purges the high places", 'reference': '2 Chr 34:3'},
        {'year': '629  BC', 'event': "Jeremiah is called to be a prophet", 'reference': 'Jer 1:4-19'},
        {'year': '624  BC', 'event': "Torah found in the Temple", 'reference': '2 Kgs 22:3; 2 Chr 34:8'},
        {'year': '623  BC', 'event': "Passover celebrated", 'reference': '2 Kgs 23:23; 2 Chr 35:19; b. Meg. 14b'},
        {'year': '623  BC', 'event': "Ezekiel born", 'reference': 'Ezek 1:1'},
        {'year': '618  BC', 'event': "Zedekiah born", 'reference': '2 Kgs 24:8; 2 Chr 36:11; Jer 52:1'},
        {'year': '616  BC', 'event': "Jehoiakin born", 'reference': '2 Kgs 24:8; 2 Chr 36:9'},
        {'year': '609 BC', 'event': "Jeremiah 26", 'reference': 'Jeremiah 26'},
        {'year': '605  BC', 'event': "Jerusalem beseiged by Nebuchadnezzar", 'reference': '2 Kgs 24:1 / Jeremiah 25, 36, 45 / Daniel 1:1'},
        {'year': '604  BC', 'event': "Daniel refuses to eat from the king's table", 'reference': 'Dan 1:3-17'},
        {'year': '603 BC', 'event': "Dan 1:18-20; Dan 2", 'reference': 'Dan 1:18-20; Dan 2'},
        {'year': '598  BC', 'event': "Nebuchadnezzar takes captives", 'reference': 'Jer 52:28'},
        {'year': '597  BC', 'event': "Jerusalem besiged by Nebuchadnezzar", 'reference': '2 Kgs 24:10; 2 Chr 36:10 / Jer 24, 27, 29'},
        {'year': '594 BC', 'event': "Jer 51:59-64; Jer 27 --28; Daniel 3", 'reference': 'Jer 51:59-64; Jer 27 --28; Daniel 3'},
        {'year': '593 BC', 'event': "Ezek 1 —5; Ezek 6 --7", 'reference': 'Ezek 1 —5; Ezek 6 --7'},
        {'year': '592 BC', 'event': "Ezek 8 —19", 'reference': 'Ezek 8 —19'},
        {'year': '591 BC', 'event': "Ezek 20 —23", 'reference': 'Ezek 20 —23'},
        {'year': '589  BC', 'event': "Jerusalem beseiged by Nebuchadnezzar", 'reference': '2 Kgs 25:1; Jer 32:1; 52:4 / Jer 37 --38'},
        {'year': '588 BC', 'event': "Jer 21 --23, 31, 33--34; Ezek 24 --25; 29:1-16", 'reference': 'Jer 21 --23, 31, 33--34; Ezek 24 --25; 29:1-16'},
        {'year': '587  BC', 'event': "Jerusalem falls", 'reference': '2 Kgs 25:8; Jer 39:2; 52:5, 12 / Ezek 26 --28; 30:20--31:18; Jer 44'},
        {'year': '586 BC', 'event': "Ezek 32:1 --39:29", 'reference': 'Ezek 32:1 --39:29'},
        {'year': '582  BC', 'event': "Nebuzaradan takes captives", 'reference': 'Jer 52:30'},
        {'year': '574  BC', 'event': "Ezekiel's vision of a new Jerusalem", 'reference': 'Ezek 40 --48; b. Arak. 12a'},
        {'year': '571 BC', 'event': "Ezek 29:17 --30:19", 'reference': 'Ezek 29:17 --30:19'},
        {'year': '561  BC', 'event': "Jehoiachin freed from prison", 'reference': '2 Kgs 25:27; Jer 52:31'},
        {'year': '550 BC', 'event': "Dan 7", 'reference': 'Dan 7'},
        {'year': '548 BC', 'event': "Dan 8", 'reference': 'Dan 8'},
        {'year': '539 BC', 'event': "Dan 5; Dan 6", 'reference': 'Dan 5; Dan 6'},
        {'year': '538  BC', 'event': "Cyrus' decree", 'reference': '2 Chr 36:22; Ezra 1:1; 5:13; 6:3 / Dan 9'},
        {'year': '536 BC', 'event': "Dan 10 —12", 'reference': 'Dan 10 —12'},
        {'year': '533  BC', 'event': "Altar rebuilt", 'reference': 'Ezra 3:2'},
        {'year': '532  BC', 'event': "Temple begun", 'reference': 'Ezra 3:8'},
        {'year': '531  BC', 'event': "Temple work stopped", 'reference': 'Ezra 4:4-5'},
        {'year': '520  BC', 'event': "Temple work resumed", 'reference': 'Ezra 4:24 /Haggai/ Zech 1:1-6'},
        {'year': '519 BC', 'event': "Zech 1:7 --6:15", 'reference': 'Zech 1:7 --6:15'},
        {'year': '518 BC', 'event': "Zech 7 --8", 'reference': 'Zech 7 --8'},
        {'year': '515  BC', 'event': "Temple dedicated", 'reference': 'Ezra 6:15'},
        {'year': '486  BC', 'event': "Letter written to Xerxes", 'reference': 'Ezra 4:6'},
        {'year': '483  BC', 'event': "Xerxes' 180-day banquet", 'reference': 'Esth 3:1'},
        {'year': '482  BC', 'event': "Xerxes' 7-day feast", 'reference': 'Esth 1:5'},
        {'year': '479  BC', 'event': "Esther's 12-month preparation", 'reference': 'Esth 2:12'},
        {'year': '478  BC', 'event': "Esther presented to Xerxes", 'reference': 'Esth 2:16'},
        {'year': '474  BC', 'event': "Haman's plot/Mordecai's triumph", 'reference': 'Esth 3-9'},
        {'year': '473  BC', 'event': "The first celebration of Purim", 'reference': 'Esth 9:17'},
        {'year': '458  BC', 'event': "Ezra goes to Jerusalem", 'reference': 'Ezra 7:7-8'},
        {'year': '446  BC', 'event': "Nehemiah receives word about Jerusalem's walls", 'reference': 'Neh 1:1; 2:1'},
        {'year': '445-433  BC', 'event': "Nehemiah's first term as governor", 'reference': 'Neh 5:14'},
        {'year': '445  BC', 'event': "Walls of Jerusalem rebuilt", 'reference': 'Neh 6:15'},
        {'year': '433  BC', 'event': "Nehemiah returns to Susa", 'reference': 'Neh 13:6'},
        {'year': '429  BC', 'event': "Nehemiah comes to Jerusalem for a second time", 'reference': 'Neh 13'},
        {'year': '175  BC', 'event': "Antiochus IV begins to reign", 'reference': '1 Macc 1:10'},
        {'year': '169  BC', 'event': "Antiochus IV sacks the Temple in Jerusalem", 'reference': '1 Macc 1:20'},
        {'year': '167  BC', 'event': "Antiochus' forces desecrate the altar in Jerusalem", 'reference': '15 Kislev; 1 Macc 1:54'},
        {'year': '166  BC', 'event': "Mattathias dies", 'reference': '1 Macc 2:70'},
        {'year': '164  BC', 'event': "Battle of Beth-Zur", 'reference': '1 Macc 4:28-35'},
        {'year': '164  BC', 'event': "Temple in Jerusalem cleansed", 'reference': '25 Kislev; 1 Mac 4:52'},
        {'year': '163  BC', 'event': "Antiochus attacks Judas", 'reference': '2 Macc 13:1'},
        {'year': '162  BC', 'event': "Attack on the citadel in Jerusalem and second battle of Beth-Zur", 'reference': '1 Macc 6:18-54'},
        {'year': '161  BC', 'event': "Demetrius deposes Antiochus V", 'reference': '2 Macc 14:1'},
        {'year': '161  BC', 'event': "Alcimus seeks high priesthood", 'reference': '2 Macc 14:4'},
        {'year': '160  BC', 'event': "Demetrius' forces attack Jerusalem", 'reference': 'Nisan; 1 Macc 9:1-22'},
        {'year': '159  BC', 'event': "Alcimus orders the Temple's inner courtyard wall torn down", 'reference': 'Iyyar; 1 Macc 9:54'},
        {'year': '152  BC', 'event': "Jonathan appointed high priest by Alexander Balas", 'reference': 'Tishri; 1 Macc 10:21'},
        {'year': '143  BC', 'event': "Letter to Jews in Egypt", 'reference': '2 Macc 1:7'},
        {'year': '142  BC', 'event': "Demetrius II frees Judah from taxation", 'reference': '1 Macc 13:41'},
        {'year': '141  BC', 'event': "Simon conquers the citadel in Jerusalem", 'reference': '23 Iyyar; 1 Macc 13:51'},
        {'year': '140  BC', 'event': "Monument erected in honor of Simon", 'reference': '18 Elul; 1 Macc 14:27'},
        {'year': '134  BC', 'event': "Simon assasinated", 'reference': 'Shebat; 1 Macc 16:11-17'},
        {'year': '124  BC', 'event': "Letter from Jews in Jerusalem to Jews in Egypt", 'reference': '2 Macc 1:9'},
        {'year': '63  BC', 'event': "Pompey takes Jerusalem", 'reference': '10 Tishri/October 23'},
        {'year': '49 BC', 'event': "Aristobulus dies", 'reference': 'Aristobulus dies'},
        {'year': '47  BC', 'event': "Herod made governor of Galilee", 'reference': 'Ant. 14.158'},
        {'year': '44  BC', 'event': "Death of Julius Caesar", 'reference': 'March 15'},
        {'year': '39  BC', 'event': "Herod Appointed by Romans", 'reference': 'Josephus, Ant. 14.389; War 1.344'},
        {'year': '36  BC', 'event': "Herod takes Jerusalem", 'reference': '10 Tishri/October 7; Josephus, Ant. 14.487-488; War 1.343'},
        {'year': '31  BC', 'event': "Battle of Actium, September 2", 'reference': 'Josephus, Ant. 15.121'},
        {'year': '30 BC', 'event': "Caesar in Egypt/Palestine; Hyrcanus II dies", 'reference': 'Caesar in Egypt/Palestine; Hyrcanus II dies'},
        {'year': '20  BC', 'event': "Ceasar to Syria (Spring) Temple begun", 'reference': 'Josephus, Ant. 15.354, 380; War 1.398-399, 401'},
        {'year': '18  BC', 'event': "Temple finished", 'reference': 'after 1 year, 6 months; Josephus, Ant. 15.421'},
        {'year': '12  BC', 'event': "Temple court finished", 'reference': 'Josephus, Ant. 15.420'},
        {'year': '10  BC', 'event': "Ceasarea Sebaste completed", 'reference': 'Josephus, Ant. 16.136, War 1.415'},
        {'year': '4  BC', 'event': "Magi observe the star", 'reference': 'Matt 2:7, 16'},
        {'year': '3  BC', 'event': "Census by Quirinius", 'reference': 'Luke 2:14'},
        {'year': '3  BC', 'event': "Tax revolt of Judas", 'reference': 'Acts 5:37'},
        {'year': '3  BC', 'event': "birth of John", 'reference': 'Luke 1:26, 36'},
        {'year': '2  BC', 'event': "Birth of Jesus; Flight to Egypt", 'reference': 'Matt 2:15'},
        {'year': '1  BC', 'event': "Death of Herod", 'reference': 'before 14 Nisan/April 1; Josephus, Ant. 17.156-191'},
        {'year': '10  AD', 'event': "Jesus in Temple", 'reference': 'Nisan'},
        {'year': '14  AD', 'event': "Death of Augustus (Aug 19); Tiberius named emperor (Sep 17)", 'reference': ''},
        {'year': '29  AD', 'event': "Jesus' Baptism", 'reference': 'summer; Luke 3:1'},
        {'year': '30  AD', 'event': "1st passover (Nisan)", 'reference': 'John 2:13, 20, 23'},
        {'year': '31  AD', 'event': "Succoth", 'reference': 'Tishri; John 5:1'},
        {'year': '32  AD', 'event': "3rd passover", 'reference': 'Nisan; John 6:4'},
        {'year': '32  AD', 'event': "Succoth", 'reference': 'John 7:1'},
        {'year': '32  AD', 'event': "Dedication", 'reference': 'John 10:32'},
        {'year': '33  AD', 'event': "4th passover", 'reference': 'John 12:1'},
        {'year': '33  AD', 'event': "Crucifixion", 'reference': 'Nisan; Matt 26:17; Mark 14:12; Luke 22:7; John 11:55'},
        {'year': '33  AD', 'event': "Ascension", 'reference': 'Acts 1:6-11'},
        {'year': '33  AD', 'event': "Matthias replaces Judas", 'reference': 'Acts 1:12-26'},
        {'year': '33  AD', 'event': "Pentecost", 'reference': 'Acts 2:1-41'},
        {'year': '33  AD', 'event': "Lame Beggar healed/Peter & John before the Sanhedrin", 'reference': 'Acts 3:1 --4:31'},
        {'year': '34  AD', 'event': "Ananias and Sapphira", 'reference': 'Acts 5:1-11'},
        {'year': '34  AD', 'event': "Apostles arrested", 'reference': 'Acts 5:17-41'},
        {'year': '35  AD', 'event': "Seven Chosen", 'reference': 'Acts 6:1-6'},
        {'year': '36  AD', 'event': "Martyrdom of Stephen", 'reference': 'Acts 6:8 --8:3'},
        {'year': '36  AD', 'event': "Missionary work of Philip", 'reference': 'Acts 8:4-40'},
        {'year': '36  AD', 'event': "Conversion of Saul/Paul", 'reference': 'Acts 9:1-19'},
        {'year': '37  AD', 'event': "Paul in Arabia and back to Damascus", 'reference': 'Gal 1:17'},
        {'year': '37  AD', 'event': "Death of Tiberius", 'reference': 'Mar 16'},
        {'year': '37  AD', 'event': "Caligula named emperor", 'reference': 'Aug 31'},
        {'year': '38  AD', 'event': "Paul escapes Damascus and goes to Jerusalem, Caesarea Maritima, Tarsus", 'reference': 'Acts 9:23-31'},
        {'year': '39  AD', 'event': "Peter in Lydda, Joppa, Caesarea Maritima", 'reference': 'Acts 9:32 --10:48'},
        {'year': '39  AD', 'event': "Peter returns to Jerusalem", 'reference': 'Acts 11:1-18'},
        {'year': '39  AD', 'event': "Hellenists evangelized in Antioch; Barnabas to Antioch", 'reference': 'Acts 11:19-24'},
        {'year': '40  AD', 'event': "Barnabas & Paul in Antioch", 'reference': 'Acts 11:25-26'},
        {'year': '41  AD', 'event': "Prophecy of Agabus", 'reference': 'Acts 11:27-28'},
        {'year': '41  AD', 'event': "Caligula assassinated", 'reference': 'Jan 24'},
        {'year': '41  AD', 'event': "Claudius named emperor", 'reference': 'Jan 24'},
        {'year': '42  AD', 'event': "James martyred", 'reference': 'Acts 12:2'},
        {'year': '43  AD', 'event': "Peter imprisoned; Passover; Peter leaves Jerusalem", 'reference': 'Acts 12:3-19'},
        {'year': '43  AD', 'event': "Death of Herod Agrippa", 'reference': 'Acts 12:20-23'},
        {'year': '43  AD', 'event': "Paul and Barnabas deliver aid to Judea", 'reference': 'Acts 11:30'},
        {'year': '43  AD', 'event': "Paul and Barnabas return to Antioch with John Mark", 'reference': 'Acts 12: 25'},
        {'year': '45-48  AD', 'event': "Paul's First Missionary Journey, 45-48", 'reference': 'Acts 13:1 --14:28'},
        {'year': '49  AD', 'event': "Jerusalem Conference --early AD 49", 'reference': '15:1-35; Gal 2:1-10'},
        {'year': '49  AD', 'event': "Peter visits the church in Antioch", 'reference': 'Gal 2:11-14'},
        {'year': '49  AD', 'event': "Paul to Macedonia; Mark & Barnabas to Cyprus", 'reference': 'Acts 15:36 --16:10'},
        {'year': '49-51  AD', 'event': "Paul's Second Missionary Journey, 49-51", 'reference': 'Acts 15:39 --18:22'},
        {'year': '52-55  AD', 'event': "Paul's Third Missionary Journey, 52-55", 'reference': 'Acts 18:23 --21:17'},
        {'year': '54  AD', 'event': "Death of Claudius (Oct 13) Nero named emperor (Oct 13)", 'reference': ''},
        {'year': '55-57  AD', 'event': "Paul imprisoned in Caesarea, 55-57", 'reference': 'Acts 23:23 --26:32'},
        {'year': '57-58  AD', 'event': "Paul's Journey to Rome, 57-58", 'reference': 'Acts 23:23 --26:32'},
        {'year': '58-60  AD', 'event': "Paul in custody in Rome", 'reference': 'Acts 28:17-31'},
        {'year': '60-64  AD', 'event': "Paul in Spain", 'reference': 'cf. Rom 15:24, 28'},
        {'year': '62  AD', 'event': "James, brother of Jesus, martyred", 'reference': 'Josephus, Ant. 20.200'},
        {'year': '64  AD', 'event': "Paul leaves Titus in Crete", 'reference': 'Tit 1:5'},
        {'year': '64  AD', 'event': "Great Fire in Rome", 'reference': '18-19 July'},
        {'year': '65  AD', 'event': "Paul leavesTimothy in Ephesus", 'reference': '1 Tim 1:3'},
        {'year': '65  AD', 'event': "Paul in Macedonia", 'reference': '1 Tim 1:3'},
        {'year': '65  AD', 'event': "Paul spends winter in Nicopolis", 'reference': 'Tit 3:12'},
        {'year': '66  AD', 'event': "Paul in Ephesus", 'reference': '2 Tim 1:4, 18'},
        {'year': '66  AD', 'event': "Paul spends winter in Troas", 'reference': '2 Tim 4:14'},
        {'year': '67  AD', 'event': "Paul arrested and sent to Rome", 'reference': '2 Tim 4:16'},
        {'year': '68  AD', 'event': "Paul and Peter martyred; Nero commits suicide (Jun 9) Galba Jun 8, 68--Jan 15, 69", 'reference': ''},
        {'year': '69  AD', 'event': "Otho Jan 15--April 16, 69; Vitellius Apr 16-Dec 20, 69; Vespasian named emperor (Dec 21)", 'reference': ''},
        {'year': '70  AD', 'event': "Titus takes Jerusalem (Aug/Ab; Ant. 20:250)", 'reference': ''},
    ]

    with ui.card().classes('w-full max-w-lg'):
        ui.label('📜 Bible Chronology').classes('text-2xl font-bold mb-4')
        with ui.timeline(side='right'):
            for item in bible_events:
                # Create the interactive link
                ref_link = create_internal_link(item['reference'])
                
                with ui.timeline_entry(
                    title=item['event'],
                    subtitle=item['year'],
                    icon='menu_book'
                ):
                    with ui.row():
                        ref_link
                        
        # The element whose text is updated by the function
        output_label
