"""
PySubtrans.Providers - Translation service provider implementations

This module contains all provider implementations. Explicit imports ensure
all providers are available regardless of installation method.
"""

# Explicitly import all provider modules to ensure they're registered
# This is required for pip-installed packages where dynamic discovery may fail
from . import Provider_Azure
from . import Provider_Bedrock
from . import Provider_Claude
from . import Provider_Custom
from . import Provider_DeepSeek
from . import Provider_Gemini
from . import Provider_Mistral
from . import Provider_OpenAI
from . import Provider_OpenRouter

