"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupableResourcesCollector = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const ec2 = require("@aws-cdk/aws-ec2");
const efs = require("@aws-cdk/aws-efs");
const rds = require("@aws-cdk/aws-rds");
const core_1 = require("@aws-cdk/core");
class BackupableResourcesCollector {
    constructor() {
        this.resources = [];
    }
    visit(node) {
        if (node instanceof efs.CfnFileSystem) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'elasticfilesystem',
                resource: 'file-system',
                resourceName: node.ref,
            }));
        }
        if (node instanceof dynamodb.CfnTable) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'dynamodb',
                resource: 'table',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'instance',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnVolume) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'volume',
                resourceName: node.ref,
            }));
        }
        if (node instanceof rds.CfnDBInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'rds',
                resource: 'db',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: node.ref,
            }));
        }
    }
}
exports.BackupableResourcesCollector = BackupableResourcesCollector;
//# sourceMappingURL=data:application/json;base64,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