# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterTemplateArgs', 'ClusterTemplate']

@pulumi.input_type
class ClusterTemplateArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_revisions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]]] = None):
        """
        The set of arguments for constructing a ClusterTemplate resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the cluster template (map)
        :param pulumi.Input[_builtins.str] description: Cluster template description
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the cluster template (map)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]] members: Cluster template members (list)
        :param pulumi.Input[_builtins.str] name: The cluster template name (string)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]] template_revisions: Cluster template revisions (list)
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_revisions is not None:
            pulumi.set(__self__, "template_revisions", template_revisions)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the cluster template (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster template description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the cluster template (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]]]:
        """
        Cluster template members (list)
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster template name (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="templateRevisions")
    def template_revisions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]]]:
        """
        Cluster template revisions (list)
        """
        return pulumi.get(self, "template_revisions")

    @template_revisions.setter
    def template_revisions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]]]):
        pulumi.set(self, "template_revisions", value)


@pulumi.input_type
class _ClusterTemplateState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_revisions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]]] = None):
        """
        Input properties used for looking up and filtering ClusterTemplate resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the cluster template (map)
        :param pulumi.Input[_builtins.str] default_revision_id: (Computed) Default cluster template revision ID (string)
        :param pulumi.Input[_builtins.str] description: Cluster template description
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the cluster template (map)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]] members: Cluster template members (list)
        :param pulumi.Input[_builtins.str] name: The cluster template name (string)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]] template_revisions: Cluster template revisions (list)
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if default_revision_id is not None:
            pulumi.set(__self__, "default_revision_id", default_revision_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_revisions is not None:
            pulumi.set(__self__, "template_revisions", template_revisions)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the cluster template (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="defaultRevisionId")
    def default_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) Default cluster template revision ID (string)
        """
        return pulumi.get(self, "default_revision_id")

    @default_revision_id.setter
    def default_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_revision_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster template description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the cluster template (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]]]:
        """
        Cluster template members (list)
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster template name (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="templateRevisions")
    def template_revisions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]]]:
        """
        Cluster template revisions (list)
        """
        return pulumi.get(self, "template_revisions")

    @template_revisions.setter
    def template_revisions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTemplateTemplateRevisionArgs']]]]):
        pulumi.set(self, "template_revisions", value)


@pulumi.type_token("rancher2:index/clusterTemplate:ClusterTemplate")
class ClusterTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateMemberArgs', 'ClusterTemplateMemberArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_revisions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateTemplateRevisionArgs', 'ClusterTemplateTemplateRevisionArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Cluster Template resource. This can be used to create Cluster Templates for Rancher v2 RKE clusters and retrieve their information.

        Cluster Templates are available from Rancher v2.3.x and above.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cluster Template
        foo = rancher2.ClusterTemplate("foo",
            name="foo",
            members=[{
                "access_type": "owner",
                "user_principal_id": "local://user-XXXXX",
            }],
            template_revisions=[{
                "name": "V1",
                "cluster_config": {
                    "rke_config": {
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                    },
                },
                "default": True,
            }],
            description="Terraform cluster template foo")
        ```

        Creating Rancher v2 RKE cluster template with upgrade strategy. For Rancher v2.4.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cluster Template
        foo = rancher2.ClusterTemplate("foo",
            name="foo",
            members=[{
                "access_type": "owner",
                "user_principal_id": "local://user-XXXXX",
            }],
            template_revisions=[{
                "name": "V1",
                "cluster_config": {
                    "rke_config": {
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                        "upgrade_strategy": {
                            "drain": True,
                            "max_unavailable_worker": "20%",
                        },
                    },
                },
                "default": True,
            }],
            description="Terraform cluster template foo")
        ```

        ## Import

        Cluster Template can be imported using the rancher Cluster Template ID

        ```sh
        $ pulumi import rancher2:index/clusterTemplate:ClusterTemplate foo &lt;CLUSTER_TEMPLATE_ID&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the cluster template (map)
        :param pulumi.Input[_builtins.str] description: Cluster template description
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the cluster template (map)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateMemberArgs', 'ClusterTemplateMemberArgsDict']]]] members: Cluster template members (list)
        :param pulumi.Input[_builtins.str] name: The cluster template name (string)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateTemplateRevisionArgs', 'ClusterTemplateTemplateRevisionArgsDict']]]] template_revisions: Cluster template revisions (list)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Cluster Template resource. This can be used to create Cluster Templates for Rancher v2 RKE clusters and retrieve their information.

        Cluster Templates are available from Rancher v2.3.x and above.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cluster Template
        foo = rancher2.ClusterTemplate("foo",
            name="foo",
            members=[{
                "access_type": "owner",
                "user_principal_id": "local://user-XXXXX",
            }],
            template_revisions=[{
                "name": "V1",
                "cluster_config": {
                    "rke_config": {
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                    },
                },
                "default": True,
            }],
            description="Terraform cluster template foo")
        ```

        Creating Rancher v2 RKE cluster template with upgrade strategy. For Rancher v2.4.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cluster Template
        foo = rancher2.ClusterTemplate("foo",
            name="foo",
            members=[{
                "access_type": "owner",
                "user_principal_id": "local://user-XXXXX",
            }],
            template_revisions=[{
                "name": "V1",
                "cluster_config": {
                    "rke_config": {
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                        "upgrade_strategy": {
                            "drain": True,
                            "max_unavailable_worker": "20%",
                        },
                    },
                },
                "default": True,
            }],
            description="Terraform cluster template foo")
        ```

        ## Import

        Cluster Template can be imported using the rancher Cluster Template ID

        ```sh
        $ pulumi import rancher2:index/clusterTemplate:ClusterTemplate foo &lt;CLUSTER_TEMPLATE_ID&gt;
        ```

        :param str resource_name: The name of the resource.
        :param ClusterTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateMemberArgs', 'ClusterTemplateMemberArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_revisions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateTemplateRevisionArgs', 'ClusterTemplateTemplateRevisionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterTemplateArgs.__new__(ClusterTemplateArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["members"] = members
            __props__.__dict__["name"] = name
            __props__.__dict__["template_revisions"] = template_revisions
            __props__.__dict__["default_revision_id"] = None
        super(ClusterTemplate, __self__).__init__(
            'rancher2:index/clusterTemplate:ClusterTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            default_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateMemberArgs', 'ClusterTemplateMemberArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            template_revisions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateTemplateRevisionArgs', 'ClusterTemplateTemplateRevisionArgsDict']]]]] = None) -> 'ClusterTemplate':
        """
        Get an existing ClusterTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the cluster template (map)
        :param pulumi.Input[_builtins.str] default_revision_id: (Computed) Default cluster template revision ID (string)
        :param pulumi.Input[_builtins.str] description: Cluster template description
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the cluster template (map)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateMemberArgs', 'ClusterTemplateMemberArgsDict']]]] members: Cluster template members (list)
        :param pulumi.Input[_builtins.str] name: The cluster template name (string)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterTemplateTemplateRevisionArgs', 'ClusterTemplateTemplateRevisionArgsDict']]]] template_revisions: Cluster template revisions (list)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterTemplateState.__new__(_ClusterTemplateState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["default_revision_id"] = default_revision_id
        __props__.__dict__["description"] = description
        __props__.__dict__["labels"] = labels
        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        __props__.__dict__["template_revisions"] = template_revisions
        return ClusterTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations for the cluster template (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="defaultRevisionId")
    def default_revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) Default cluster template revision ID (string)
        """
        return pulumi.get(self, "default_revision_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster template description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels for the cluster template (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterTemplateMember']]]:
        """
        Cluster template members (list)
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster template name (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="templateRevisions")
    def template_revisions(self) -> pulumi.Output[Sequence['outputs.ClusterTemplateTemplateRevision']]:
        """
        Cluster template revisions (list)
        """
        return pulumi.get(self, "template_revisions")

