# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoleTemplateArgs', 'RoleTemplate']

@pulumi.input_type
class RoleTemplateArgs:
    def __init__(__self__, *,
                 administrative: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 default_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]]] = None,
                 hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]]] = None):
        """
        The set of arguments for constructing a RoleTemplate resource.
        :param pulumi.Input[_builtins.bool] administrative: Administrative role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for role template object (map)
        :param pulumi.Input[_builtins.str] context: Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        :param pulumi.Input[_builtins.bool] default_role: Default role template for new created cluster or project. Default `false` (bool)
        :param pulumi.Input[_builtins.str] description: Role template description (string)
        :param pulumi.Input[_builtins.bool] external: External role template. Default `false` (bool)
        :param pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]] external_rules: External rules used for authorization. This field is required when `external=true` and no underlying ClusterRole exists. (list)
        :param pulumi.Input[_builtins.bool] hidden: Hidden role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for role template object (map)
        :param pulumi.Input[_builtins.bool] locked: Locked role template. Default `false` (bool)
        :param pulumi.Input[_builtins.str] name: Role template name (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_template_ids: Inherit role template IDs (list)
        :param pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]] rules: Role template policy rules (list)
        """
        if administrative is not None:
            pulumi.set(__self__, "administrative", administrative)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if default_role is not None:
            pulumi.set(__self__, "default_role", default_role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if external_rules is not None:
            pulumi.set(__self__, "external_rules", external_rules)
        if hidden is not None:
            pulumi.set(__self__, "hidden", hidden)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_template_ids is not None:
            pulumi.set(__self__, "role_template_ids", role_template_ids)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def administrative(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Administrative role template. Default `false` (bool)
        """
        return pulumi.get(self, "administrative")

    @administrative.setter
    def administrative(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "administrative", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for role template object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Default role template for new created cluster or project. Default `false` (bool)
        """
        return pulumi.get(self, "default_role")

    @default_role.setter
    def default_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_role", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role template description (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        External role template. Default `false` (bool)
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external", value)

    @_builtins.property
    @pulumi.getter(name="externalRules")
    def external_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]]]:
        """
        External rules used for authorization. This field is required when `external=true` and no underlying ClusterRole exists. (list)
        """
        return pulumi.get(self, "external_rules")

    @external_rules.setter
    def external_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]]]):
        pulumi.set(self, "external_rules", value)

    @_builtins.property
    @pulumi.getter
    def hidden(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Hidden role template. Default `false` (bool)
        """
        return pulumi.get(self, "hidden")

    @hidden.setter
    def hidden(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hidden", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for role template object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Locked role template. Default `false` (bool)
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role template name (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="roleTemplateIds")
    def role_template_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Inherit role template IDs (list)
        """
        return pulumi.get(self, "role_template_ids")

    @role_template_ids.setter
    def role_template_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "role_template_ids", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]]]:
        """
        Role template policy rules (list)
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _RoleTemplateState:
    def __init__(__self__, *,
                 administrative: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 builtin: Optional[pulumi.Input[_builtins.bool]] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 default_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]]] = None,
                 hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering RoleTemplate resources.
        :param pulumi.Input[_builtins.bool] administrative: Administrative role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for role template object (map)
        :param pulumi.Input[_builtins.bool] builtin: (Computed) Builtin role template (string)
        :param pulumi.Input[_builtins.str] context: Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        :param pulumi.Input[_builtins.bool] default_role: Default role template for new created cluster or project. Default `false` (bool)
        :param pulumi.Input[_builtins.str] description: Role template description (string)
        :param pulumi.Input[_builtins.bool] external: External role template. Default `false` (bool)
        :param pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]] external_rules: External rules used for authorization. This field is required when `external=true` and no underlying ClusterRole exists. (list)
        :param pulumi.Input[_builtins.bool] hidden: Hidden role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for role template object (map)
        :param pulumi.Input[_builtins.bool] locked: Locked role template. Default `false` (bool)
        :param pulumi.Input[_builtins.str] name: Role template name (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_template_ids: Inherit role template IDs (list)
        :param pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]] rules: Role template policy rules (list)
        """
        if administrative is not None:
            pulumi.set(__self__, "administrative", administrative)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if builtin is not None:
            pulumi.set(__self__, "builtin", builtin)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if default_role is not None:
            pulumi.set(__self__, "default_role", default_role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if external_rules is not None:
            pulumi.set(__self__, "external_rules", external_rules)
        if hidden is not None:
            pulumi.set(__self__, "hidden", hidden)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_template_ids is not None:
            pulumi.set(__self__, "role_template_ids", role_template_ids)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def administrative(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Administrative role template. Default `false` (bool)
        """
        return pulumi.get(self, "administrative")

    @administrative.setter
    def administrative(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "administrative", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for role template object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def builtin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Computed) Builtin role template (string)
        """
        return pulumi.get(self, "builtin")

    @builtin.setter
    def builtin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "builtin", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Default role template for new created cluster or project. Default `false` (bool)
        """
        return pulumi.get(self, "default_role")

    @default_role.setter
    def default_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_role", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role template description (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        External role template. Default `false` (bool)
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external", value)

    @_builtins.property
    @pulumi.getter(name="externalRules")
    def external_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]]]:
        """
        External rules used for authorization. This field is required when `external=true` and no underlying ClusterRole exists. (list)
        """
        return pulumi.get(self, "external_rules")

    @external_rules.setter
    def external_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateExternalRuleArgs']]]]):
        pulumi.set(self, "external_rules", value)

    @_builtins.property
    @pulumi.getter
    def hidden(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Hidden role template. Default `false` (bool)
        """
        return pulumi.get(self, "hidden")

    @hidden.setter
    def hidden(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hidden", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for role template object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Locked role template. Default `false` (bool)
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role template name (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="roleTemplateIds")
    def role_template_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Inherit role template IDs (list)
        """
        return pulumi.get(self, "role_template_ids")

    @role_template_ids.setter
    def role_template_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "role_template_ids", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]]]:
        """
        Role template policy rules (list)
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleTemplateRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("rancher2:index/roleTemplate:RoleTemplate")
class RoleTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrative: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 default_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateExternalRuleArgs', 'RoleTemplateExternalRuleArgsDict']]]]] = None,
                 hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateRuleArgs', 'RoleTemplateRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Role Template resource. This can be used to create Role Template for Rancher v2 and retrieve their information.

        `cluster` and `project` scopes are supported for role templates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 cluster Role Template
        foo = rancher2.RoleTemplate("foo",
            name="foo",
            context="cluster",
            default_role=True,
            description="Terraform role template acceptance test",
            rules=[{
                "api_groups": ["*"],
                "resources": ["secrets"],
                "verbs": ["create"],
            }])
        ```

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 project Role Template
        foo = rancher2.RoleTemplate("foo",
            name="foo",
            context="project",
            default_role=True,
            description="Terraform role template acceptance test",
            rules=[{
                "api_groups": ["*"],
                "resources": ["secrets"],
                "verbs": ["create"],
            }])
        ```

        ## Import

        Role Template can be imported using the Rancher Role Template ID

        ```sh
        $ pulumi import rancher2:index/roleTemplate:RoleTemplate foo &lt;role_template_id&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] administrative: Administrative role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for role template object (map)
        :param pulumi.Input[_builtins.str] context: Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        :param pulumi.Input[_builtins.bool] default_role: Default role template for new created cluster or project. Default `false` (bool)
        :param pulumi.Input[_builtins.str] description: Role template description (string)
        :param pulumi.Input[_builtins.bool] external: External role template. Default `false` (bool)
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateExternalRuleArgs', 'RoleTemplateExternalRuleArgsDict']]]] external_rules: External rules used for authorization. This field is required when `external=true` and no underlying ClusterRole exists. (list)
        :param pulumi.Input[_builtins.bool] hidden: Hidden role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for role template object (map)
        :param pulumi.Input[_builtins.bool] locked: Locked role template. Default `false` (bool)
        :param pulumi.Input[_builtins.str] name: Role template name (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_template_ids: Inherit role template IDs (list)
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateRuleArgs', 'RoleTemplateRuleArgsDict']]]] rules: Role template policy rules (list)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Role Template resource. This can be used to create Role Template for Rancher v2 and retrieve their information.

        `cluster` and `project` scopes are supported for role templates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 cluster Role Template
        foo = rancher2.RoleTemplate("foo",
            name="foo",
            context="cluster",
            default_role=True,
            description="Terraform role template acceptance test",
            rules=[{
                "api_groups": ["*"],
                "resources": ["secrets"],
                "verbs": ["create"],
            }])
        ```

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 project Role Template
        foo = rancher2.RoleTemplate("foo",
            name="foo",
            context="project",
            default_role=True,
            description="Terraform role template acceptance test",
            rules=[{
                "api_groups": ["*"],
                "resources": ["secrets"],
                "verbs": ["create"],
            }])
        ```

        ## Import

        Role Template can be imported using the Rancher Role Template ID

        ```sh
        $ pulumi import rancher2:index/roleTemplate:RoleTemplate foo &lt;role_template_id&gt;
        ```

        :param str resource_name: The name of the resource.
        :param RoleTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrative: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 default_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateExternalRuleArgs', 'RoleTemplateExternalRuleArgsDict']]]]] = None,
                 hidden: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateRuleArgs', 'RoleTemplateRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleTemplateArgs.__new__(RoleTemplateArgs)

            __props__.__dict__["administrative"] = administrative
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["context"] = context
            __props__.__dict__["default_role"] = default_role
            __props__.__dict__["description"] = description
            __props__.__dict__["external"] = external
            __props__.__dict__["external_rules"] = external_rules
            __props__.__dict__["hidden"] = hidden
            __props__.__dict__["labels"] = labels
            __props__.__dict__["locked"] = locked
            __props__.__dict__["name"] = name
            __props__.__dict__["role_template_ids"] = role_template_ids
            __props__.__dict__["rules"] = rules
            __props__.__dict__["builtin"] = None
        super(RoleTemplate, __self__).__init__(
            'rancher2:index/roleTemplate:RoleTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrative: Optional[pulumi.Input[_builtins.bool]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            builtin: Optional[pulumi.Input[_builtins.bool]] = None,
            context: Optional[pulumi.Input[_builtins.str]] = None,
            default_role: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            external: Optional[pulumi.Input[_builtins.bool]] = None,
            external_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateExternalRuleArgs', 'RoleTemplateExternalRuleArgsDict']]]]] = None,
            hidden: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            role_template_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateRuleArgs', 'RoleTemplateRuleArgsDict']]]]] = None) -> 'RoleTemplate':
        """
        Get an existing RoleTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] administrative: Administrative role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for role template object (map)
        :param pulumi.Input[_builtins.bool] builtin: (Computed) Builtin role template (string)
        :param pulumi.Input[_builtins.str] context: Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        :param pulumi.Input[_builtins.bool] default_role: Default role template for new created cluster or project. Default `false` (bool)
        :param pulumi.Input[_builtins.str] description: Role template description (string)
        :param pulumi.Input[_builtins.bool] external: External role template. Default `false` (bool)
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateExternalRuleArgs', 'RoleTemplateExternalRuleArgsDict']]]] external_rules: External rules used for authorization. This field is required when `external=true` and no underlying ClusterRole exists. (list)
        :param pulumi.Input[_builtins.bool] hidden: Hidden role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for role template object (map)
        :param pulumi.Input[_builtins.bool] locked: Locked role template. Default `false` (bool)
        :param pulumi.Input[_builtins.str] name: Role template name (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_template_ids: Inherit role template IDs (list)
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoleTemplateRuleArgs', 'RoleTemplateRuleArgsDict']]]] rules: Role template policy rules (list)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleTemplateState.__new__(_RoleTemplateState)

        __props__.__dict__["administrative"] = administrative
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["builtin"] = builtin
        __props__.__dict__["context"] = context
        __props__.__dict__["default_role"] = default_role
        __props__.__dict__["description"] = description
        __props__.__dict__["external"] = external
        __props__.__dict__["external_rules"] = external_rules
        __props__.__dict__["hidden"] = hidden
        __props__.__dict__["labels"] = labels
        __props__.__dict__["locked"] = locked
        __props__.__dict__["name"] = name
        __props__.__dict__["role_template_ids"] = role_template_ids
        __props__.__dict__["rules"] = rules
        return RoleTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def administrative(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Administrative role template. Default `false` (bool)
        """
        return pulumi.get(self, "administrative")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations for role template object (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def builtin(self) -> pulumi.Output[_builtins.bool]:
        """
        (Computed) Builtin role template (string)
        """
        return pulumi.get(self, "builtin")

    @_builtins.property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        """
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Default role template for new created cluster or project. Default `false` (bool)
        """
        return pulumi.get(self, "default_role")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Role template description (string)
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def external(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        External role template. Default `false` (bool)
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter(name="externalRules")
    def external_rules(self) -> pulumi.Output[Sequence['outputs.RoleTemplateExternalRule']]:
        """
        External rules used for authorization. This field is required when `external=true` and no underlying ClusterRole exists. (list)
        """
        return pulumi.get(self, "external_rules")

    @_builtins.property
    @pulumi.getter
    def hidden(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Hidden role template. Default `false` (bool)
        """
        return pulumi.get(self, "hidden")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels for role template object (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Locked role template. Default `false` (bool)
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Role template name (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="roleTemplateIds")
    def role_template_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Inherit role template IDs (list)
        """
        return pulumi.get(self, "role_template_ids")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.RoleTemplateRule']]:
        """
        Role template policy rules (list)
        """
        return pulumi.get(self, "rules")

