#  SPDX-License-Identifier: BSD-3-Clause
#  Copyright (C) 2017 Intel Corporation.
#  All rights reserved.

from spdk.rpc.helpers import deprecated_method


@deprecated_method
def spdk_kill_instance(client, sig_name):
    """Send a signal to the SPDK process.

    Args:
        sig_name: signal to send ("SIGINT", "SIGTERM", "SIGQUIT", "SIGHUP", or "SIGKILL")
    """
    params = {'sig_name': sig_name}
    return client.call('spdk_kill_instance', params)


@deprecated_method
def framework_monitor_context_switch(client, enabled=None):
    """Query or set state of context switch monitoring.

    Args:
        enabled: True to enable monitoring; False to disable monitoring; None to query (optional)

    Returns:
        Current context switch monitoring state (after applying enabled flag).
    """
    params = {}
    if enabled is not None:
        params['enabled'] = enabled
    return client.call('framework_monitor_context_switch', params)


@deprecated_method
def framework_get_reactors(client):
    """Query list of all reactors.

    Returns:
        List of all reactors.
    """
    return client.call('framework_get_reactors')


@deprecated_method
def framework_set_scheduler(client, name, period=None, load_limit=None, core_limit=None,
                            core_busy=None, mappings=None):
    """Select threads scheduler that will be activated and its period.

    Args:
        name: Name of a scheduler
        period: Scheduler period in microseconds
    Returns:
        True or False
    """
    params = {'name': name}
    if period is not None:
        params['period'] = period
    if load_limit is not None:
        params['load_limit'] = load_limit
    if core_limit is not None:
        params['core_limit'] = core_limit
    if core_busy is not None:
        params['core_busy'] = core_busy
    if mappings is not None:
        params['mappings'] = mappings
    return client.call('framework_set_scheduler', params)


@deprecated_method
def framework_get_scheduler(client):
    """Query currently set scheduler.

    Returns:
        Name, period (in microseconds) of currently set scheduler and name of currently set governor.
    """
    return client.call('framework_get_scheduler')


@deprecated_method
def framework_get_governor(client):
    """Query current governor data.

    Returns:
        Name of currently set governor, available frequencies and currently set frequency of the CPU cores.
    """
    return client.call('framework_get_governor')


@deprecated_method
def scheduler_set_options(client, scheduling_core=None, isolated_core_mask=None):
    params = {}
    if isolated_core_mask is not None:
        params['isolated_core_mask'] = isolated_core_mask
    if scheduling_core is not None:
        params['scheduling_core'] = scheduling_core
    return client.call('scheduler_set_options', params)


@deprecated_method
def thread_get_stats(client):
    """Query threads statistics.

    Returns:
        Current threads statistics.
    """
    return client.call('thread_get_stats')


@deprecated_method
def thread_set_cpumask(client, id, cpumask):
    """Set the cpumask of the thread whose ID matches to the specified value.

    Args:
        id: thread ID
        cpumask: cpumask for this thread

    Returns:
        True or False
    """
    params = {'id': id, 'cpumask': cpumask}
    return client.call('thread_set_cpumask', params)


@deprecated_method
def log_enable_timestamps(client, enabled):
    """Enable or disable timestamps.

    Args:
        value: on or off

    Returns:
        None
    """
    params = {'enabled': enabled}
    return client.call('log_enable_timestamps', params)


@deprecated_method
def thread_get_pollers(client):
    """Query current pollers.

    Returns:
        Current pollers.
    """
    return client.call('thread_get_pollers')


@deprecated_method
def thread_get_io_channels(client):
    """Query current IO channels.

    Returns:
        Current IO channels.
    """
    return client.call('thread_get_io_channels')
