# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawTemplatesClient, RawTemplatesClient
from .types.clone_template_response import CloneTemplateResponse
from .types.delete_template_response import DeleteTemplateResponse
from .types.generate_presigned_get_url_response import GeneratePresignedGetUrlResponse
from .types.generate_template_previews_request_format_opts import GenerateTemplatePreviewsRequestFormatOpts
from .types.generate_template_previews_request_type import GenerateTemplatePreviewsRequestType
from .types.generate_template_previews_response import GenerateTemplatePreviewsResponse
from .types.get_template_index_html_response import GetTemplateIndexHtmlResponse
from .types.initialize_template_creation_response import InitializeTemplateCreationResponse
from .types.save_created_template_request_preview_ids import SaveCreatedTemplateRequestPreviewIds
from .types.save_created_template_request_template_info import SaveCreatedTemplateRequestTemplateInfo
from .types.update_template_request_preview_ids import UpdateTemplateRequestPreviewIds
from .types.update_template_request_template_info import UpdateTemplateRequestTemplateInfo
from .types.update_template_response import UpdateTemplateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTemplatesClient
        """
        return self._raw_client

    def initialize_template_creation(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InitializeTemplateCreationResponse:
        """
        Initializes template creation by generating a unique ID and providing a presigned URL for template ZIP upload. Sets unfinished tag for tracking incomplete templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InitializeTemplateCreationResponse
            Default Response

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.initialize_template_creation()
        """
        _response = self._raw_client.initialize_template_creation(request_options=request_options)
        return _response.data

    def save_created_template(
        self,
        template_id: str,
        *,
        template_info: SaveCreatedTemplateRequestTemplateInfo,
        preview_ids: SaveCreatedTemplateRequestPreviewIds,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Finalizes template creation by saving template info to Strapi, copying preview files to permanent storage, and creating template index. Removes unfinished tag upon completion.

        Parameters
        ----------
        template_id : str

        template_info : SaveCreatedTemplateRequestTemplateInfo

        preview_ids : SaveCreatedTemplateRequestPreviewIds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from pogodoc import PogodocApi
        from pogodoc.templates import (
            SaveCreatedTemplateRequestPreviewIds,
            SaveCreatedTemplateRequestTemplateInfo,
        )

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.save_created_template(
            template_id="templateId",
            template_info=SaveCreatedTemplateRequestTemplateInfo(
                title="title",
                description="description",
                type="docx",
                sample_data={"key": "value"},
                categories=["invoice"],
            ),
            preview_ids=SaveCreatedTemplateRequestPreviewIds(
                png_job_id="pngJobId",
                pdf_job_id="pdfJobId",
            ),
        )
        """
        _response = self._raw_client.save_created_template(
            template_id, template_info=template_info, preview_ids=preview_ids, request_options=request_options
        )
        return _response.data

    def update_template(
        self,
        template_id: str,
        *,
        template_info: UpdateTemplateRequestTemplateInfo,
        preview_ids: UpdateTemplateRequestPreviewIds,
        content_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateTemplateResponse:
        """
        Updates template content, handles S3 storage cleanup for old content, updates template metadata in Strapi, and manages preview files. Removes unfinished tags after successful update.

        Parameters
        ----------
        template_id : str

        template_info : UpdateTemplateRequestTemplateInfo

        preview_ids : UpdateTemplateRequestPreviewIds

        content_id : str
            ID by which the new template content is saved

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateTemplateResponse
            Default Response

        Examples
        --------
        from pogodoc import PogodocApi
        from pogodoc.templates import (
            UpdateTemplateRequestPreviewIds,
            UpdateTemplateRequestTemplateInfo,
        )

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.update_template(
            template_id="templateId",
            template_info=UpdateTemplateRequestTemplateInfo(
                title="title",
                description="description",
                type="docx",
                sample_data={"key": "value"},
                categories=["invoice"],
            ),
            preview_ids=UpdateTemplateRequestPreviewIds(
                png_job_id="pngJobId",
                pdf_job_id="pdfJobId",
            ),
            content_id="contentId",
        )
        """
        _response = self._raw_client.update_template(
            template_id,
            template_info=template_info,
            preview_ids=preview_ids,
            content_id=content_id,
            request_options=request_options,
        )
        return _response.data

    def delete_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteTemplateResponse:
        """
        Deletes a template from Strapi and associated S3 storage. Removes all associated files and metadata.

        Parameters
        ----------
        template_id : str
            ID of the template to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTemplateResponse
            Default Response

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.delete_template(
            template_id="templateId",
        )
        """
        _response = self._raw_client.delete_template(template_id, request_options=request_options)
        return _response.data

    def extract_template_files(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Extracts contents from an uploaded template ZIP file and stores individual files in the appropriate S3 storage structure.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.extract_template_files(
            template_id="templateId",
        )
        """
        _response = self._raw_client.extract_template_files(template_id, request_options=request_options)
        return _response.data

    def generate_template_previews(
        self,
        template_id: str,
        *,
        type: GenerateTemplatePreviewsRequestType,
        data: typing.Dict[str, typing.Optional[typing.Any]],
        format_opts: typing.Optional[GenerateTemplatePreviewsRequestFormatOpts] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateTemplatePreviewsResponse:
        """
        Creates both PNG and PDF preview files for template visualization. Generates previews in parallel and returns URLs for both formats.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        type : GenerateTemplatePreviewsRequestType
            Type of template to be rendered

        data : typing.Dict[str, typing.Optional[typing.Any]]
            Sample data for the template

        format_opts : typing.Optional[GenerateTemplatePreviewsRequestFormatOpts]
            Format options for the rendered document

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateTemplatePreviewsResponse
            Default Response

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.generate_template_previews(
            template_id="templateId",
            type="docx",
            data={"key": "value"},
        )
        """
        _response = self._raw_client.generate_template_previews(
            template_id, type=type, data=data, format_opts=format_opts, request_options=request_options
        )
        return _response.data

    def generate_presigned_get_url(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GeneratePresignedGetUrlResponse:
        """
        Generates a presigned URL for template access. Used for downloading template files from S3 storage.

        Parameters
        ----------
        template_id : str
            ID of the template that is being downloaded

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneratePresignedGetUrlResponse
            Default Response

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.generate_presigned_get_url(
            template_id="templateId",
        )
        """
        _response = self._raw_client.generate_presigned_get_url(template_id, request_options=request_options)
        return _response.data

    def get_template_index_html(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTemplateIndexHtmlResponse:
        """
        Retrieves the template index.html file from S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTemplateIndexHtmlResponse
            Default Response

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.get_template_index_html(
            template_id="templateId",
        )
        """
        _response = self._raw_client.get_template_index_html(template_id, request_options=request_options)
        return _response.data

    def upload_template_index_html(
        self, template_id: str, *, index_html: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Uploads the template index.html file to S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        index_html : str
            New index.html file of the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.upload_template_index_html(
            template_id="templateId",
            index_html="indexHtml",
        )
        """
        _response = self._raw_client.upload_template_index_html(
            template_id, index_html=index_html, request_options=request_options
        )
        return _response.data

    def clone_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CloneTemplateResponse:
        """
        Creates a new template by duplicating an existing template's content and metadata. Includes copying preview files and template index.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CloneTemplateResponse
            Default Response

        Examples
        --------
        from pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.templates.clone_template(
            template_id="templateId",
        )
        """
        _response = self._raw_client.clone_template(template_id, request_options=request_options)
        return _response.data


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTemplatesClient
        """
        return self._raw_client

    async def initialize_template_creation(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InitializeTemplateCreationResponse:
        """
        Initializes template creation by generating a unique ID and providing a presigned URL for template ZIP upload. Sets unfinished tag for tracking incomplete templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InitializeTemplateCreationResponse
            Default Response

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.initialize_template_creation()


        asyncio.run(main())
        """
        _response = await self._raw_client.initialize_template_creation(request_options=request_options)
        return _response.data

    async def save_created_template(
        self,
        template_id: str,
        *,
        template_info: SaveCreatedTemplateRequestTemplateInfo,
        preview_ids: SaveCreatedTemplateRequestPreviewIds,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Finalizes template creation by saving template info to Strapi, copying preview files to permanent storage, and creating template index. Removes unfinished tag upon completion.

        Parameters
        ----------
        template_id : str

        template_info : SaveCreatedTemplateRequestTemplateInfo

        preview_ids : SaveCreatedTemplateRequestPreviewIds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi
        from pogodoc.templates import (
            SaveCreatedTemplateRequestPreviewIds,
            SaveCreatedTemplateRequestTemplateInfo,
        )

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.save_created_template(
                template_id="templateId",
                template_info=SaveCreatedTemplateRequestTemplateInfo(
                    title="title",
                    description="description",
                    type="docx",
                    sample_data={"key": "value"},
                    categories=["invoice"],
                ),
                preview_ids=SaveCreatedTemplateRequestPreviewIds(
                    png_job_id="pngJobId",
                    pdf_job_id="pdfJobId",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.save_created_template(
            template_id, template_info=template_info, preview_ids=preview_ids, request_options=request_options
        )
        return _response.data

    async def update_template(
        self,
        template_id: str,
        *,
        template_info: UpdateTemplateRequestTemplateInfo,
        preview_ids: UpdateTemplateRequestPreviewIds,
        content_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateTemplateResponse:
        """
        Updates template content, handles S3 storage cleanup for old content, updates template metadata in Strapi, and manages preview files. Removes unfinished tags after successful update.

        Parameters
        ----------
        template_id : str

        template_info : UpdateTemplateRequestTemplateInfo

        preview_ids : UpdateTemplateRequestPreviewIds

        content_id : str
            ID by which the new template content is saved

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateTemplateResponse
            Default Response

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi
        from pogodoc.templates import (
            UpdateTemplateRequestPreviewIds,
            UpdateTemplateRequestTemplateInfo,
        )

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.update_template(
                template_id="templateId",
                template_info=UpdateTemplateRequestTemplateInfo(
                    title="title",
                    description="description",
                    type="docx",
                    sample_data={"key": "value"},
                    categories=["invoice"],
                ),
                preview_ids=UpdateTemplateRequestPreviewIds(
                    png_job_id="pngJobId",
                    pdf_job_id="pdfJobId",
                ),
                content_id="contentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_template(
            template_id,
            template_info=template_info,
            preview_ids=preview_ids,
            content_id=content_id,
            request_options=request_options,
        )
        return _response.data

    async def delete_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteTemplateResponse:
        """
        Deletes a template from Strapi and associated S3 storage. Removes all associated files and metadata.

        Parameters
        ----------
        template_id : str
            ID of the template to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTemplateResponse
            Default Response

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.delete_template(
                template_id="templateId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_template(template_id, request_options=request_options)
        return _response.data

    async def extract_template_files(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Extracts contents from an uploaded template ZIP file and stores individual files in the appropriate S3 storage structure.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.extract_template_files(
                template_id="templateId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.extract_template_files(template_id, request_options=request_options)
        return _response.data

    async def generate_template_previews(
        self,
        template_id: str,
        *,
        type: GenerateTemplatePreviewsRequestType,
        data: typing.Dict[str, typing.Optional[typing.Any]],
        format_opts: typing.Optional[GenerateTemplatePreviewsRequestFormatOpts] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateTemplatePreviewsResponse:
        """
        Creates both PNG and PDF preview files for template visualization. Generates previews in parallel and returns URLs for both formats.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        type : GenerateTemplatePreviewsRequestType
            Type of template to be rendered

        data : typing.Dict[str, typing.Optional[typing.Any]]
            Sample data for the template

        format_opts : typing.Optional[GenerateTemplatePreviewsRequestFormatOpts]
            Format options for the rendered document

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateTemplatePreviewsResponse
            Default Response

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.generate_template_previews(
                template_id="templateId",
                type="docx",
                data={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.generate_template_previews(
            template_id, type=type, data=data, format_opts=format_opts, request_options=request_options
        )
        return _response.data

    async def generate_presigned_get_url(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GeneratePresignedGetUrlResponse:
        """
        Generates a presigned URL for template access. Used for downloading template files from S3 storage.

        Parameters
        ----------
        template_id : str
            ID of the template that is being downloaded

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneratePresignedGetUrlResponse
            Default Response

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.generate_presigned_get_url(
                template_id="templateId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.generate_presigned_get_url(template_id, request_options=request_options)
        return _response.data

    async def get_template_index_html(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTemplateIndexHtmlResponse:
        """
        Retrieves the template index.html file from S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTemplateIndexHtmlResponse
            Default Response

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.get_template_index_html(
                template_id="templateId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_template_index_html(template_id, request_options=request_options)
        return _response.data

    async def upload_template_index_html(
        self, template_id: str, *, index_html: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Uploads the template index.html file to S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        index_html : str
            New index.html file of the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.upload_template_index_html(
                template_id="templateId",
                index_html="indexHtml",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upload_template_index_html(
            template_id, index_html=index_html, request_options=request_options
        )
        return _response.data

    async def clone_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CloneTemplateResponse:
        """
        Creates a new template by duplicating an existing template's content and metadata. Includes copying preview files and template index.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CloneTemplateResponse
            Default Response

        Examples
        --------
        import asyncio

        from pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.clone_template(
                template_id="templateId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.clone_template(template_id, request_options=request_options)
        return _response.data
