# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from .types.clone_template_response import CloneTemplateResponse
from .types.delete_template_response import DeleteTemplateResponse
from .types.generate_presigned_get_url_response import GeneratePresignedGetUrlResponse
from .types.generate_template_previews_request_format_opts import GenerateTemplatePreviewsRequestFormatOpts
from .types.generate_template_previews_request_type import GenerateTemplatePreviewsRequestType
from .types.generate_template_previews_response import GenerateTemplatePreviewsResponse
from .types.get_template_index_html_response import GetTemplateIndexHtmlResponse
from .types.initialize_template_creation_response import InitializeTemplateCreationResponse
from .types.save_created_template_request_preview_ids import SaveCreatedTemplateRequestPreviewIds
from .types.save_created_template_request_template_info import SaveCreatedTemplateRequestTemplateInfo
from .types.update_template_request_preview_ids import UpdateTemplateRequestPreviewIds
from .types.update_template_request_template_info import UpdateTemplateRequestTemplateInfo
from .types.update_template_response import UpdateTemplateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def initialize_template_creation(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InitializeTemplateCreationResponse]:
        """
        Initializes template creation by generating a unique ID and providing a presigned URL for template ZIP upload. Sets unfinished tag for tracking incomplete templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InitializeTemplateCreationResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "templates/init",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InitializeTemplateCreationResponse,
                    parse_obj_as(
                        type_=InitializeTemplateCreationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def save_created_template(
        self,
        template_id: str,
        *,
        template_info: SaveCreatedTemplateRequestTemplateInfo,
        preview_ids: SaveCreatedTemplateRequestPreviewIds,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Finalizes template creation by saving template info to Strapi, copying preview files to permanent storage, and creating template index. Removes unfinished tag upon completion.

        Parameters
        ----------
        template_id : str

        template_info : SaveCreatedTemplateRequestTemplateInfo

        preview_ids : SaveCreatedTemplateRequestPreviewIds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}",
            method="POST",
            json={
                "templateInfo": convert_and_respect_annotation_metadata(
                    object_=template_info, annotation=SaveCreatedTemplateRequestTemplateInfo, direction="write"
                ),
                "previewIds": convert_and_respect_annotation_metadata(
                    object_=preview_ids, annotation=SaveCreatedTemplateRequestPreviewIds, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_template(
        self,
        template_id: str,
        *,
        template_info: UpdateTemplateRequestTemplateInfo,
        preview_ids: UpdateTemplateRequestPreviewIds,
        content_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateTemplateResponse]:
        """
        Updates template content, handles S3 storage cleanup for old content, updates template metadata in Strapi, and manages preview files. Removes unfinished tags after successful update.

        Parameters
        ----------
        template_id : str

        template_info : UpdateTemplateRequestTemplateInfo

        preview_ids : UpdateTemplateRequestPreviewIds

        content_id : str
            ID by which the new template content is saved

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateTemplateResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}",
            method="PUT",
            json={
                "templateInfo": convert_and_respect_annotation_metadata(
                    object_=template_info, annotation=UpdateTemplateRequestTemplateInfo, direction="write"
                ),
                "previewIds": convert_and_respect_annotation_metadata(
                    object_=preview_ids, annotation=UpdateTemplateRequestPreviewIds, direction="write"
                ),
                "contentId": content_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateTemplateResponse,
                    parse_obj_as(
                        type_=UpdateTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeleteTemplateResponse]:
        """
        Deletes a template from Strapi and associated S3 storage. Removes all associated files and metadata.

        Parameters
        ----------
        template_id : str
            ID of the template to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeleteTemplateResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteTemplateResponse,
                    parse_obj_as(
                        type_=DeleteTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def extract_template_files(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Extracts contents from an uploaded template ZIP file and stores individual files in the appropriate S3 storage structure.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/unzip",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def generate_template_previews(
        self,
        template_id: str,
        *,
        type: GenerateTemplatePreviewsRequestType,
        data: typing.Dict[str, typing.Optional[typing.Any]],
        format_opts: typing.Optional[GenerateTemplatePreviewsRequestFormatOpts] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GenerateTemplatePreviewsResponse]:
        """
        Creates both PNG and PDF preview files for template visualization. Generates previews in parallel and returns URLs for both formats.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        type : GenerateTemplatePreviewsRequestType
            Type of template to be rendered

        data : typing.Dict[str, typing.Optional[typing.Any]]
            Sample data for the template

        format_opts : typing.Optional[GenerateTemplatePreviewsRequestFormatOpts]
            Format options for the rendered document

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GenerateTemplatePreviewsResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/render-previews",
            method="POST",
            json={
                "type": type,
                "data": data,
                "formatOpts": convert_and_respect_annotation_metadata(
                    object_=format_opts, annotation=GenerateTemplatePreviewsRequestFormatOpts, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GenerateTemplatePreviewsResponse,
                    parse_obj_as(
                        type_=GenerateTemplatePreviewsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def generate_presigned_get_url(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GeneratePresignedGetUrlResponse]:
        """
        Generates a presigned URL for template access. Used for downloading template files from S3 storage.

        Parameters
        ----------
        template_id : str
            ID of the template that is being downloaded

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GeneratePresignedGetUrlResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/presigned-url",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GeneratePresignedGetUrlResponse,
                    parse_obj_as(
                        type_=GeneratePresignedGetUrlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_template_index_html(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetTemplateIndexHtmlResponse]:
        """
        Retrieves the template index.html file from S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTemplateIndexHtmlResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/index-html",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTemplateIndexHtmlResponse,
                    parse_obj_as(
                        type_=GetTemplateIndexHtmlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upload_template_index_html(
        self, template_id: str, *, index_html: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Uploads the template index.html file to S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        index_html : str
            New index.html file of the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/index-html",
            method="POST",
            json={
                "indexHtml": index_html,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def clone_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CloneTemplateResponse]:
        """
        Creates a new template by duplicating an existing template's content and metadata. Includes copying preview files and template index.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CloneTemplateResponse]
            Default Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/clone",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CloneTemplateResponse,
                    parse_obj_as(
                        type_=CloneTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def initialize_template_creation(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InitializeTemplateCreationResponse]:
        """
        Initializes template creation by generating a unique ID and providing a presigned URL for template ZIP upload. Sets unfinished tag for tracking incomplete templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InitializeTemplateCreationResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "templates/init",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InitializeTemplateCreationResponse,
                    parse_obj_as(
                        type_=InitializeTemplateCreationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def save_created_template(
        self,
        template_id: str,
        *,
        template_info: SaveCreatedTemplateRequestTemplateInfo,
        preview_ids: SaveCreatedTemplateRequestPreviewIds,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Finalizes template creation by saving template info to Strapi, copying preview files to permanent storage, and creating template index. Removes unfinished tag upon completion.

        Parameters
        ----------
        template_id : str

        template_info : SaveCreatedTemplateRequestTemplateInfo

        preview_ids : SaveCreatedTemplateRequestPreviewIds

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}",
            method="POST",
            json={
                "templateInfo": convert_and_respect_annotation_metadata(
                    object_=template_info, annotation=SaveCreatedTemplateRequestTemplateInfo, direction="write"
                ),
                "previewIds": convert_and_respect_annotation_metadata(
                    object_=preview_ids, annotation=SaveCreatedTemplateRequestPreviewIds, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_template(
        self,
        template_id: str,
        *,
        template_info: UpdateTemplateRequestTemplateInfo,
        preview_ids: UpdateTemplateRequestPreviewIds,
        content_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateTemplateResponse]:
        """
        Updates template content, handles S3 storage cleanup for old content, updates template metadata in Strapi, and manages preview files. Removes unfinished tags after successful update.

        Parameters
        ----------
        template_id : str

        template_info : UpdateTemplateRequestTemplateInfo

        preview_ids : UpdateTemplateRequestPreviewIds

        content_id : str
            ID by which the new template content is saved

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateTemplateResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}",
            method="PUT",
            json={
                "templateInfo": convert_and_respect_annotation_metadata(
                    object_=template_info, annotation=UpdateTemplateRequestTemplateInfo, direction="write"
                ),
                "previewIds": convert_and_respect_annotation_metadata(
                    object_=preview_ids, annotation=UpdateTemplateRequestPreviewIds, direction="write"
                ),
                "contentId": content_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateTemplateResponse,
                    parse_obj_as(
                        type_=UpdateTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeleteTemplateResponse]:
        """
        Deletes a template from Strapi and associated S3 storage. Removes all associated files and metadata.

        Parameters
        ----------
        template_id : str
            ID of the template to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeleteTemplateResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteTemplateResponse,
                    parse_obj_as(
                        type_=DeleteTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def extract_template_files(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Extracts contents from an uploaded template ZIP file and stores individual files in the appropriate S3 storage structure.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/unzip",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def generate_template_previews(
        self,
        template_id: str,
        *,
        type: GenerateTemplatePreviewsRequestType,
        data: typing.Dict[str, typing.Optional[typing.Any]],
        format_opts: typing.Optional[GenerateTemplatePreviewsRequestFormatOpts] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GenerateTemplatePreviewsResponse]:
        """
        Creates both PNG and PDF preview files for template visualization. Generates previews in parallel and returns URLs for both formats.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        type : GenerateTemplatePreviewsRequestType
            Type of template to be rendered

        data : typing.Dict[str, typing.Optional[typing.Any]]
            Sample data for the template

        format_opts : typing.Optional[GenerateTemplatePreviewsRequestFormatOpts]
            Format options for the rendered document

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GenerateTemplatePreviewsResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/render-previews",
            method="POST",
            json={
                "type": type,
                "data": data,
                "formatOpts": convert_and_respect_annotation_metadata(
                    object_=format_opts, annotation=GenerateTemplatePreviewsRequestFormatOpts, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GenerateTemplatePreviewsResponse,
                    parse_obj_as(
                        type_=GenerateTemplatePreviewsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def generate_presigned_get_url(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GeneratePresignedGetUrlResponse]:
        """
        Generates a presigned URL for template access. Used for downloading template files from S3 storage.

        Parameters
        ----------
        template_id : str
            ID of the template that is being downloaded

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GeneratePresignedGetUrlResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/presigned-url",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GeneratePresignedGetUrlResponse,
                    parse_obj_as(
                        type_=GeneratePresignedGetUrlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_template_index_html(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetTemplateIndexHtmlResponse]:
        """
        Retrieves the template index.html file from S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTemplateIndexHtmlResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/index-html",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTemplateIndexHtmlResponse,
                    parse_obj_as(
                        type_=GetTemplateIndexHtmlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upload_template_index_html(
        self, template_id: str, *, index_html: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Uploads the template index.html file to S3 storage. Used for rendering the template in the browser.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        index_html : str
            New index.html file of the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/index-html",
            method="POST",
            json={
                "indexHtml": index_html,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def clone_template(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CloneTemplateResponse]:
        """
        Creates a new template by duplicating an existing template's content and metadata. Includes copying preview files and template index.

        Parameters
        ----------
        template_id : str
            ID of the template to be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CloneTemplateResponse]
            Default Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"templates/{jsonable_encoder(template_id)}/clone",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CloneTemplateResponse,
                    parse_obj_as(
                        type_=CloneTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
