# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AuthConfigOpenLdapArgs', 'AuthConfigOpenLdap']

@pulumi.input_type
class AuthConfigOpenLdapArgs:
    def __init__(__self__, *,
                 servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 service_account_distinguished_name: pulumi.Input[_builtins.str],
                 service_account_password: pulumi.Input[_builtins.str],
                 test_password: pulumi.Input[_builtins.str],
                 test_username: pulumi.Input[_builtins.str],
                 user_search_base: pulumi.Input[_builtins.str],
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_dn_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_user_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_base: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 nested_group_membership_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 start_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_disabled_bit_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 user_enabled_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_login_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_member_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_filter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthConfigOpenLdap resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] servers: OpenLdap servers list (list)
        :param pulumi.Input[_builtins.str] service_account_distinguished_name: Service account DN for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] service_account_password: Service account password for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_password: Password for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_username: Username for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.str] user_search_base: User search base DN (string)
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `openldap_user://<DN>`  `openldap_group://<DN>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] certificate: Base64 encoded CA certificate for TLS if self-signed. Use filebase64(<FILE>) for encoding file (string)
        :param pulumi.Input[_builtins.int] connection_timeout: OpenLdap connection timeout. Default `5000` (int)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] group_dn_attribute: Group DN attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_member_mapping_attribute: Group member mapping attribute. Default `member` (string)
        :param pulumi.Input[_builtins.str] group_member_user_attribute: Group member user attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_name_attribute: Group name attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_object_class: Group object class. Default `groupOfNames` (string)
        :param pulumi.Input[_builtins.str] group_search_attribute: Group search attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_search_base: Group search base (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.bool] nested_group_membership_enabled: Nested group membership enable. Default `false` (bool)
        :param pulumi.Input[_builtins.int] port: OpenLdap port. Default `389` (int)
        :param pulumi.Input[_builtins.bool] tls: Enable TLS connection (bool)
        :param pulumi.Input[_builtins.int] user_disabled_bit_mask: User disabled bit mask (int)
        :param pulumi.Input[_builtins.str] user_enabled_attribute: User enable attribute (string)
        :param pulumi.Input[_builtins.str] user_login_attribute: User login attribute. Default `uid` (string)
        :param pulumi.Input[_builtins.str] user_member_attribute: User member attribute. Default `memberOf` (string)
        :param pulumi.Input[_builtins.str] user_name_attribute: User name attribute. Default `givenName` (string)
        :param pulumi.Input[_builtins.str] user_object_class: User object class. Default `inetorgperson` (string)
        :param pulumi.Input[_builtins.str] user_search_attribute: User search attribute. Default `uid|sn|givenName` (string)
        """
        pulumi.set(__self__, "servers", servers)
        pulumi.set(__self__, "service_account_distinguished_name", service_account_distinguished_name)
        pulumi.set(__self__, "service_account_password", service_account_password)
        pulumi.set(__self__, "test_password", test_password)
        pulumi.set(__self__, "test_username", test_username)
        pulumi.set(__self__, "user_search_base", user_search_base)
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if allowed_principal_ids is not None:
            pulumi.set(__self__, "allowed_principal_ids", allowed_principal_ids)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group_dn_attribute is not None:
            pulumi.set(__self__, "group_dn_attribute", group_dn_attribute)
        if group_member_mapping_attribute is not None:
            pulumi.set(__self__, "group_member_mapping_attribute", group_member_mapping_attribute)
        if group_member_user_attribute is not None:
            pulumi.set(__self__, "group_member_user_attribute", group_member_user_attribute)
        if group_name_attribute is not None:
            pulumi.set(__self__, "group_name_attribute", group_name_attribute)
        if group_object_class is not None:
            pulumi.set(__self__, "group_object_class", group_object_class)
        if group_search_attribute is not None:
            pulumi.set(__self__, "group_search_attribute", group_search_attribute)
        if group_search_base is not None:
            pulumi.set(__self__, "group_search_base", group_search_base)
        if group_search_filter is not None:
            pulumi.set(__self__, "group_search_filter", group_search_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if nested_group_membership_enabled is not None:
            pulumi.set(__self__, "nested_group_membership_enabled", nested_group_membership_enabled)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if user_disabled_bit_mask is not None:
            pulumi.set(__self__, "user_disabled_bit_mask", user_disabled_bit_mask)
        if user_enabled_attribute is not None:
            pulumi.set(__self__, "user_enabled_attribute", user_enabled_attribute)
        if user_login_attribute is not None:
            pulumi.set(__self__, "user_login_attribute", user_login_attribute)
        if user_member_attribute is not None:
            pulumi.set(__self__, "user_member_attribute", user_member_attribute)
        if user_name_attribute is not None:
            pulumi.set(__self__, "user_name_attribute", user_name_attribute)
        if user_object_class is not None:
            pulumi.set(__self__, "user_object_class", user_object_class)
        if user_search_attribute is not None:
            pulumi.set(__self__, "user_search_attribute", user_search_attribute)
        if user_search_filter is not None:
            pulumi.set(__self__, "user_search_filter", user_search_filter)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        OpenLdap servers list (list)
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountDistinguishedName")
    def service_account_distinguished_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service account DN for access OpenLdap service (string)
        """
        return pulumi.get(self, "service_account_distinguished_name")

    @service_account_distinguished_name.setter
    def service_account_distinguished_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_distinguished_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountPassword")
    def service_account_password(self) -> pulumi.Input[_builtins.str]:
        """
        Service account password for access OpenLdap service (string)
        """
        return pulumi.get(self, "service_account_password")

    @service_account_password.setter
    def service_account_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_password", value)

    @_builtins.property
    @pulumi.getter(name="testPassword")
    def test_password(self) -> pulumi.Input[_builtins.str]:
        """
        Password for test access to OpenLdap service (string)
        """
        return pulumi.get(self, "test_password")

    @test_password.setter
    def test_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "test_password", value)

    @_builtins.property
    @pulumi.getter(name="testUsername")
    def test_username(self) -> pulumi.Input[_builtins.str]:
        """
        Username for test access to OpenLdap service (string)
        """
        return pulumi.get(self, "test_username")

    @test_username.setter
    def test_username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "test_username", value)

    @_builtins.property
    @pulumi.getter(name="userSearchBase")
    def user_search_base(self) -> pulumi.Input[_builtins.str]:
        """
        User search base DN (string)
        """
        return pulumi.get(self, "user_search_base")

    @user_search_base.setter
    def user_search_base(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_search_base", value)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrincipalIds")
    def allowed_principal_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `openldap_user://<DN>`  `openldap_group://<DN>` (list)
        """
        return pulumi.get(self, "allowed_principal_ids")

    @allowed_principal_ids.setter
    def allowed_principal_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_principal_ids", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 encoded CA certificate for TLS if self-signed. Use filebase64(<FILE>) for encoding file (string)
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        OpenLdap connection timeout. Default `5000` (int)
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable auth config provider. Default `true` (bool)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="groupDnAttribute")
    def group_dn_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group DN attribute. Default `entryDN` (string)
        """
        return pulumi.get(self, "group_dn_attribute")

    @group_dn_attribute.setter
    def group_dn_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_dn_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupMemberMappingAttribute")
    def group_member_mapping_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group member mapping attribute. Default `member` (string)
        """
        return pulumi.get(self, "group_member_mapping_attribute")

    @group_member_mapping_attribute.setter
    def group_member_mapping_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_member_mapping_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupMemberUserAttribute")
    def group_member_user_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group member user attribute. Default `entryDN` (string)
        """
        return pulumi.get(self, "group_member_user_attribute")

    @group_member_user_attribute.setter
    def group_member_user_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_member_user_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupNameAttribute")
    def group_name_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group name attribute. Default `cn` (string)
        """
        return pulumi.get(self, "group_name_attribute")

    @group_name_attribute.setter
    def group_name_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupObjectClass")
    def group_object_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group object class. Default `groupOfNames` (string)
        """
        return pulumi.get(self, "group_object_class")

    @group_object_class.setter
    def group_object_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_object_class", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchAttribute")
    def group_search_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group search attribute. Default `cn` (string)
        """
        return pulumi.get(self, "group_search_attribute")

    @group_search_attribute.setter
    def group_search_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchBase")
    def group_search_base(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group search base (string)
        """
        return pulumi.get(self, "group_search_base")

    @group_search_base.setter
    def group_search_base(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_base", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchFilter")
    def group_search_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "group_search_filter")

    @group_search_filter.setter
    def group_search_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="nestedGroupMembershipEnabled")
    def nested_group_membership_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Nested group membership enable. Default `false` (bool)
        """
        return pulumi.get(self, "nested_group_membership_enabled")

    @nested_group_membership_enabled.setter
    def nested_group_membership_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "nested_group_membership_enabled", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        OpenLdap port. Default `389` (int)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "start_tls")

    @start_tls.setter
    def start_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_tls", value)

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable TLS connection (bool)
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls", value)

    @_builtins.property
    @pulumi.getter(name="userDisabledBitMask")
    def user_disabled_bit_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User disabled bit mask (int)
        """
        return pulumi.get(self, "user_disabled_bit_mask")

    @user_disabled_bit_mask.setter
    def user_disabled_bit_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_disabled_bit_mask", value)

    @_builtins.property
    @pulumi.getter(name="userEnabledAttribute")
    def user_enabled_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User enable attribute (string)
        """
        return pulumi.get(self, "user_enabled_attribute")

    @user_enabled_attribute.setter
    def user_enabled_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_enabled_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userLoginAttribute")
    def user_login_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User login attribute. Default `uid` (string)
        """
        return pulumi.get(self, "user_login_attribute")

    @user_login_attribute.setter
    def user_login_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_login_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userMemberAttribute")
    def user_member_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User member attribute. Default `memberOf` (string)
        """
        return pulumi.get(self, "user_member_attribute")

    @user_member_attribute.setter
    def user_member_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_member_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userNameAttribute")
    def user_name_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name attribute. Default `givenName` (string)
        """
        return pulumi.get(self, "user_name_attribute")

    @user_name_attribute.setter
    def user_name_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userObjectClass")
    def user_object_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User object class. Default `inetorgperson` (string)
        """
        return pulumi.get(self, "user_object_class")

    @user_object_class.setter
    def user_object_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_object_class", value)

    @_builtins.property
    @pulumi.getter(name="userSearchAttribute")
    def user_search_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User search attribute. Default `uid|sn|givenName` (string)
        """
        return pulumi.get(self, "user_search_attribute")

    @user_search_attribute.setter
    def user_search_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_search_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userSearchFilter")
    def user_search_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_search_filter")

    @user_search_filter.setter
    def user_search_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_search_filter", value)


@pulumi.input_type
class _AuthConfigOpenLdapState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_dn_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_user_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_base: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nested_group_membership_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 start_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 test_password: Optional[pulumi.Input[_builtins.str]] = None,
                 test_username: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_disabled_bit_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 user_enabled_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_login_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_member_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_base: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_filter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthConfigOpenLdap resources.
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `openldap_user://<DN>`  `openldap_group://<DN>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] certificate: Base64 encoded CA certificate for TLS if self-signed. Use filebase64(<FILE>) for encoding file (string)
        :param pulumi.Input[_builtins.int] connection_timeout: OpenLdap connection timeout. Default `5000` (int)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] group_dn_attribute: Group DN attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_member_mapping_attribute: Group member mapping attribute. Default `member` (string)
        :param pulumi.Input[_builtins.str] group_member_user_attribute: Group member user attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_name_attribute: Group name attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_object_class: Group object class. Default `groupOfNames` (string)
        :param pulumi.Input[_builtins.str] group_search_attribute: Group search attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_search_base: Group search base (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: (Computed) The name of the resource (string)
        :param pulumi.Input[_builtins.bool] nested_group_membership_enabled: Nested group membership enable. Default `false` (bool)
        :param pulumi.Input[_builtins.int] port: OpenLdap port. Default `389` (int)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] servers: OpenLdap servers list (list)
        :param pulumi.Input[_builtins.str] service_account_distinguished_name: Service account DN for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] service_account_password: Service account password for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_password: Password for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_username: Username for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.bool] tls: Enable TLS connection (bool)
        :param pulumi.Input[_builtins.str] type: (Computed) The type of the resource (string)
        :param pulumi.Input[_builtins.int] user_disabled_bit_mask: User disabled bit mask (int)
        :param pulumi.Input[_builtins.str] user_enabled_attribute: User enable attribute (string)
        :param pulumi.Input[_builtins.str] user_login_attribute: User login attribute. Default `uid` (string)
        :param pulumi.Input[_builtins.str] user_member_attribute: User member attribute. Default `memberOf` (string)
        :param pulumi.Input[_builtins.str] user_name_attribute: User name attribute. Default `givenName` (string)
        :param pulumi.Input[_builtins.str] user_object_class: User object class. Default `inetorgperson` (string)
        :param pulumi.Input[_builtins.str] user_search_attribute: User search attribute. Default `uid|sn|givenName` (string)
        :param pulumi.Input[_builtins.str] user_search_base: User search base DN (string)
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if allowed_principal_ids is not None:
            pulumi.set(__self__, "allowed_principal_ids", allowed_principal_ids)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group_dn_attribute is not None:
            pulumi.set(__self__, "group_dn_attribute", group_dn_attribute)
        if group_member_mapping_attribute is not None:
            pulumi.set(__self__, "group_member_mapping_attribute", group_member_mapping_attribute)
        if group_member_user_attribute is not None:
            pulumi.set(__self__, "group_member_user_attribute", group_member_user_attribute)
        if group_name_attribute is not None:
            pulumi.set(__self__, "group_name_attribute", group_name_attribute)
        if group_object_class is not None:
            pulumi.set(__self__, "group_object_class", group_object_class)
        if group_search_attribute is not None:
            pulumi.set(__self__, "group_search_attribute", group_search_attribute)
        if group_search_base is not None:
            pulumi.set(__self__, "group_search_base", group_search_base)
        if group_search_filter is not None:
            pulumi.set(__self__, "group_search_filter", group_search_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nested_group_membership_enabled is not None:
            pulumi.set(__self__, "nested_group_membership_enabled", nested_group_membership_enabled)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if service_account_distinguished_name is not None:
            pulumi.set(__self__, "service_account_distinguished_name", service_account_distinguished_name)
        if service_account_password is not None:
            pulumi.set(__self__, "service_account_password", service_account_password)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)
        if test_password is not None:
            pulumi.set(__self__, "test_password", test_password)
        if test_username is not None:
            pulumi.set(__self__, "test_username", test_username)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_disabled_bit_mask is not None:
            pulumi.set(__self__, "user_disabled_bit_mask", user_disabled_bit_mask)
        if user_enabled_attribute is not None:
            pulumi.set(__self__, "user_enabled_attribute", user_enabled_attribute)
        if user_login_attribute is not None:
            pulumi.set(__self__, "user_login_attribute", user_login_attribute)
        if user_member_attribute is not None:
            pulumi.set(__self__, "user_member_attribute", user_member_attribute)
        if user_name_attribute is not None:
            pulumi.set(__self__, "user_name_attribute", user_name_attribute)
        if user_object_class is not None:
            pulumi.set(__self__, "user_object_class", user_object_class)
        if user_search_attribute is not None:
            pulumi.set(__self__, "user_search_attribute", user_search_attribute)
        if user_search_base is not None:
            pulumi.set(__self__, "user_search_base", user_search_base)
        if user_search_filter is not None:
            pulumi.set(__self__, "user_search_filter", user_search_filter)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrincipalIds")
    def allowed_principal_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `openldap_user://<DN>`  `openldap_group://<DN>` (list)
        """
        return pulumi.get(self, "allowed_principal_ids")

    @allowed_principal_ids.setter
    def allowed_principal_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_principal_ids", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 encoded CA certificate for TLS if self-signed. Use filebase64(<FILE>) for encoding file (string)
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        OpenLdap connection timeout. Default `5000` (int)
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable auth config provider. Default `true` (bool)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="groupDnAttribute")
    def group_dn_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group DN attribute. Default `entryDN` (string)
        """
        return pulumi.get(self, "group_dn_attribute")

    @group_dn_attribute.setter
    def group_dn_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_dn_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupMemberMappingAttribute")
    def group_member_mapping_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group member mapping attribute. Default `member` (string)
        """
        return pulumi.get(self, "group_member_mapping_attribute")

    @group_member_mapping_attribute.setter
    def group_member_mapping_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_member_mapping_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupMemberUserAttribute")
    def group_member_user_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group member user attribute. Default `entryDN` (string)
        """
        return pulumi.get(self, "group_member_user_attribute")

    @group_member_user_attribute.setter
    def group_member_user_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_member_user_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupNameAttribute")
    def group_name_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group name attribute. Default `cn` (string)
        """
        return pulumi.get(self, "group_name_attribute")

    @group_name_attribute.setter
    def group_name_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupObjectClass")
    def group_object_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group object class. Default `groupOfNames` (string)
        """
        return pulumi.get(self, "group_object_class")

    @group_object_class.setter
    def group_object_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_object_class", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchAttribute")
    def group_search_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group search attribute. Default `cn` (string)
        """
        return pulumi.get(self, "group_search_attribute")

    @group_search_attribute.setter
    def group_search_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchBase")
    def group_search_base(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group search base (string)
        """
        return pulumi.get(self, "group_search_base")

    @group_search_base.setter
    def group_search_base(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_base", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchFilter")
    def group_search_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "group_search_filter")

    @group_search_filter.setter
    def group_search_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The name of the resource (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nestedGroupMembershipEnabled")
    def nested_group_membership_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Nested group membership enable. Default `false` (bool)
        """
        return pulumi.get(self, "nested_group_membership_enabled")

    @nested_group_membership_enabled.setter
    def nested_group_membership_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "nested_group_membership_enabled", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        OpenLdap port. Default `389` (int)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        OpenLdap servers list (list)
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountDistinguishedName")
    def service_account_distinguished_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account DN for access OpenLdap service (string)
        """
        return pulumi.get(self, "service_account_distinguished_name")

    @service_account_distinguished_name.setter
    def service_account_distinguished_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_distinguished_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountPassword")
    def service_account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account password for access OpenLdap service (string)
        """
        return pulumi.get(self, "service_account_password")

    @service_account_password.setter
    def service_account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_password", value)

    @_builtins.property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "start_tls")

    @start_tls.setter
    def start_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_tls", value)

    @_builtins.property
    @pulumi.getter(name="testPassword")
    def test_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for test access to OpenLdap service (string)
        """
        return pulumi.get(self, "test_password")

    @test_password.setter
    def test_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "test_password", value)

    @_builtins.property
    @pulumi.getter(name="testUsername")
    def test_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for test access to OpenLdap service (string)
        """
        return pulumi.get(self, "test_username")

    @test_username.setter
    def test_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "test_username", value)

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable TLS connection (bool)
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The type of the resource (string)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userDisabledBitMask")
    def user_disabled_bit_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User disabled bit mask (int)
        """
        return pulumi.get(self, "user_disabled_bit_mask")

    @user_disabled_bit_mask.setter
    def user_disabled_bit_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_disabled_bit_mask", value)

    @_builtins.property
    @pulumi.getter(name="userEnabledAttribute")
    def user_enabled_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User enable attribute (string)
        """
        return pulumi.get(self, "user_enabled_attribute")

    @user_enabled_attribute.setter
    def user_enabled_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_enabled_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userLoginAttribute")
    def user_login_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User login attribute. Default `uid` (string)
        """
        return pulumi.get(self, "user_login_attribute")

    @user_login_attribute.setter
    def user_login_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_login_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userMemberAttribute")
    def user_member_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User member attribute. Default `memberOf` (string)
        """
        return pulumi.get(self, "user_member_attribute")

    @user_member_attribute.setter
    def user_member_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_member_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userNameAttribute")
    def user_name_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name attribute. Default `givenName` (string)
        """
        return pulumi.get(self, "user_name_attribute")

    @user_name_attribute.setter
    def user_name_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userObjectClass")
    def user_object_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User object class. Default `inetorgperson` (string)
        """
        return pulumi.get(self, "user_object_class")

    @user_object_class.setter
    def user_object_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_object_class", value)

    @_builtins.property
    @pulumi.getter(name="userSearchAttribute")
    def user_search_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User search attribute. Default `uid|sn|givenName` (string)
        """
        return pulumi.get(self, "user_search_attribute")

    @user_search_attribute.setter
    def user_search_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_search_attribute", value)

    @_builtins.property
    @pulumi.getter(name="userSearchBase")
    def user_search_base(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User search base DN (string)
        """
        return pulumi.get(self, "user_search_base")

    @user_search_base.setter
    def user_search_base(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_search_base", value)

    @_builtins.property
    @pulumi.getter(name="userSearchFilter")
    def user_search_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_search_filter")

    @user_search_filter.setter
    def user_search_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_search_filter", value)


@pulumi.type_token("rancher2:index/authConfigOpenLdap:AuthConfigOpenLdap")
class AuthConfigOpenLdap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_dn_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_user_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_base: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 nested_group_membership_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 start_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 test_password: Optional[pulumi.Input[_builtins.str]] = None,
                 test_username: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_disabled_bit_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 user_enabled_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_login_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_member_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_base: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Auth Config OpenLdap resource. This can be used to configure and enable Auth Config OpenLdap for Rancher v2 RKE clusters and retrieve their information.

        In addition to the built-in local auth, only one external auth config provider can be enabled at a time.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `openldap_user://<DN>`  `openldap_group://<DN>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] certificate: Base64 encoded CA certificate for TLS if self-signed. Use filebase64(<FILE>) for encoding file (string)
        :param pulumi.Input[_builtins.int] connection_timeout: OpenLdap connection timeout. Default `5000` (int)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] group_dn_attribute: Group DN attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_member_mapping_attribute: Group member mapping attribute. Default `member` (string)
        :param pulumi.Input[_builtins.str] group_member_user_attribute: Group member user attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_name_attribute: Group name attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_object_class: Group object class. Default `groupOfNames` (string)
        :param pulumi.Input[_builtins.str] group_search_attribute: Group search attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_search_base: Group search base (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.bool] nested_group_membership_enabled: Nested group membership enable. Default `false` (bool)
        :param pulumi.Input[_builtins.int] port: OpenLdap port. Default `389` (int)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] servers: OpenLdap servers list (list)
        :param pulumi.Input[_builtins.str] service_account_distinguished_name: Service account DN for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] service_account_password: Service account password for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_password: Password for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_username: Username for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.bool] tls: Enable TLS connection (bool)
        :param pulumi.Input[_builtins.int] user_disabled_bit_mask: User disabled bit mask (int)
        :param pulumi.Input[_builtins.str] user_enabled_attribute: User enable attribute (string)
        :param pulumi.Input[_builtins.str] user_login_attribute: User login attribute. Default `uid` (string)
        :param pulumi.Input[_builtins.str] user_member_attribute: User member attribute. Default `memberOf` (string)
        :param pulumi.Input[_builtins.str] user_name_attribute: User name attribute. Default `givenName` (string)
        :param pulumi.Input[_builtins.str] user_object_class: User object class. Default `inetorgperson` (string)
        :param pulumi.Input[_builtins.str] user_search_attribute: User search attribute. Default `uid|sn|givenName` (string)
        :param pulumi.Input[_builtins.str] user_search_base: User search base DN (string)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthConfigOpenLdapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Auth Config OpenLdap resource. This can be used to configure and enable Auth Config OpenLdap for Rancher v2 RKE clusters and retrieve their information.

        In addition to the built-in local auth, only one external auth config provider can be enabled at a time.

        :param str resource_name: The name of the resource.
        :param AuthConfigOpenLdapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthConfigOpenLdapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_dn_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_member_user_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_base: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 nested_group_membership_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 start_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 test_password: Optional[pulumi.Input[_builtins.str]] = None,
                 test_username: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_disabled_bit_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 user_enabled_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_login_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_member_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_object_class: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_base: Optional[pulumi.Input[_builtins.str]] = None,
                 user_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthConfigOpenLdapArgs.__new__(AuthConfigOpenLdapArgs)

            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["allowed_principal_ids"] = allowed_principal_ids
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["certificate"] = None if certificate is None else pulumi.Output.secret(certificate)
            __props__.__dict__["connection_timeout"] = connection_timeout
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["group_dn_attribute"] = group_dn_attribute
            __props__.__dict__["group_member_mapping_attribute"] = group_member_mapping_attribute
            __props__.__dict__["group_member_user_attribute"] = group_member_user_attribute
            __props__.__dict__["group_name_attribute"] = group_name_attribute
            __props__.__dict__["group_object_class"] = group_object_class
            __props__.__dict__["group_search_attribute"] = group_search_attribute
            __props__.__dict__["group_search_base"] = group_search_base
            __props__.__dict__["group_search_filter"] = group_search_filter
            __props__.__dict__["labels"] = labels
            __props__.__dict__["nested_group_membership_enabled"] = nested_group_membership_enabled
            __props__.__dict__["port"] = port
            if servers is None and not opts.urn:
                raise TypeError("Missing required property 'servers'")
            __props__.__dict__["servers"] = servers
            if service_account_distinguished_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_distinguished_name'")
            __props__.__dict__["service_account_distinguished_name"] = None if service_account_distinguished_name is None else pulumi.Output.secret(service_account_distinguished_name)
            if service_account_password is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_password'")
            __props__.__dict__["service_account_password"] = None if service_account_password is None else pulumi.Output.secret(service_account_password)
            __props__.__dict__["start_tls"] = start_tls
            if test_password is None and not opts.urn:
                raise TypeError("Missing required property 'test_password'")
            __props__.__dict__["test_password"] = None if test_password is None else pulumi.Output.secret(test_password)
            if test_username is None and not opts.urn:
                raise TypeError("Missing required property 'test_username'")
            __props__.__dict__["test_username"] = test_username
            __props__.__dict__["tls"] = tls
            __props__.__dict__["user_disabled_bit_mask"] = user_disabled_bit_mask
            __props__.__dict__["user_enabled_attribute"] = user_enabled_attribute
            __props__.__dict__["user_login_attribute"] = user_login_attribute
            __props__.__dict__["user_member_attribute"] = user_member_attribute
            __props__.__dict__["user_name_attribute"] = user_name_attribute
            __props__.__dict__["user_object_class"] = user_object_class
            __props__.__dict__["user_search_attribute"] = user_search_attribute
            if user_search_base is None and not opts.urn:
                raise TypeError("Missing required property 'user_search_base'")
            __props__.__dict__["user_search_base"] = user_search_base
            __props__.__dict__["user_search_filter"] = user_search_filter
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificate", "serviceAccountDistinguishedName", "serviceAccountPassword", "testPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthConfigOpenLdap, __self__).__init__(
            'rancher2:index/authConfigOpenLdap:AuthConfigOpenLdap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            group_dn_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            group_member_mapping_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            group_member_user_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            group_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            group_object_class: Optional[pulumi.Input[_builtins.str]] = None,
            group_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            group_search_base: Optional[pulumi.Input[_builtins.str]] = None,
            group_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nested_group_membership_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_account_distinguished_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_password: Optional[pulumi.Input[_builtins.str]] = None,
            start_tls: Optional[pulumi.Input[_builtins.bool]] = None,
            test_password: Optional[pulumi.Input[_builtins.str]] = None,
            test_username: Optional[pulumi.Input[_builtins.str]] = None,
            tls: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_disabled_bit_mask: Optional[pulumi.Input[_builtins.int]] = None,
            user_enabled_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            user_login_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            user_member_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            user_object_class: Optional[pulumi.Input[_builtins.str]] = None,
            user_search_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            user_search_base: Optional[pulumi.Input[_builtins.str]] = None,
            user_search_filter: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthConfigOpenLdap':
        """
        Get an existing AuthConfigOpenLdap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `openldap_user://<DN>`  `openldap_group://<DN>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] certificate: Base64 encoded CA certificate for TLS if self-signed. Use filebase64(<FILE>) for encoding file (string)
        :param pulumi.Input[_builtins.int] connection_timeout: OpenLdap connection timeout. Default `5000` (int)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] group_dn_attribute: Group DN attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_member_mapping_attribute: Group member mapping attribute. Default `member` (string)
        :param pulumi.Input[_builtins.str] group_member_user_attribute: Group member user attribute. Default `entryDN` (string)
        :param pulumi.Input[_builtins.str] group_name_attribute: Group name attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_object_class: Group object class. Default `groupOfNames` (string)
        :param pulumi.Input[_builtins.str] group_search_attribute: Group search attribute. Default `cn` (string)
        :param pulumi.Input[_builtins.str] group_search_base: Group search base (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: (Computed) The name of the resource (string)
        :param pulumi.Input[_builtins.bool] nested_group_membership_enabled: Nested group membership enable. Default `false` (bool)
        :param pulumi.Input[_builtins.int] port: OpenLdap port. Default `389` (int)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] servers: OpenLdap servers list (list)
        :param pulumi.Input[_builtins.str] service_account_distinguished_name: Service account DN for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] service_account_password: Service account password for access OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_password: Password for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.str] test_username: Username for test access to OpenLdap service (string)
        :param pulumi.Input[_builtins.bool] tls: Enable TLS connection (bool)
        :param pulumi.Input[_builtins.str] type: (Computed) The type of the resource (string)
        :param pulumi.Input[_builtins.int] user_disabled_bit_mask: User disabled bit mask (int)
        :param pulumi.Input[_builtins.str] user_enabled_attribute: User enable attribute (string)
        :param pulumi.Input[_builtins.str] user_login_attribute: User login attribute. Default `uid` (string)
        :param pulumi.Input[_builtins.str] user_member_attribute: User member attribute. Default `memberOf` (string)
        :param pulumi.Input[_builtins.str] user_name_attribute: User name attribute. Default `givenName` (string)
        :param pulumi.Input[_builtins.str] user_object_class: User object class. Default `inetorgperson` (string)
        :param pulumi.Input[_builtins.str] user_search_attribute: User search attribute. Default `uid|sn|givenName` (string)
        :param pulumi.Input[_builtins.str] user_search_base: User search base DN (string)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthConfigOpenLdapState.__new__(_AuthConfigOpenLdapState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["allowed_principal_ids"] = allowed_principal_ids
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["connection_timeout"] = connection_timeout
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["group_dn_attribute"] = group_dn_attribute
        __props__.__dict__["group_member_mapping_attribute"] = group_member_mapping_attribute
        __props__.__dict__["group_member_user_attribute"] = group_member_user_attribute
        __props__.__dict__["group_name_attribute"] = group_name_attribute
        __props__.__dict__["group_object_class"] = group_object_class
        __props__.__dict__["group_search_attribute"] = group_search_attribute
        __props__.__dict__["group_search_base"] = group_search_base
        __props__.__dict__["group_search_filter"] = group_search_filter
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["nested_group_membership_enabled"] = nested_group_membership_enabled
        __props__.__dict__["port"] = port
        __props__.__dict__["servers"] = servers
        __props__.__dict__["service_account_distinguished_name"] = service_account_distinguished_name
        __props__.__dict__["service_account_password"] = service_account_password
        __props__.__dict__["start_tls"] = start_tls
        __props__.__dict__["test_password"] = test_password
        __props__.__dict__["test_username"] = test_username
        __props__.__dict__["tls"] = tls
        __props__.__dict__["type"] = type
        __props__.__dict__["user_disabled_bit_mask"] = user_disabled_bit_mask
        __props__.__dict__["user_enabled_attribute"] = user_enabled_attribute
        __props__.__dict__["user_login_attribute"] = user_login_attribute
        __props__.__dict__["user_member_attribute"] = user_member_attribute
        __props__.__dict__["user_name_attribute"] = user_name_attribute
        __props__.__dict__["user_object_class"] = user_object_class
        __props__.__dict__["user_search_attribute"] = user_search_attribute
        __props__.__dict__["user_search_base"] = user_search_base
        __props__.__dict__["user_search_filter"] = user_search_filter
        return AuthConfigOpenLdap(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="allowedPrincipalIds")
    def allowed_principal_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `openldap_user://<DN>`  `openldap_group://<DN>` (list)
        """
        return pulumi.get(self, "allowed_principal_ids")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64 encoded CA certificate for TLS if self-signed. Use filebase64(<FILE>) for encoding file (string)
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        OpenLdap connection timeout. Default `5000` (int)
        """
        return pulumi.get(self, "connection_timeout")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable auth config provider. Default `true` (bool)
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="groupDnAttribute")
    def group_dn_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        Group DN attribute. Default `entryDN` (string)
        """
        return pulumi.get(self, "group_dn_attribute")

    @_builtins.property
    @pulumi.getter(name="groupMemberMappingAttribute")
    def group_member_mapping_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        Group member mapping attribute. Default `member` (string)
        """
        return pulumi.get(self, "group_member_mapping_attribute")

    @_builtins.property
    @pulumi.getter(name="groupMemberUserAttribute")
    def group_member_user_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        Group member user attribute. Default `entryDN` (string)
        """
        return pulumi.get(self, "group_member_user_attribute")

    @_builtins.property
    @pulumi.getter(name="groupNameAttribute")
    def group_name_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        Group name attribute. Default `cn` (string)
        """
        return pulumi.get(self, "group_name_attribute")

    @_builtins.property
    @pulumi.getter(name="groupObjectClass")
    def group_object_class(self) -> pulumi.Output[_builtins.str]:
        """
        Group object class. Default `groupOfNames` (string)
        """
        return pulumi.get(self, "group_object_class")

    @_builtins.property
    @pulumi.getter(name="groupSearchAttribute")
    def group_search_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        Group search attribute. Default `cn` (string)
        """
        return pulumi.get(self, "group_search_attribute")

    @_builtins.property
    @pulumi.getter(name="groupSearchBase")
    def group_search_base(self) -> pulumi.Output[_builtins.str]:
        """
        Group search base (string)
        """
        return pulumi.get(self, "group_search_base")

    @_builtins.property
    @pulumi.getter(name="groupSearchFilter")
    def group_search_filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "group_search_filter")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The name of the resource (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nestedGroupMembershipEnabled")
    def nested_group_membership_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Nested group membership enable. Default `false` (bool)
        """
        return pulumi.get(self, "nested_group_membership_enabled")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        OpenLdap port. Default `389` (int)
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        OpenLdap servers list (list)
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter(name="serviceAccountDistinguishedName")
    def service_account_distinguished_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service account DN for access OpenLdap service (string)
        """
        return pulumi.get(self, "service_account_distinguished_name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountPassword")
    def service_account_password(self) -> pulumi.Output[_builtins.str]:
        """
        Service account password for access OpenLdap service (string)
        """
        return pulumi.get(self, "service_account_password")

    @_builtins.property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "start_tls")

    @_builtins.property
    @pulumi.getter(name="testPassword")
    def test_password(self) -> pulumi.Output[_builtins.str]:
        """
        Password for test access to OpenLdap service (string)
        """
        return pulumi.get(self, "test_password")

    @_builtins.property
    @pulumi.getter(name="testUsername")
    def test_username(self) -> pulumi.Output[_builtins.str]:
        """
        Username for test access to OpenLdap service (string)
        """
        return pulumi.get(self, "test_username")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable TLS connection (bool)
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The type of the resource (string)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userDisabledBitMask")
    def user_disabled_bit_mask(self) -> pulumi.Output[_builtins.int]:
        """
        User disabled bit mask (int)
        """
        return pulumi.get(self, "user_disabled_bit_mask")

    @_builtins.property
    @pulumi.getter(name="userEnabledAttribute")
    def user_enabled_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        User enable attribute (string)
        """
        return pulumi.get(self, "user_enabled_attribute")

    @_builtins.property
    @pulumi.getter(name="userLoginAttribute")
    def user_login_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        User login attribute. Default `uid` (string)
        """
        return pulumi.get(self, "user_login_attribute")

    @_builtins.property
    @pulumi.getter(name="userMemberAttribute")
    def user_member_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        User member attribute. Default `memberOf` (string)
        """
        return pulumi.get(self, "user_member_attribute")

    @_builtins.property
    @pulumi.getter(name="userNameAttribute")
    def user_name_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        User name attribute. Default `givenName` (string)
        """
        return pulumi.get(self, "user_name_attribute")

    @_builtins.property
    @pulumi.getter(name="userObjectClass")
    def user_object_class(self) -> pulumi.Output[_builtins.str]:
        """
        User object class. Default `inetorgperson` (string)
        """
        return pulumi.get(self, "user_object_class")

    @_builtins.property
    @pulumi.getter(name="userSearchAttribute")
    def user_search_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        User search attribute. Default `uid|sn|givenName` (string)
        """
        return pulumi.get(self, "user_search_attribute")

    @_builtins.property
    @pulumi.getter(name="userSearchBase")
    def user_search_base(self) -> pulumi.Output[_builtins.str]:
        """
        User search base DN (string)
        """
        return pulumi.get(self, "user_search_base")

    @_builtins.property
    @pulumi.getter(name="userSearchFilter")
    def user_search_filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "user_search_filter")

