# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetClusterV2Result',
    'AwaitableGetClusterV2Result',
    'get_cluster_v2',
    'get_cluster_v2_output',
]

@pulumi.output_type
class GetClusterV2Result:
    """
    A collection of values returned by getClusterV2.
    """
    def __init__(__self__, agent_env_vars=None, annotations=None, cloud_credential_secret_name=None, cluster_registration_token=None, cluster_v1_id=None, default_cluster_role_for_project_members=None, default_pod_security_admission_configuration_template_name=None, enable_network_policy=None, fleet_namespace=None, id=None, kube_config=None, kubernetes_version=None, labels=None, name=None, resource_version=None, rke_config=None):
        if agent_env_vars and not isinstance(agent_env_vars, list):
            raise TypeError("Expected argument 'agent_env_vars' to be a list")
        pulumi.set(__self__, "agent_env_vars", agent_env_vars)
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if cloud_credential_secret_name and not isinstance(cloud_credential_secret_name, str):
            raise TypeError("Expected argument 'cloud_credential_secret_name' to be a str")
        pulumi.set(__self__, "cloud_credential_secret_name", cloud_credential_secret_name)
        if cluster_registration_token and not isinstance(cluster_registration_token, dict):
            raise TypeError("Expected argument 'cluster_registration_token' to be a dict")
        pulumi.set(__self__, "cluster_registration_token", cluster_registration_token)
        if cluster_v1_id and not isinstance(cluster_v1_id, str):
            raise TypeError("Expected argument 'cluster_v1_id' to be a str")
        pulumi.set(__self__, "cluster_v1_id", cluster_v1_id)
        if default_cluster_role_for_project_members and not isinstance(default_cluster_role_for_project_members, str):
            raise TypeError("Expected argument 'default_cluster_role_for_project_members' to be a str")
        pulumi.set(__self__, "default_cluster_role_for_project_members", default_cluster_role_for_project_members)
        if default_pod_security_admission_configuration_template_name and not isinstance(default_pod_security_admission_configuration_template_name, str):
            raise TypeError("Expected argument 'default_pod_security_admission_configuration_template_name' to be a str")
        pulumi.set(__self__, "default_pod_security_admission_configuration_template_name", default_pod_security_admission_configuration_template_name)
        if enable_network_policy and not isinstance(enable_network_policy, bool):
            raise TypeError("Expected argument 'enable_network_policy' to be a bool")
        pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if fleet_namespace and not isinstance(fleet_namespace, str):
            raise TypeError("Expected argument 'fleet_namespace' to be a str")
        pulumi.set(__self__, "fleet_namespace", fleet_namespace)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kube_config and not isinstance(kube_config, str):
            raise TypeError("Expected argument 'kube_config' to be a str")
        pulumi.set(__self__, "kube_config", kube_config)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_version and not isinstance(resource_version, str):
            raise TypeError("Expected argument 'resource_version' to be a str")
        pulumi.set(__self__, "resource_version", resource_version)
        if rke_config and not isinstance(rke_config, dict):
            raise TypeError("Expected argument 'rke_config' to be a dict")
        pulumi.set(__self__, "rke_config", rke_config)

    @_builtins.property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> Sequence['outputs.GetClusterV2AgentEnvVarResult']:
        """
        (Computed) Optional Agent Env Vars for Rancher agent (list)
        """
        return pulumi.get(self, "agent_env_vars")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="cloudCredentialSecretName")
    def cloud_credential_secret_name(self) -> _builtins.str:
        """
        (Computed) Cluster V2 cloud credential secret name (string)
        """
        return pulumi.get(self, "cloud_credential_secret_name")

    @_builtins.property
    @pulumi.getter(name="clusterRegistrationToken")
    def cluster_registration_token(self) -> 'outputs.GetClusterV2ClusterRegistrationTokenResult':
        """
        (Computed/Sensitive) Cluster Registration Token generated for the cluster v2 (list maxitems:1)
        """
        return pulumi.get(self, "cluster_registration_token")

    @_builtins.property
    @pulumi.getter(name="clusterV1Id")
    def cluster_v1_id(self) -> _builtins.str:
        """
        (Computed) Cluster v1 id for cluster v2 (string)
        """
        return pulumi.get(self, "cluster_v1_id")

    @_builtins.property
    @pulumi.getter(name="defaultClusterRoleForProjectMembers")
    def default_cluster_role_for_project_members(self) -> _builtins.str:
        """
        (Computed) Cluster V2 default cluster role for project members (string)
        """
        return pulumi.get(self, "default_cluster_role_for_project_members")

    @_builtins.property
    @pulumi.getter(name="defaultPodSecurityAdmissionConfigurationTemplateName")
    def default_pod_security_admission_configuration_template_name(self) -> _builtins.str:
        """
        (Computed) Cluster V2 default pod security admission configuration template name (string)
        """
        return pulumi.get(self, "default_pod_security_admission_configuration_template_name")

    @_builtins.property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> _builtins.bool:
        """
        (Computed) Enable k8s network policy at Cluster V2 (bool)
        """
        return pulumi.get(self, "enable_network_policy")

    @_builtins.property
    @pulumi.getter(name="fleetNamespace")
    def fleet_namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fleet_namespace")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> _builtins.str:
        """
        (Computed/Sensitive) Kube Config generated for the cluster v2 (string)
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> _builtins.str:
        """
        (Computed) The kubernetes version of the Cluster v2 (list maxitems:1)
        """
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> _builtins.str:
        """
        (Computed) Cluster v2 k8s resource version (string)
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> 'outputs.GetClusterV2RkeConfigResult':
        """
        (Computed) The RKE configuration for `k3s` and `rke2` Clusters v2. (list maxitems:1)
        """
        return pulumi.get(self, "rke_config")


class AwaitableGetClusterV2Result(GetClusterV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterV2Result(
            agent_env_vars=self.agent_env_vars,
            annotations=self.annotations,
            cloud_credential_secret_name=self.cloud_credential_secret_name,
            cluster_registration_token=self.cluster_registration_token,
            cluster_v1_id=self.cluster_v1_id,
            default_cluster_role_for_project_members=self.default_cluster_role_for_project_members,
            default_pod_security_admission_configuration_template_name=self.default_pod_security_admission_configuration_template_name,
            enable_network_policy=self.enable_network_policy,
            fleet_namespace=self.fleet_namespace,
            id=self.id,
            kube_config=self.kube_config,
            kubernetes_version=self.kubernetes_version,
            labels=self.labels,
            name=self.name,
            resource_version=self.resource_version,
            rke_config=self.rke_config)


def get_cluster_v2(fleet_namespace: Optional[_builtins.str] = None,
                   name: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterV2Result:
    """
    Use this data source to retrieve information about a Rancher v2 cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_cluster_v2(name="foo",
        fleet_namespace="fleet-ns")
    ```


    :param _builtins.str fleet_namespace: The fleet namespace of the Cluster v2. Default: `\\"fleet-default\\"` (string)
    :param _builtins.str name: The name of the Cluster v2 (string)
    """
    __args__ = dict()
    __args__['fleetNamespace'] = fleet_namespace
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('rancher2:index/getClusterV2:getClusterV2', __args__, opts=opts, typ=GetClusterV2Result).value

    return AwaitableGetClusterV2Result(
        agent_env_vars=pulumi.get(__ret__, 'agent_env_vars'),
        annotations=pulumi.get(__ret__, 'annotations'),
        cloud_credential_secret_name=pulumi.get(__ret__, 'cloud_credential_secret_name'),
        cluster_registration_token=pulumi.get(__ret__, 'cluster_registration_token'),
        cluster_v1_id=pulumi.get(__ret__, 'cluster_v1_id'),
        default_cluster_role_for_project_members=pulumi.get(__ret__, 'default_cluster_role_for_project_members'),
        default_pod_security_admission_configuration_template_name=pulumi.get(__ret__, 'default_pod_security_admission_configuration_template_name'),
        enable_network_policy=pulumi.get(__ret__, 'enable_network_policy'),
        fleet_namespace=pulumi.get(__ret__, 'fleet_namespace'),
        id=pulumi.get(__ret__, 'id'),
        kube_config=pulumi.get(__ret__, 'kube_config'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        resource_version=pulumi.get(__ret__, 'resource_version'),
        rke_config=pulumi.get(__ret__, 'rke_config'))
def get_cluster_v2_output(fleet_namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          name: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterV2Result]:
    """
    Use this data source to retrieve information about a Rancher v2 cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_cluster_v2(name="foo",
        fleet_namespace="fleet-ns")
    ```


    :param _builtins.str fleet_namespace: The fleet namespace of the Cluster v2. Default: `\\"fleet-default\\"` (string)
    :param _builtins.str name: The name of the Cluster v2 (string)
    """
    __args__ = dict()
    __args__['fleetNamespace'] = fleet_namespace
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('rancher2:index/getClusterV2:getClusterV2', __args__, opts=opts, typ=GetClusterV2Result)
    return __ret__.apply(lambda __response__: GetClusterV2Result(
        agent_env_vars=pulumi.get(__response__, 'agent_env_vars'),
        annotations=pulumi.get(__response__, 'annotations'),
        cloud_credential_secret_name=pulumi.get(__response__, 'cloud_credential_secret_name'),
        cluster_registration_token=pulumi.get(__response__, 'cluster_registration_token'),
        cluster_v1_id=pulumi.get(__response__, 'cluster_v1_id'),
        default_cluster_role_for_project_members=pulumi.get(__response__, 'default_cluster_role_for_project_members'),
        default_pod_security_admission_configuration_template_name=pulumi.get(__response__, 'default_pod_security_admission_configuration_template_name'),
        enable_network_policy=pulumi.get(__response__, 'enable_network_policy'),
        fleet_namespace=pulumi.get(__response__, 'fleet_namespace'),
        id=pulumi.get(__response__, 'id'),
        kube_config=pulumi.get(__response__, 'kube_config'),
        kubernetes_version=pulumi.get(__response__, 'kubernetes_version'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        resource_version=pulumi.get(__response__, 'resource_version'),
        rke_config=pulumi.get(__response__, 'rke_config')))
