# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PodSecurityAdmissionConfigurationTemplateArgs', 'PodSecurityAdmissionConfigurationTemplate']

@pulumi.input_type
class PodSecurityAdmissionConfigurationTemplateArgs:
    def __init__(__self__, *,
                 defaults: pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exemptions: Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PodSecurityAdmissionConfigurationTemplate resource.
        :param pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs'] defaults: The default level labels and version labels to be applied when labels for a mode is not set (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] description: The description of the pod security admission configuration template (string)
        :param pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs'] exemptions: The authenticated usernames, runtime class names, and namespaces to exempt (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: The name of the pod security admission configuration template (string)
        """
        pulumi.set(__self__, "defaults", defaults)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exemptions is not None:
            pulumi.set(__self__, "exemptions", exemptions)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def defaults(self) -> pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs']:
        """
        The default level labels and version labels to be applied when labels for a mode is not set (list maxitems:1)
        """
        return pulumi.get(self, "defaults")

    @defaults.setter
    def defaults(self, value: pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs']):
        pulumi.set(self, "defaults", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the pod security admission configuration template (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def exemptions(self) -> Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs']]:
        """
        The authenticated usernames, runtime class names, and namespaces to exempt (list maxitems:1)
        """
        return pulumi.get(self, "exemptions")

    @exemptions.setter
    def exemptions(self, value: Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs']]):
        pulumi.set(self, "exemptions", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pod security admission configuration template (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PodSecurityAdmissionConfigurationTemplateState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 defaults: Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exemptions: Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PodSecurityAdmissionConfigurationTemplate resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs'] defaults: The default level labels and version labels to be applied when labels for a mode is not set (list maxitems:1)
        :param pulumi.Input[_builtins.str] description: The description of the pod security admission configuration template (string)
        :param pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs'] exemptions: The authenticated usernames, runtime class names, and namespaces to exempt (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: The name of the pod security admission configuration template (string)
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if defaults is not None:
            pulumi.set(__self__, "defaults", defaults)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exemptions is not None:
            pulumi.set(__self__, "exemptions", exemptions)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def defaults(self) -> Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs']]:
        """
        The default level labels and version labels to be applied when labels for a mode is not set (list maxitems:1)
        """
        return pulumi.get(self, "defaults")

    @defaults.setter
    def defaults(self, value: Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateDefaultsArgs']]):
        pulumi.set(self, "defaults", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the pod security admission configuration template (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def exemptions(self) -> Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs']]:
        """
        The authenticated usernames, runtime class names, and namespaces to exempt (list maxitems:1)
        """
        return pulumi.get(self, "exemptions")

    @exemptions.setter
    def exemptions(self, value: Optional[pulumi.Input['PodSecurityAdmissionConfigurationTemplateExemptionsArgs']]):
        pulumi.set(self, "exemptions", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pod security admission configuration template (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("rancher2:index/podSecurityAdmissionConfigurationTemplate:PodSecurityAdmissionConfigurationTemplate")
class PodSecurityAdmissionConfigurationTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 defaults: Optional[pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateDefaultsArgs', 'PodSecurityAdmissionConfigurationTemplateDefaultsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exemptions: Optional[pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateExemptionsArgs', 'PodSecurityAdmissionConfigurationTemplateExemptionsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a rancher v2 pod security admission configration template resource.
        This can be used to create pod security admission configration templates and retrieve their information.

        For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a Pod Security Admission Configuration Template resource
        foo = rancher2.PodSecurityAdmissionConfigurationTemplate("foo",
            name="custom-psact",
            description="This is my custom Pod Security Admission Configuration Template",
            defaults={
                "audit": "restricted",
                "audit_version": "latest",
                "enforce": "restricted",
                "enforce_version": "latest",
                "warn": "restricted",
                "warn_version": "latest",
            },
            exemptions={
                "usernames": ["testuser"],
                "runtime_classes": ["testclass"],
                "namespaces": [
                    "ingress-nginx",
                    "kube-system",
                ],
            })
        ```

        ## Import

        Pod Security Admission Configration Templates can be imported using its ID:

        ```sh
        $ pulumi import rancher2:index/podSecurityAdmissionConfigurationTemplate:PodSecurityAdmissionConfigurationTemplate foo &lt;resource_id&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateDefaultsArgs', 'PodSecurityAdmissionConfigurationTemplateDefaultsArgsDict']] defaults: The default level labels and version labels to be applied when labels for a mode is not set (list maxitems:1)
        :param pulumi.Input[_builtins.str] description: The description of the pod security admission configuration template (string)
        :param pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateExemptionsArgs', 'PodSecurityAdmissionConfigurationTemplateExemptionsArgsDict']] exemptions: The authenticated usernames, runtime class names, and namespaces to exempt (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: The name of the pod security admission configuration template (string)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PodSecurityAdmissionConfigurationTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a rancher v2 pod security admission configration template resource.
        This can be used to create pod security admission configration templates and retrieve their information.

        For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a Pod Security Admission Configuration Template resource
        foo = rancher2.PodSecurityAdmissionConfigurationTemplate("foo",
            name="custom-psact",
            description="This is my custom Pod Security Admission Configuration Template",
            defaults={
                "audit": "restricted",
                "audit_version": "latest",
                "enforce": "restricted",
                "enforce_version": "latest",
                "warn": "restricted",
                "warn_version": "latest",
            },
            exemptions={
                "usernames": ["testuser"],
                "runtime_classes": ["testclass"],
                "namespaces": [
                    "ingress-nginx",
                    "kube-system",
                ],
            })
        ```

        ## Import

        Pod Security Admission Configration Templates can be imported using its ID:

        ```sh
        $ pulumi import rancher2:index/podSecurityAdmissionConfigurationTemplate:PodSecurityAdmissionConfigurationTemplate foo &lt;resource_id&gt;
        ```

        :param str resource_name: The name of the resource.
        :param PodSecurityAdmissionConfigurationTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PodSecurityAdmissionConfigurationTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 defaults: Optional[pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateDefaultsArgs', 'PodSecurityAdmissionConfigurationTemplateDefaultsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exemptions: Optional[pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateExemptionsArgs', 'PodSecurityAdmissionConfigurationTemplateExemptionsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PodSecurityAdmissionConfigurationTemplateArgs.__new__(PodSecurityAdmissionConfigurationTemplateArgs)

            __props__.__dict__["annotations"] = annotations
            if defaults is None and not opts.urn:
                raise TypeError("Missing required property 'defaults'")
            __props__.__dict__["defaults"] = defaults
            __props__.__dict__["description"] = description
            __props__.__dict__["exemptions"] = exemptions
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
        super(PodSecurityAdmissionConfigurationTemplate, __self__).__init__(
            'rancher2:index/podSecurityAdmissionConfigurationTemplate:PodSecurityAdmissionConfigurationTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            defaults: Optional[pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateDefaultsArgs', 'PodSecurityAdmissionConfigurationTemplateDefaultsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exemptions: Optional[pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateExemptionsArgs', 'PodSecurityAdmissionConfigurationTemplateExemptionsArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'PodSecurityAdmissionConfigurationTemplate':
        """
        Get an existing PodSecurityAdmissionConfigurationTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateDefaultsArgs', 'PodSecurityAdmissionConfigurationTemplateDefaultsArgsDict']] defaults: The default level labels and version labels to be applied when labels for a mode is not set (list maxitems:1)
        :param pulumi.Input[_builtins.str] description: The description of the pod security admission configuration template (string)
        :param pulumi.Input[Union['PodSecurityAdmissionConfigurationTemplateExemptionsArgs', 'PodSecurityAdmissionConfigurationTemplateExemptionsArgsDict']] exemptions: The authenticated usernames, runtime class names, and namespaces to exempt (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: The name of the pod security admission configuration template (string)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PodSecurityAdmissionConfigurationTemplateState.__new__(_PodSecurityAdmissionConfigurationTemplateState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["defaults"] = defaults
        __props__.__dict__["description"] = description
        __props__.__dict__["exemptions"] = exemptions
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        return PodSecurityAdmissionConfigurationTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def defaults(self) -> pulumi.Output['outputs.PodSecurityAdmissionConfigurationTemplateDefaults']:
        """
        The default level labels and version labels to be applied when labels for a mode is not set (list maxitems:1)
        """
        return pulumi.get(self, "defaults")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the pod security admission configuration template (string)
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def exemptions(self) -> pulumi.Output[Optional['outputs.PodSecurityAdmissionConfigurationTemplateExemptions']]:
        """
        The authenticated usernames, runtime class names, and namespaces to exempt (list maxitems:1)
        """
        return pulumi.get(self, "exemptions")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the pod security admission configuration template (string)
        """
        return pulumi.get(self, "name")

