"""first user

Revision ID: 766f95525665
Revises: 781e4925ae00
Create Date: 2023-08-28 13:53:49.944064

"""
from typing import Sequence, Union

from alembic import op

from utils.auth_system import AuthSystem

# revision identifiers, used by Alembic.
revision: str = '766f95525665'
down_revision: Union[str, None] = 'd14296ae5e11'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    from axdocsystem.src.settings import Settings

    settings = Settings()  # type: ignore
    auth_system = AuthSystem(settings)
    pass_hash = auth_system.get_password_hash(settings.FIRST_USER_PASSWD)

    op.execute(
        f"""
            INSERT INTO users (email, fullname, password_hash, phone, is_active, created_at) VALUES 
            ('{settings.FIRST_USER_EMAIL}', '{settings.FIRST_USER_NAME}', '{pass_hash}', '{settings.FIRST_USER_NAME}', true, DATE('NOW'));
        """
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    from axdocsystem.src.settings import Settings

    settings = Settings()  # type: ignore
    op.execute(
        f"""
            DELETE FROM users WHERE email = '{settings.FIRST_USER_EMAIL}'
        """
    )
    # ### end Alembic commands ###

