# Advanced Topics

!!! info "For Experienced Users"
    This section is designed for developers building production systems, optimizing performance, or extending LionAGI's capabilities. 

Deep dive into LionAGI's advanced features and production-ready capabilities.

## What You'll Learn

These advanced concepts will help you build robust, scalable, and observable multi-agent systems:

- **[Custom Operations](custom-operations.md)** - Build specialized operations
  for your workflows
- **[Flow Composition](flow-composition.md)** - Compose complex multi-agent
  flows
- **[Performance](performance.md)** - Optimize your LionAGI workflows
- **[Error Handling](error-handling.md)** - Handle failures gracefully
- **[Observability](observability.md)** - Monitor and debug your workflows

## Prerequisites

!!! warning "Required Knowledge"
    Before diving into advanced topics, make sure you have:
    
    - ✅ Completed the [Core Concepts](../core-concepts/) section
    - ✅ Built workflows using [Patterns](../patterns/)  
    - ✅ Experience with Python async/await programming
    - ✅ Understanding of multi-agent coordination concepts

## When to Use Advanced Features

!!! success "You Need Advanced Topics If:"
    - Building production systems with specific performance requirements
    - Need custom operations beyond the built-in types
    - Want detailed monitoring and observability 
    - Handling complex error scenarios and failures
    - Integrating with enterprise systems and databases

## Next Steps

!!! tip "After Mastering Advanced Topics"
    - [Integrations](../integrations/) - Connect with databases, tools, and services
    - [Migration Guides](../migration/) - If you're coming from other frameworks  
    - [For AI Agents](../for-ai-agents/) - Special guidance for AI-powered development
