# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class ProblemServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateProblem(self, request, **kwargs):
        path = "/problems"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.CreateProblemOutput"),
            **kwargs,
        )

    def UpdateProblem(self, request, **kwargs):
        path = "/problems/"+urllib.parse.quote(request.problem_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.problem_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.UpdateProblemOutput"),
            **kwargs,
        )

    def DeleteProblem(self, request, **kwargs):
        path = "/problems/"+urllib.parse.quote(request.problem_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.problem_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.DeleteProblemOutput"),
            **kwargs,
        )

    def DescribeProblem(self, request, **kwargs):
        path = "/problems/"+urllib.parse.quote(request.problem_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.problem_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.DescribeProblemOutput"),
            **kwargs,
        )

    def ListProblems(self, request, **kwargs):
        path = "/problems"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.ListProblemsOutput"),
            **kwargs,
        )

    def VoteProblem(self, request, **kwargs):
        path = "/problems/"+urllib.parse.quote(request.problem_id)+"/vote"

        # Cleanup URL parameters to avoid any ambiguity
        request.problem_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.VoteProblemOutput"),
            **kwargs,
        )

