# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class StatementServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateStatement(self, request, **kwargs):
        path = "/statements"

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.CreateStatementOutput"),
            **kwargs,
        )

    def UpdateStatement(self, request, **kwargs):
        path = "/statements/"+urllib.parse.quote(request.statement_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.statement_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.UpdateStatementOutput"),
            **kwargs,
        )

    def DeleteStatement(self, request, **kwargs):
        path = "/statements/"+urllib.parse.quote(request.statement_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.statement_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.DeleteStatementOutput"),
            **kwargs,
        )

    def DescribeStatement(self, request, **kwargs):
        path = "/statements/"+urllib.parse.quote(request.statement_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.statement_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.DescribeStatementOutput"),
            **kwargs,
        )

    def LookupStatement(self, request, **kwargs):
        path = "/translate"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.LookupStatementOutput"),
            **kwargs,
        )

    def PreviewStatement(self, request, **kwargs):
        path = "/renders"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.PreviewStatementOutput"),
            **kwargs,
        )

    def ListStatements(self, request, **kwargs):
        path = "/statements"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.atlas.ListStatementsOutput"),
            **kwargs,
        )

