# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class CognitoClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def Signout(self, request, **kwargs):
        path = "/self/signout"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.SignoutOutput"),
            **kwargs,
        )

    def CreateAccessKey(self, request, **kwargs):
        path = "/access-keys"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.CreateAccessKeyOutput"),
            **kwargs,
        )

    def DeleteAccessKey(self, request, **kwargs):
        path = "/access-keys/"+urllib.parse.quote(request.key_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.key_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.DeleteAccessKeyOutput"),
            **kwargs,
        )

    def ListAccessKeys(self, request, **kwargs):
        path = "/access-keys"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.ListAccessKeysOutput"),
            **kwargs,
        )

    def CreateUser(self, request, **kwargs):
        path = "/users"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.CreateUserOutput"),
            **kwargs,
        )

    def VerifyEmail(self, request, **kwargs):
        path = "/users/"+urllib.parse.quote(request.user_id)+"/verify"

        # Cleanup URL parameters to avoid any ambiguity
        request.user_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.VerifyEmailOutput"),
            **kwargs,
        )

    def ResendEmailVerification(self, request, **kwargs):
        path = "/self/email/resend-verification"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.ResendEmailVerificationOutput"),
            **kwargs,
        )

    def UpdateEmail(self, request, **kwargs):
        path = "/self/email"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.UpdateEmailOutput"),
            **kwargs,
        )

    def UpdateProfile(self, request, **kwargs):
        path = "/self"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.UpdateProfileOutput"),
            **kwargs,
        )

    def UpdatePicture(self, request, **kwargs):
        path = "/self/picture"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.UpdatePictureOutput"),
            **kwargs,
        )

    def UpdatePassword(self, request, **kwargs):
        path = "/self/password"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.UpdatePasswordOutput"),
            **kwargs,
        )

    def IntrospectUser(self, request, **kwargs):
        path = "/self"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.IntrospectUserOutput"),
            **kwargs,
        )

    def DescribeUser(self, request, **kwargs):
        path = "/users/"+urllib.parse.quote(request.user_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.user_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.DescribeUserOutput"),
            **kwargs,
        )

    def ListUsers(self, request, **kwargs):
        path = "/users"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.ListUsersOutput"),
            **kwargs,
        )

    def IntrospectQuota(self, request, **kwargs):
        path = "/self/quota"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.IntrospectQuotaOutput"),
            **kwargs,
        )

    def IntrospectRoles(self, request, **kwargs):
        path = "/self/roles"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.IntrospectRolesOutput"),
            **kwargs,
        )

    def ListRoles(self, request, **kwargs):
        path = "/users/"+urllib.parse.quote(request.user_id)+"/roles"

        # Cleanup URL parameters to avoid any ambiguity
        request.user_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.ListRolesOutput"),
            **kwargs,
        )

    def UpdateRoles(self, request, **kwargs):
        path = "/users/"+urllib.parse.quote(request.user_id)+"/roles"

        # Cleanup URL parameters to avoid any ambiguity
        request.user_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.UpdateRolesOutput"),
            **kwargs,
        )

    def StartRecovery(self, request, **kwargs):
        path = "/self/recovery"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.StartRecoveryOutput"),
            **kwargs,
        )

    def CompleteRecovery(self, request, **kwargs):
        path = "/users/"+urllib.parse.quote(request.user_id)+"/recover"

        # Cleanup URL parameters to avoid any ambiguity
        request.user_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.CompleteRecoverOutput"),
            **kwargs,
        )

    def SelfDestruct(self, request, **kwargs):
        path = "/self"

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.cognito.SelfDestructOutput"),
            **kwargs,
        )

