# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class ContentServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def DescribeFragment(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.DescribeFragmentOutput"),
            **kwargs,
        )

    def ListFragments(self, request, **kwargs):
        path = "/content/fragments"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.ListFragmentsOutput"),
            **kwargs,
        )

    def CreateFragment(self, request, **kwargs):
        path = "/content/fragments"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.CreateFragmentOutput"),
            **kwargs,
        )

    def UpdateFragment(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.UpdateFragmentOutput"),
            **kwargs,
        )

    def DeleteFragment(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.DeleteFragmentOutput"),
            **kwargs,
        )

    def DescribeVariant(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)+"/variants/"+urllib.parse.quote(request.variant_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""
        request.variant_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.DescribeVariantOutput"),
            **kwargs,
        )

    def ListVariants(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)+"/variants"

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.ListVariantsOutput"),
            **kwargs,
        )

    def CreateVariant(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)+"/variants"

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.CreateVariantOutput"),
            **kwargs,
        )

    def UpdateVariant(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)+"/variants/"+urllib.parse.quote(request.variant_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""
        request.variant_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.UpdateVariantOutput"),
            **kwargs,
        )

    def DeleteVariant(self, request, **kwargs):
        path = "/content/fragments/"+urllib.parse.quote(request.fragment_id)+"/variants/"+urllib.parse.quote(request.variant_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.fragment_id = ""
        request.variant_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.DeleteVariantOutput"),
            **kwargs,
        )

    def DescribePath(self, request, **kwargs):
        path = "/content/path"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.DescribePathOutput"),
            **kwargs,
        )

    def ListParents(self, request, **kwargs):
        path = "/content/parents"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.content.ListParentsOutput"),
            **kwargs,
        )

