# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class ModuleServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateModule(self, request, **kwargs):
        path = "/modules"

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.CreateModuleOutput"),
            **kwargs,
        )

    def UpdateModule(self, request, **kwargs):
        path = "/modules/"+urllib.parse.quote(request.module_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.module_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.UpdateModuleOutput"),
            **kwargs,
        )

    def DeleteModule(self, request, **kwargs):
        path = "/modules/"+urllib.parse.quote(request.module_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.module_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DeleteModuleOutput"),
            **kwargs,
        )

    def DescribeModule(self, request, **kwargs):
        path = "/modules/"+urllib.parse.quote(request.module_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.module_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DescribeModuleOutput"),
            **kwargs,
        )

    def ListModules(self, request, **kwargs):
        path = "/modules"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ListModulesOutput"),
            **kwargs,
        )

    def StartModule(self, request, **kwargs):
        path = "/modules/"+urllib.parse.quote(request.module_id)+"/start"

        # Cleanup URL parameters to avoid any ambiguity
        request.module_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.StartModuleOutput"),
            **kwargs,
        )

    def AssignModule(self, request, **kwargs):
        path = "/modules/"+urllib.parse.quote(request.module_id)+"/assignments/"+urllib.parse.quote(request.member_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.module_id = ""
        request.member_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.AssignModuleOutput"),
            **kwargs,
        )

    def UnassignModule(self, request, **kwargs):
        path = "/modules/"+urllib.parse.quote(request.module_id)+"/assignments/"+urllib.parse.quote(request.member_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.module_id = ""
        request.member_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.UnassignModuleOutput"),
            **kwargs,
        )

