# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class TicketServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateTicket(self, request, **kwargs):
        path = "/tickets"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.CreateTicketOutput"),
            **kwargs,
        )

    def UpdateTicket(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.UpdateTicketOutput"),
            **kwargs,
        )

    def ReadTicket(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)+"/read"

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.ReadTicketOutput"),
            **kwargs,
        )

    def DeleteTicket(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.DeleteTicketOutput"),
            **kwargs,
        )

    def DescribeTicket(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.DescribeTicketOutput"),
            **kwargs,
        )

    def ListTickets(self, request, **kwargs):
        path = "/tickets"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.ListTicketsOutput"),
            **kwargs,
        )

    def ReplyTicket(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)+"/replies"

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.ReplyTicketOutput"),
            **kwargs,
        )

    def ListReplies(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)+"/replies"

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.ListRepliesOutput"),
            **kwargs,
        )

    def DeleteReply(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)+"/replies/"+urllib.parse.quote(request.reply_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""
        request.reply_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.DeleteReplyOutput"),
            **kwargs,
        )

    def UpdateReply(self, request, **kwargs):
        path = "/tickets/"+urllib.parse.quote(request.ticket_id)+"/replies/"+urllib.parse.quote(request.reply_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.ticket_id = ""
        request.reply_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.judge.UpdateReplyOutput"),
            **kwargs,
        )

