# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class NewsletterServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def DescribeNewsletter(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DescribeNewsletterOutput"),
            **kwargs,
        )

    def ListNewsletters(self, request, **kwargs):
        path = "/newsletter"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.ListNewslettersOutput"),
            **kwargs,
        )

    def CreateNewsletter(self, request, **kwargs):
        path = "/newsletter"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.CreateNewsletterOutput"),
            **kwargs,
        )

    def UpdateNewsletter(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.UpdateNewsletterOutput"),
            **kwargs,
        )

    def DeleteNewsletter(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DeleteNewsletterOutput"),
            **kwargs,
        )

    def SendNewsletter(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)+"/send"

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.SendNewsletterOutput"),
            **kwargs,
        )

    def TestNewsletter(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)+"/test"

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.TestNewsletterOutput"),
            **kwargs,
        )

    def DescribeNewsletterTranslation(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DescribeNewsletterTranslationOutput"),
            **kwargs,
        )

    def ListNewsletterTranslations(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.ListNewsletterTranslationsOutput"),
            **kwargs,
        )

    def CreateNewsletterTranslation(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.CreateNewsletterTranslationOutput"),
            **kwargs,
        )

    def UpdateNewsletterTranslation(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.UpdateNewsletterTranslationOutput"),
            **kwargs,
        )

    def DeleteNewsletterTranslation(self, request, **kwargs):
        path = "/newsletter/"+urllib.parse.quote(request.newsletter_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.newsletter_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DeleteNewsletterTranslationOutput"),
            **kwargs,
        )

