# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class AchievementServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateAchievement(self, request, **kwargs):
        path = "/achievements"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.CreateAchievementOutput"),
            **kwargs,
        )

    def UpdateAchievement(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.UpdateAchievementOutput"),
            **kwargs,
        )

    def DeleteAchievement(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.DeleteAchievementOutput"),
            **kwargs,
        )

    def DescribeAchievement(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.DescribeAchievementOutput"),
            **kwargs,
        )

    def ListAchievements(self, request, **kwargs):
        path = "/achievements"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.ListAchievementsOutput"),
            **kwargs,
        )

    def DescribeAchievementTranslation(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.DescribeAchievementTranslationOutput"),
            **kwargs,
        )

    def ListAchievementTranslations(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.ListAchievementTranslationsOutput"),
            **kwargs,
        )

    def CreateAchievementTranslation(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.CreateAchievementTranslationOutput"),
            **kwargs,
        )

    def UpdateAchievementTranslation(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.UpdateAchievementTranslationOutput"),
            **kwargs,
        )

    def DeleteAchievementTranslation(self, request, **kwargs):
        path = "/achievements/"+urllib.parse.quote(request.achievement_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.achievement_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.reward.DeleteAchievementTranslationOutput"),
            **kwargs,
        )

