# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class EnumServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateEnum(self, request, **kwargs):
        path = "/enums"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.CreateEnumOutput"),
            **kwargs,
        )

    def DeleteEnum(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.DeleteEnumOutput"),
            **kwargs,
        )

    def UpdateEnum(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.UpdateEnumOutput"),
            **kwargs,
        )

    def DescribeEnum(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.DescribeEnumOutput"),
            **kwargs,
        )

    def ListEnums(self, request, **kwargs):
        path = "/enums"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.ListEnumsOutput"),
            **kwargs,
        )

    def CreateValue(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/items"

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.CreateValueOutput"),
            **kwargs,
        )

    def DeleteValue(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/values/"+urllib.parse.quote(request.value_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""
        request.value_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.DeleteValueOutput"),
            **kwargs,
        )

    def UpdateValue(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/values/"+urllib.parse.quote(request.value_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""
        request.value_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.UpdateValueOutput"),
            **kwargs,
        )

    def DescribeValue(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/values/"+urllib.parse.quote(request.value_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""
        request.value_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.DescribeValueOutput"),
            **kwargs,
        )

    def ListValues(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/items"

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.ListValuesOutput"),
            **kwargs,
        )

    def TranslateValue(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/values/"+urllib.parse.quote(request.value_id)+"/translations/"+urllib.parse.quote(request.locale)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""
        request.value_id = ""
        request.locale = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.TranslateValueOutput"),
            **kwargs,
        )

    def DeleteTranslation(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/values/"+urllib.parse.quote(request.value_id)+"/translations/"+urllib.parse.quote(request.locale)

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""
        request.value_id = ""
        request.locale = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.DeleteTranslationOutput"),
            **kwargs,
        )

    def ListTranslations(self, request, **kwargs):
        path = "/enums/"+urllib.parse.quote(request.enum_id)+"/values/"+urllib.parse.quote(request.value_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.enum_id = ""
        request.value_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.taxonomy.ListTranslationsOutput"),
            **kwargs,
        )

