# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class UniverseClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def LookupSpace(self, request, **kwargs):
        path = "/spaces/__lookup/"+urllib.parse.quote(request.key)

        # Cleanup URL parameters to avoid any ambiguity
        request.key = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.LookupSpaceOutput"),
            **kwargs,
        )

    def CreateSpace(self, request, **kwargs):
        path = "/spaces"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.CreateSpaceOutput"),
            **kwargs,
        )

    def UpdateSpace(self, request, **kwargs):
        path = "/spaces/"+urllib.parse.quote(request.space_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.space_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.UpdateSpaceOutput"),
            **kwargs,
        )

    def DeleteSpace(self, request, **kwargs):
        path = "/spaces/"+urllib.parse.quote(request.space_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.space_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.DeleteSpaceOutput"),
            **kwargs,
        )

    def DescribeSpace(self, request, **kwargs):
        path = "/spaces/"+urllib.parse.quote(request.space_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.space_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.DescribeSpaceOutput"),
            **kwargs,
        )

    def DescribeQuota(self, request, **kwargs):
        path = "/spaces/"+urllib.parse.quote(request.space_id)+"/quota"

        # Cleanup URL parameters to avoid any ambiguity
        request.space_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.DescribeQuotaOutput"),
            **kwargs,
        )

    def UpdateQuota(self, request, **kwargs):
        path = "/spaces/"+urllib.parse.quote(request.space_id)+"/quota"

        # Cleanup URL parameters to avoid any ambiguity
        request.space_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.UpdateQuotaOutput"),
            **kwargs,
        )

    def ListSpaces(self, request, **kwargs):
        path = "/spaces"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.ListSpacesOutput"),
            **kwargs,
        )

