import re

import pytest


def guess_datetime_format(date_str):
    format_patterns = [
        (r'^\d{4}-\d{2}-\d{2}$', '%Y-%m-%d'),
        (r'^\d{2}-\d{2}-\d{4}$', '%d-%m-%Y'),
        (r'^\d{2}/\d{2}/\d{4}$', '%d/%m/%Y'),
        (r'^\d{2}/\d{2}/\d{2}$', '%d/%m/%y'),
        (r'^\d{2}-\d{2}-\d{2}$', '%d-%m-%y'),
        (r'^[a-zA-Z]+ \d{1,2}, \d{4}$', '%B %d, %Y'),
        (r'^\d{4} [a-zA-Z]+ \d{1,2}$', '%Y %B %d'),
        (r'^\d{1,2}th [a-zA-Z]+ \d{4}$', '%dth %B %Y'),
        (r'^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$', '%Y-%m-%d %H:%M'),
        (r'^\d{2}-\d{2}-\d{4} \d{2}:\d{2} [APM]{2}$', '%d-%m-%Y %I:%M %p'),
        (r'^\d{2}/\d{2}/\d{4} \d{2}:\d{2}:\d{2}$', '%d/%m/%Y %H:%M:%S'),
        (r'^[a-zA-Z]+ \d{1,2}, \d{4} \d{1,2}:\d{2} [APM]{2}$', '%B %d, %Y %I:%M %p'),
        (r'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}$', '%Y-%m-%dT%H:%M:%S'),
        (r'^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$', '%Y-%m-%d %H:%M:%S'),
        (r'^\d{2}-\d{2}-\d{4} \d{2}:\d{2}:\d{2}$', '%d-%m-%Y %H:%M:%S'),
        (r'^\d{4}\d{2}\d{2} \d{2}\d{2}\d{2}$', '%Y%m%d %H%M%S'),
        (r'^\d{2}:\d{2} \d{4}-\d{2}-\d{2}$', '%H:%M %Y-%m-%d'),
        (r'^\d{2}:\d{2} [APM]{2} \d{2}-\d{2}-\d{4}$', '%I:%M %p %d-%m-%Y'),
        (r'^\d{2}:\d{2}:\d{2} \d{2}/\d{2}/\d{4}$', '%H:%M:%S %d/%m/%Y'),
        (r'^\d{1,2}:\d{2} [APM]{2} [a-zA-Z]+ \d{1,2}, \d{4}$', '%I:%M %p %B %d, %Y'),
        (r'^\d{2}:\d{2}:\d{2} \d{4}-\d{2}-\d{2}$', '%H:%M:%S %Y-%m-%d'),
        (r'^\d{6} \d{8}$', '%H%M%S %Y%m%d'),
        (r'^\d{1,2}:\d{2} [APM]{2} \d{4} [a-zA-Z]+ \d{1,2}$', '%I:%M %p %Y %B %d'),
        (r'^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}\.\d+$', '%Y-%m-%d %H:%M:%S.%f'),
        (r'^\d{2}:\d{2}:\d{2}\.\d+ \d{4}-\d{2}-\d{2}$', '%H:%M:%S.%f %Y-%m-%d'),
        (r'^[a-zA-Z]+ \d{1,2}, \d{4} at \d{1,2}:\d{2} [APM]{2}$', '%B %d, %Y at %I:%M %p'),
        (r'^\d{1,2}:\d{2} [APM]{2}, [a-zA-Z]+ \d{1,2}, \d{4}$', '%I:%M %p, %B %d, %Y'),
        (r'^\d{2}:\d{2}:\d{2} [APM]{2} \d{2}-\d{2}-\d{4}$', '%I:%M:%S %p %d-%m-%Y'),
        (r'^\d{2}:\d{2}:\d{2}\.\d{6} \d{2}/\d{2}/\d{4}$', '%H:%M:%S.%f %d/%m/%Y'),
        (r'^\d{4}-\d{2}-\d{2} \d{1,2}:\d{2}:\d{2} [APM]{2}$', '%Y-%m-%d %I:%M:%S %p'),
        (r'^\d{4}-[a-zA-Z]+-\d{2} \d{2}:\d{2}$', '%Y-%B-%d %H:%M'),
        (r'^\d{4}/\d{2}/\d{2} \d{2}:\d{2}$', '%Y/%m/%d %H:%M'),
        (r'^\d{4}年\d{2}月\d{2}日 \d{2}時\d{2}分$', '%Y年%m月%d日 %H時%M分'),
        (r'^\d{1,2} [a-zA-Z]+ \d{4}$', '%d %B %Y'),
        (r'^\d{2}/[a-zA-Z]+/\d{4}$', '%d/%B/%Y'),
    ]

    for pattern, date_format in format_patterns:
        if re.match(pattern, date_str):
            return date_format

    return ""

