# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.automation_rule_evaluator_page_public import AutomationRuleEvaluatorPagePublic
from ..types.automation_rule_evaluator_public import AutomationRuleEvaluatorPublic
from ..types.automation_rule_evaluator_update import AutomationRuleEvaluatorUpdate
from ..types.automation_rule_evaluator_write import AutomationRuleEvaluatorWrite
from ..types.log_page import LogPage
from .raw_client import AsyncRawAutomationRuleEvaluatorsClient, RawAutomationRuleEvaluatorsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AutomationRuleEvaluatorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAutomationRuleEvaluatorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAutomationRuleEvaluatorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAutomationRuleEvaluatorsClient
        """
        return self._raw_client

    def find_evaluators(
        self,
        *,
        project_id: typing.Optional[str] = None,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationRuleEvaluatorPagePublic:
        """
        Find project Evaluators

        Parameters
        ----------
        project_id : typing.Optional[str]

        id : typing.Optional[str]

        name : typing.Optional[str]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationRuleEvaluatorPagePublic
            Evaluators resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.automation_rule_evaluators.find_evaluators()
        """
        _response = self._raw_client.find_evaluators(
            project_id=project_id,
            id=id,
            name=name,
            filters=filters,
            sorting=sorting,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data

    def create_automation_rule_evaluator(
        self, *, request: AutomationRuleEvaluatorWrite, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Create automation rule evaluator

        Parameters
        ----------
        request : AutomationRuleEvaluatorWrite

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import AutomationRuleEvaluatorWrite_LlmAsJudge
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.automation_rule_evaluators.create_automation_rule_evaluator(request=AutomationRuleEvaluatorWrite_LlmAsJudge(), )
        """
        _response = self._raw_client.create_automation_rule_evaluator(request=request, request_options=request_options)
        return _response.data

    def delete_automation_rule_evaluator_batch(
        self,
        *,
        ids: typing.Sequence[str],
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete automation rule evaluators batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.automation_rule_evaluators.delete_automation_rule_evaluator_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_automation_rule_evaluator_batch(
            ids=ids, project_id=project_id, request_options=request_options
        )
        return _response.data

    def get_evaluator_by_id(
        self,
        id: str,
        *,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationRuleEvaluatorPublic:
        """
        Get automation rule by id

        Parameters
        ----------
        id : str

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationRuleEvaluatorPublic
            Automation Rule resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.automation_rule_evaluators.get_evaluator_by_id(id='id', )
        """
        _response = self._raw_client.get_evaluator_by_id(id, project_id=project_id, request_options=request_options)
        return _response.data

    def update_automation_rule_evaluator(
        self,
        id: str,
        *,
        request: AutomationRuleEvaluatorUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update Automation Rule Evaluator by id

        Parameters
        ----------
        id : str

        request : AutomationRuleEvaluatorUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import AutomationRuleEvaluatorUpdate_LlmAsJudge
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.automation_rule_evaluators.update_automation_rule_evaluator(id='id', request=AutomationRuleEvaluatorUpdate_LlmAsJudge(), )
        """
        _response = self._raw_client.update_automation_rule_evaluator(
            id, request=request, request_options=request_options
        )
        return _response.data

    def get_evaluator_logs_by_id(
        self, id: str, *, size: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> LogPage:
        """
        Get automation rule evaluator logs by id

        Parameters
        ----------
        id : str

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LogPage
            Automation rule evaluator logs resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.automation_rule_evaluators.get_evaluator_logs_by_id(id='id', )
        """
        _response = self._raw_client.get_evaluator_logs_by_id(id, size=size, request_options=request_options)
        return _response.data


class AsyncAutomationRuleEvaluatorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAutomationRuleEvaluatorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAutomationRuleEvaluatorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAutomationRuleEvaluatorsClient
        """
        return self._raw_client

    async def find_evaluators(
        self,
        *,
        project_id: typing.Optional[str] = None,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationRuleEvaluatorPagePublic:
        """
        Find project Evaluators

        Parameters
        ----------
        project_id : typing.Optional[str]

        id : typing.Optional[str]

        name : typing.Optional[str]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationRuleEvaluatorPagePublic
            Evaluators resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.automation_rule_evaluators.find_evaluators()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_evaluators(
            project_id=project_id,
            id=id,
            name=name,
            filters=filters,
            sorting=sorting,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data

    async def create_automation_rule_evaluator(
        self, *, request: AutomationRuleEvaluatorWrite, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Create automation rule evaluator

        Parameters
        ----------
        request : AutomationRuleEvaluatorWrite

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import AutomationRuleEvaluatorWrite_LlmAsJudge
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.automation_rule_evaluators.create_automation_rule_evaluator(request=AutomationRuleEvaluatorWrite_LlmAsJudge(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_automation_rule_evaluator(
            request=request, request_options=request_options
        )
        return _response.data

    async def delete_automation_rule_evaluator_batch(
        self,
        *,
        ids: typing.Sequence[str],
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete automation rule evaluators batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.automation_rule_evaluators.delete_automation_rule_evaluator_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_automation_rule_evaluator_batch(
            ids=ids, project_id=project_id, request_options=request_options
        )
        return _response.data

    async def get_evaluator_by_id(
        self,
        id: str,
        *,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationRuleEvaluatorPublic:
        """
        Get automation rule by id

        Parameters
        ----------
        id : str

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationRuleEvaluatorPublic
            Automation Rule resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.automation_rule_evaluators.get_evaluator_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_evaluator_by_id(
            id, project_id=project_id, request_options=request_options
        )
        return _response.data

    async def update_automation_rule_evaluator(
        self,
        id: str,
        *,
        request: AutomationRuleEvaluatorUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update Automation Rule Evaluator by id

        Parameters
        ----------
        id : str

        request : AutomationRuleEvaluatorUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import AutomationRuleEvaluatorUpdate_LlmAsJudge
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.automation_rule_evaluators.update_automation_rule_evaluator(id='id', request=AutomationRuleEvaluatorUpdate_LlmAsJudge(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_automation_rule_evaluator(
            id, request=request, request_options=request_options
        )
        return _response.data

    async def get_evaluator_logs_by_id(
        self, id: str, *, size: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> LogPage:
        """
        Get automation rule evaluator logs by id

        Parameters
        ----------
        id : str

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LogPage
            Automation rule evaluator logs resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.automation_rule_evaluators.get_evaluator_logs_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_evaluator_logs_by_id(id, size=size, request_options=request_options)
        return _response.data
