# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.chat_completion_response import ChatCompletionResponse
from ..types.function import Function
from ..types.function_call import FunctionCall
from ..types.message import Message
from ..types.response_format import ResponseFormat
from ..types.stream_options import StreamOptions
from ..types.tool import Tool
from .raw_client import AsyncRawChatCompletionsClient, RawChatCompletionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ChatCompletionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawChatCompletionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawChatCompletionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawChatCompletionsClient
        """
        return self._raw_client

    def create_chat_completions(
        self,
        *,
        model: typing.Optional[str] = OMIT,
        messages: typing.Optional[typing.Sequence[Message]] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        top_p: typing.Optional[float] = OMIT,
        n: typing.Optional[int] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        stream_options: typing.Optional[StreamOptions] = OMIT,
        stop: typing.Optional[typing.Sequence[str]] = OMIT,
        max_tokens: typing.Optional[int] = OMIT,
        max_completion_tokens: typing.Optional[int] = OMIT,
        presence_penalty: typing.Optional[float] = OMIT,
        frequency_penalty: typing.Optional[float] = OMIT,
        logit_bias: typing.Optional[typing.Dict[str, int]] = OMIT,
        user: typing.Optional[str] = OMIT,
        response_format: typing.Optional[ResponseFormat] = OMIT,
        seed: typing.Optional[int] = OMIT,
        tools: typing.Optional[typing.Sequence[Tool]] = OMIT,
        tool_choice: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        parallel_tool_calls: typing.Optional[bool] = OMIT,
        store: typing.Optional[bool] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        reasoning_effort: typing.Optional[str] = OMIT,
        service_tier: typing.Optional[str] = OMIT,
        functions: typing.Optional[typing.Sequence[Function]] = OMIT,
        function_call: typing.Optional[FunctionCall] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChatCompletionResponse:
        """
        Create chat completions

        Parameters
        ----------
        model : typing.Optional[str]

        messages : typing.Optional[typing.Sequence[Message]]

        temperature : typing.Optional[float]

        top_p : typing.Optional[float]

        n : typing.Optional[int]

        stream : typing.Optional[bool]

        stream_options : typing.Optional[StreamOptions]

        stop : typing.Optional[typing.Sequence[str]]

        max_tokens : typing.Optional[int]

        max_completion_tokens : typing.Optional[int]

        presence_penalty : typing.Optional[float]

        frequency_penalty : typing.Optional[float]

        logit_bias : typing.Optional[typing.Dict[str, int]]

        user : typing.Optional[str]

        response_format : typing.Optional[ResponseFormat]

        seed : typing.Optional[int]

        tools : typing.Optional[typing.Sequence[Tool]]

        tool_choice : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        parallel_tool_calls : typing.Optional[bool]

        store : typing.Optional[bool]

        metadata : typing.Optional[typing.Dict[str, str]]

        reasoning_effort : typing.Optional[str]

        service_tier : typing.Optional[str]

        functions : typing.Optional[typing.Sequence[Function]]

        function_call : typing.Optional[FunctionCall]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChatCompletionResponse
            Chat completions response

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.chat_completions.create_chat_completions()
        """
        _response = self._raw_client.create_chat_completions(
            model=model,
            messages=messages,
            temperature=temperature,
            top_p=top_p,
            n=n,
            stream=stream,
            stream_options=stream_options,
            stop=stop,
            max_tokens=max_tokens,
            max_completion_tokens=max_completion_tokens,
            presence_penalty=presence_penalty,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            user=user,
            response_format=response_format,
            seed=seed,
            tools=tools,
            tool_choice=tool_choice,
            parallel_tool_calls=parallel_tool_calls,
            store=store,
            metadata=metadata,
            reasoning_effort=reasoning_effort,
            service_tier=service_tier,
            functions=functions,
            function_call=function_call,
            request_options=request_options,
        )
        return _response.data


class AsyncChatCompletionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawChatCompletionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawChatCompletionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawChatCompletionsClient
        """
        return self._raw_client

    async def create_chat_completions(
        self,
        *,
        model: typing.Optional[str] = OMIT,
        messages: typing.Optional[typing.Sequence[Message]] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        top_p: typing.Optional[float] = OMIT,
        n: typing.Optional[int] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        stream_options: typing.Optional[StreamOptions] = OMIT,
        stop: typing.Optional[typing.Sequence[str]] = OMIT,
        max_tokens: typing.Optional[int] = OMIT,
        max_completion_tokens: typing.Optional[int] = OMIT,
        presence_penalty: typing.Optional[float] = OMIT,
        frequency_penalty: typing.Optional[float] = OMIT,
        logit_bias: typing.Optional[typing.Dict[str, int]] = OMIT,
        user: typing.Optional[str] = OMIT,
        response_format: typing.Optional[ResponseFormat] = OMIT,
        seed: typing.Optional[int] = OMIT,
        tools: typing.Optional[typing.Sequence[Tool]] = OMIT,
        tool_choice: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        parallel_tool_calls: typing.Optional[bool] = OMIT,
        store: typing.Optional[bool] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        reasoning_effort: typing.Optional[str] = OMIT,
        service_tier: typing.Optional[str] = OMIT,
        functions: typing.Optional[typing.Sequence[Function]] = OMIT,
        function_call: typing.Optional[FunctionCall] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChatCompletionResponse:
        """
        Create chat completions

        Parameters
        ----------
        model : typing.Optional[str]

        messages : typing.Optional[typing.Sequence[Message]]

        temperature : typing.Optional[float]

        top_p : typing.Optional[float]

        n : typing.Optional[int]

        stream : typing.Optional[bool]

        stream_options : typing.Optional[StreamOptions]

        stop : typing.Optional[typing.Sequence[str]]

        max_tokens : typing.Optional[int]

        max_completion_tokens : typing.Optional[int]

        presence_penalty : typing.Optional[float]

        frequency_penalty : typing.Optional[float]

        logit_bias : typing.Optional[typing.Dict[str, int]]

        user : typing.Optional[str]

        response_format : typing.Optional[ResponseFormat]

        seed : typing.Optional[int]

        tools : typing.Optional[typing.Sequence[Tool]]

        tool_choice : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        parallel_tool_calls : typing.Optional[bool]

        store : typing.Optional[bool]

        metadata : typing.Optional[typing.Dict[str, str]]

        reasoning_effort : typing.Optional[str]

        service_tier : typing.Optional[str]

        functions : typing.Optional[typing.Sequence[Function]]

        function_call : typing.Optional[FunctionCall]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChatCompletionResponse
            Chat completions response

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.chat_completions.create_chat_completions()
        asyncio.run(main())
        """
        _response = await self._raw_client.create_chat_completions(
            model=model,
            messages=messages,
            temperature=temperature,
            top_p=top_p,
            n=n,
            stream=stream,
            stream_options=stream_options,
            stop=stop,
            max_tokens=max_tokens,
            max_completion_tokens=max_completion_tokens,
            presence_penalty=presence_penalty,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            user=user,
            response_format=response_format,
            seed=seed,
            tools=tools,
            tool_choice=tool_choice,
            parallel_tool_calls=parallel_tool_calls,
            store=store,
            metadata=metadata,
            reasoning_effort=reasoning_effort,
            service_tier=service_tier,
            functions=functions,
            function_call=function_call,
            request_options=request_options,
        )
        return _response.data
