# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.dashboard_page_public import DashboardPagePublic
from ..types.dashboard_public import DashboardPublic
from ..types.json_node_public import JsonNodePublic
from ..types.json_node_write import JsonNodeWrite
from .raw_client import AsyncRawDashboardsClient, RawDashboardsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DashboardsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDashboardsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDashboardsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDashboardsClient
        """
        return self._raw_client

    def find_dashboards(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DashboardPagePublic:
        """
        Find dashboards in a workspace

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPagePublic
            Dashboard page

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.dashboards.find_dashboards()
        """
        _response = self._raw_client.find_dashboards(page=page, size=size, name=name, request_options=request_options)
        return _response.data

    def create_dashboard(
        self,
        *,
        name: str,
        config: JsonNodeWrite,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DashboardPublic:
        """
        Create a new dashboard in a workspace

        Parameters
        ----------
        name : str

        config : JsonNodeWrite

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPublic
            Created

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.dashboards.create_dashboard(name='name', config={'key': 'value'
        }, )
        """
        _response = self._raw_client.create_dashboard(
            name=name, config=config, description=description, request_options=request_options
        )
        return _response.data

    def get_dashboard_by_id(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DashboardPublic:
        """
        Get dashboard by id

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPublic
            Dashboard resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.dashboards.get_dashboard_by_id(dashboard_id='dashboardId', )
        """
        _response = self._raw_client.get_dashboard_by_id(dashboard_id, request_options=request_options)
        return _response.data

    def delete_dashboard(self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete dashboard by id

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.dashboards.delete_dashboard(dashboard_id='dashboardId', )
        """
        _response = self._raw_client.delete_dashboard(dashboard_id, request_options=request_options)
        return _response.data

    def update_dashboard(
        self,
        dashboard_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[JsonNodePublic] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DashboardPublic:
        """
        Update dashboard by id. Partial updates are supported - only provided fields will be updated.

        Parameters
        ----------
        dashboard_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        config : typing.Optional[JsonNodePublic]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPublic
            Updated dashboard

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.dashboards.update_dashboard(dashboard_id='dashboardId', )
        """
        _response = self._raw_client.update_dashboard(
            dashboard_id, name=name, description=description, config=config, request_options=request_options
        )
        return _response.data


class AsyncDashboardsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDashboardsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDashboardsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDashboardsClient
        """
        return self._raw_client

    async def find_dashboards(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DashboardPagePublic:
        """
        Find dashboards in a workspace

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPagePublic
            Dashboard page

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.dashboards.find_dashboards()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_dashboards(
            page=page, size=size, name=name, request_options=request_options
        )
        return _response.data

    async def create_dashboard(
        self,
        *,
        name: str,
        config: JsonNodeWrite,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DashboardPublic:
        """
        Create a new dashboard in a workspace

        Parameters
        ----------
        name : str

        config : JsonNodeWrite

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPublic
            Created

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.dashboards.create_dashboard(name='name', config={'key': 'value'
            }, )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_dashboard(
            name=name, config=config, description=description, request_options=request_options
        )
        return _response.data

    async def get_dashboard_by_id(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DashboardPublic:
        """
        Get dashboard by id

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPublic
            Dashboard resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.dashboards.get_dashboard_by_id(dashboard_id='dashboardId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dashboard_by_id(dashboard_id, request_options=request_options)
        return _response.data

    async def delete_dashboard(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete dashboard by id

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.dashboards.delete_dashboard(dashboard_id='dashboardId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_dashboard(dashboard_id, request_options=request_options)
        return _response.data

    async def update_dashboard(
        self,
        dashboard_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[JsonNodePublic] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DashboardPublic:
        """
        Update dashboard by id. Partial updates are supported - only provided fields will be updated.

        Parameters
        ----------
        dashboard_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        config : typing.Optional[JsonNodePublic]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DashboardPublic
            Updated dashboard

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.dashboards.update_dashboard(dashboard_id='dashboardId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_dashboard(
            dashboard_id, name=name, description=description, config=config, request_options=request_options
        )
        return _response.data
