# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.dataset_expansion_response import DatasetExpansionResponse
from ..types.dataset_item_page_compare import DatasetItemPageCompare
from ..types.dataset_item_page_public import DatasetItemPagePublic
from ..types.dataset_item_public import DatasetItemPublic
from ..types.dataset_item_update import DatasetItemUpdate
from ..types.dataset_item_write import DatasetItemWrite
from ..types.dataset_item_write_source import DatasetItemWriteSource
from ..types.dataset_page_public import DatasetPagePublic
from ..types.dataset_public import DatasetPublic
from ..types.json_node import JsonNode
from ..types.page_columns import PageColumns
from ..types.project_stats_public import ProjectStatsPublic
from ..types.span_enrichment_options import SpanEnrichmentOptions
from ..types.trace_enrichment_options import TraceEnrichmentOptions
from .raw_client import AsyncRawDatasetsClient, RawDatasetsClient
from .types.dataset_update_visibility import DatasetUpdateVisibility
from .types.dataset_write_visibility import DatasetWriteVisibility

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DatasetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDatasetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDatasetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDatasetsClient
        """
        return self._raw_client

    def batch_update_dataset_items(
        self,
        *,
        ids: typing.Sequence[str],
        update: DatasetItemUpdate,
        merge_tags: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update multiple dataset items

        Parameters
        ----------
        ids : typing.Sequence[str]
            List of dataset item IDs to update (max 1000)

        update : DatasetItemUpdate

        merge_tags : typing.Optional[bool]
            If true, merge tags with existing tags instead of replacing them. Default: false

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import DatasetItemUpdate
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.batch_update_dataset_items(ids=['ids'], update=DatasetItemUpdate(), )
        """
        _response = self._raw_client.batch_update_dataset_items(
            ids=ids, update=update, merge_tags=merge_tags, request_options=request_options
        )
        return _response.data

    def find_datasets(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        with_experiments_only: typing.Optional[bool] = None,
        with_optimizations_only: typing.Optional[bool] = None,
        prompt_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetPagePublic:
        """
        Find datasets

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        with_experiments_only : typing.Optional[bool]

        with_optimizations_only : typing.Optional[bool]

        prompt_id : typing.Optional[str]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetPagePublic
            Dataset resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.find_datasets()
        """
        _response = self._raw_client.find_datasets(
            page=page,
            size=size,
            with_experiments_only=with_experiments_only,
            with_optimizations_only=with_optimizations_only,
            prompt_id=prompt_id,
            name=name,
            sorting=sorting,
            filters=filters,
            request_options=request_options,
        )
        return _response.data

    def create_dataset(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetWriteVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset

        Parameters
        ----------
        name : str

        id : typing.Optional[str]

        visibility : typing.Optional[DatasetWriteVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.create_dataset(name='name', )
        """
        _response = self._raw_client.create_dataset(
            name=name, id=id, visibility=visibility, tags=tags, description=description, request_options=request_options
        )
        return _response.data

    def create_or_update_dataset_items(
        self,
        *,
        items: typing.Sequence[DatasetItemWrite],
        dataset_name: typing.Optional[str] = OMIT,
        dataset_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create/update dataset items based on dataset item id

        Parameters
        ----------
        items : typing.Sequence[DatasetItemWrite]

        dataset_name : typing.Optional[str]
            If null, dataset_id must be provided

        dataset_id : typing.Optional[str]
            If null, dataset_name must be provided

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import DatasetItemWrite
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.create_or_update_dataset_items(items=[DatasetItemWrite(source="manual", data={'key': 'value'
        }, )], )
        """
        _response = self._raw_client.create_or_update_dataset_items(
            items=items, dataset_name=dataset_name, dataset_id=dataset_id, request_options=request_options
        )
        return _response.data

    def create_dataset_items_from_csv(
        self,
        *,
        file: typing.Dict[str, typing.Optional[typing.Any]],
        dataset_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset items from uploaded CSV file. CSV should have headers in the first row. Processing happens asynchronously in batches.

        Parameters
        ----------
        file : typing.Dict[str, typing.Optional[typing.Any]]

        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.create_dataset_items_from_csv(file={'key': 'value'
        }, dataset_id='dataset_id', )
        """
        _response = self._raw_client.create_dataset_items_from_csv(
            file=file, dataset_id=dataset_id, request_options=request_options
        )
        return _response.data

    def create_dataset_items_from_spans(
        self,
        dataset_id: str,
        *,
        span_ids: typing.Sequence[str],
        enrichment_options: SpanEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset items from spans with enriched metadata

        Parameters
        ----------
        dataset_id : str

        span_ids : typing.Sequence[str]
            Set of span IDs to add to the dataset

        enrichment_options : SpanEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import SpanEnrichmentOptions
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.create_dataset_items_from_spans(dataset_id='dataset_id', span_ids=['span_ids'], enrichment_options=SpanEnrichmentOptions(), )
        """
        _response = self._raw_client.create_dataset_items_from_spans(
            dataset_id, span_ids=span_ids, enrichment_options=enrichment_options, request_options=request_options
        )
        return _response.data

    def create_dataset_items_from_traces(
        self,
        dataset_id: str,
        *,
        trace_ids: typing.Sequence[str],
        enrichment_options: TraceEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset items from traces with enriched metadata

        Parameters
        ----------
        dataset_id : str

        trace_ids : typing.Sequence[str]
            Set of trace IDs to add to the dataset

        enrichment_options : TraceEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import TraceEnrichmentOptions
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.create_dataset_items_from_traces(dataset_id='dataset_id', trace_ids=['trace_ids'], enrichment_options=TraceEnrichmentOptions(), )
        """
        _response = self._raw_client.create_dataset_items_from_traces(
            dataset_id, trace_ids=trace_ids, enrichment_options=enrichment_options, request_options=request_options
        )
        return _response.data

    def get_dataset_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DatasetPublic:
        """
        Get dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetPublic
            Dataset resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.get_dataset_by_id(id='id', )
        """
        _response = self._raw_client.get_dataset_by_id(id, request_options=request_options)
        return _response.data

    def update_dataset(
        self,
        id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetUpdateVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update dataset by id

        Parameters
        ----------
        id : str

        name : str

        description : typing.Optional[str]

        visibility : typing.Optional[DatasetUpdateVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.update_dataset(id='id', name='name', )
        """
        _response = self._raw_client.update_dataset(
            id, name=name, description=description, visibility=visibility, tags=tags, request_options=request_options
        )
        return _response.data

    def delete_dataset(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.delete_dataset(id='id', )
        """
        _response = self._raw_client.delete_dataset(id, request_options=request_options)
        return _response.data

    def delete_dataset_by_name(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.delete_dataset_by_name(dataset_name='dataset_name', )
        """
        _response = self._raw_client.delete_dataset_by_name(dataset_name=dataset_name, request_options=request_options)
        return _response.data

    def delete_dataset_items(
        self, *, item_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete dataset items

        Parameters
        ----------
        item_ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.delete_dataset_items(item_ids=['item_ids'], )
        """
        _response = self._raw_client.delete_dataset_items(item_ids=item_ids, request_options=request_options)
        return _response.data

    def delete_datasets_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete datasets batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.delete_datasets_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_datasets_batch(ids=ids, request_options=request_options)
        return _response.data

    def expand_dataset(
        self,
        id: str,
        *,
        model: str,
        sample_count: typing.Optional[int] = OMIT,
        preserve_fields: typing.Optional[typing.Sequence[str]] = OMIT,
        variation_instructions: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetExpansionResponse:
        """
        Generate synthetic dataset samples using LLM based on existing data patterns

        Parameters
        ----------
        id : str

        model : str
            The model to use for synthetic data generation

        sample_count : typing.Optional[int]
            Number of synthetic samples to generate

        preserve_fields : typing.Optional[typing.Sequence[str]]
            Fields to preserve patterns from original data

        variation_instructions : typing.Optional[str]
            Additional instructions for data variation

        custom_prompt : typing.Optional[str]
            Custom prompt to use for generation instead of auto-generated one

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetExpansionResponse
            Generated synthetic samples

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.expand_dataset(id='id', model='gpt-4', )
        """
        _response = self._raw_client.expand_dataset(
            id,
            model=model,
            sample_count=sample_count,
            preserve_fields=preserve_fields,
            variation_instructions=variation_instructions,
            custom_prompt=custom_prompt,
            request_options=request_options,
        )
        return _response.data

    def find_dataset_items_with_experiment_items(
        self,
        id: str,
        *,
        experiment_ids: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetItemPageCompare:
        """
        Find dataset items with experiment items

        Parameters
        ----------
        id : str

        experiment_ids : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        search : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetItemPageCompare
            Dataset item resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.find_dataset_items_with_experiment_items(id='id', experiment_ids='experiment_ids', )
        """
        _response = self._raw_client.find_dataset_items_with_experiment_items(
            id,
            experiment_ids=experiment_ids,
            page=page,
            size=size,
            filters=filters,
            sorting=sorting,
            search=search,
            truncate=truncate,
            request_options=request_options,
        )
        return _response.data

    def get_dataset_by_identifier(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DatasetPublic:
        """
        Get dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetPublic
            Dataset resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.get_dataset_by_identifier(dataset_name='dataset_name', )
        """
        _response = self._raw_client.get_dataset_by_identifier(
            dataset_name=dataset_name, request_options=request_options
        )
        return _response.data

    def get_dataset_experiment_items_stats(
        self,
        id: str,
        *,
        experiment_ids: str,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectStatsPublic:
        """
        Get experiment items stats for dataset

        Parameters
        ----------
        id : str

        experiment_ids : str

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectStatsPublic
            Experiment items stats resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.get_dataset_experiment_items_stats(id='id', experiment_ids='experiment_ids', )
        """
        _response = self._raw_client.get_dataset_experiment_items_stats(
            id, experiment_ids=experiment_ids, filters=filters, request_options=request_options
        )
        return _response.data

    def get_dataset_item_by_id(
        self, item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DatasetItemPublic:
        """
        Get dataset item by id

        Parameters
        ----------
        item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetItemPublic
            Dataset item resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.get_dataset_item_by_id(item_id='itemId', )
        """
        _response = self._raw_client.get_dataset_item_by_id(item_id, request_options=request_options)
        return _response.data

    def patch_dataset_item(
        self,
        item_id: str,
        *,
        source: DatasetItemWriteSource,
        data: JsonNode,
        id: typing.Optional[str] = OMIT,
        trace_id: typing.Optional[str] = OMIT,
        span_id: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Partially update dataset item by id. Only provided fields will be updated.

        Parameters
        ----------
        item_id : str

        source : DatasetItemWriteSource

        data : JsonNode

        id : typing.Optional[str]

        trace_id : typing.Optional[str]

        span_id : typing.Optional[str]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.patch_dataset_item(item_id='itemId', source="manual", data={'key': 'value'
        }, )
        """
        _response = self._raw_client.patch_dataset_item(
            item_id,
            source=source,
            data=data,
            id=id,
            trace_id=trace_id,
            span_id=span_id,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    def get_dataset_items(
        self,
        id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetItemPagePublic:
        """
        Get dataset items

        Parameters
        ----------
        id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetItemPagePublic
            Dataset items resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.get_dataset_items(id='id', )
        """
        _response = self._raw_client.get_dataset_items(
            id, page=page, size=size, filters=filters, truncate=truncate, request_options=request_options
        )
        return _response.data

    def get_dataset_items_output_columns(
        self,
        id: str,
        *,
        experiment_ids: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PageColumns:
        """
        Get dataset items output columns

        Parameters
        ----------
        id : str

        experiment_ids : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PageColumns
            Dataset item output columns

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.datasets.get_dataset_items_output_columns(id='id', )
        """
        _response = self._raw_client.get_dataset_items_output_columns(
            id, experiment_ids=experiment_ids, request_options=request_options
        )
        return _response.data

    def stream_dataset_items(
        self,
        *,
        dataset_name: str,
        last_retrieved_id: typing.Optional[str] = OMIT,
        steam_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Stream dataset items

        Parameters
        ----------
        dataset_name : str

        last_retrieved_id : typing.Optional[str]

        steam_limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Dataset items stream or error during process
        """
        with self._raw_client.stream_dataset_items(
            dataset_name=dataset_name,
            last_retrieved_id=last_retrieved_id,
            steam_limit=steam_limit,
            request_options=request_options,
        ) as r:
            yield from r.data


class AsyncDatasetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDatasetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDatasetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDatasetsClient
        """
        return self._raw_client

    async def batch_update_dataset_items(
        self,
        *,
        ids: typing.Sequence[str],
        update: DatasetItemUpdate,
        merge_tags: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update multiple dataset items

        Parameters
        ----------
        ids : typing.Sequence[str]
            List of dataset item IDs to update (max 1000)

        update : DatasetItemUpdate

        merge_tags : typing.Optional[bool]
            If true, merge tags with existing tags instead of replacing them. Default: false

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import DatasetItemUpdate
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.batch_update_dataset_items(ids=['ids'], update=DatasetItemUpdate(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.batch_update_dataset_items(
            ids=ids, update=update, merge_tags=merge_tags, request_options=request_options
        )
        return _response.data

    async def find_datasets(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        with_experiments_only: typing.Optional[bool] = None,
        with_optimizations_only: typing.Optional[bool] = None,
        prompt_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetPagePublic:
        """
        Find datasets

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        with_experiments_only : typing.Optional[bool]

        with_optimizations_only : typing.Optional[bool]

        prompt_id : typing.Optional[str]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetPagePublic
            Dataset resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.find_datasets()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_datasets(
            page=page,
            size=size,
            with_experiments_only=with_experiments_only,
            with_optimizations_only=with_optimizations_only,
            prompt_id=prompt_id,
            name=name,
            sorting=sorting,
            filters=filters,
            request_options=request_options,
        )
        return _response.data

    async def create_dataset(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetWriteVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset

        Parameters
        ----------
        name : str

        id : typing.Optional[str]

        visibility : typing.Optional[DatasetWriteVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.create_dataset(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_dataset(
            name=name, id=id, visibility=visibility, tags=tags, description=description, request_options=request_options
        )
        return _response.data

    async def create_or_update_dataset_items(
        self,
        *,
        items: typing.Sequence[DatasetItemWrite],
        dataset_name: typing.Optional[str] = OMIT,
        dataset_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create/update dataset items based on dataset item id

        Parameters
        ----------
        items : typing.Sequence[DatasetItemWrite]

        dataset_name : typing.Optional[str]
            If null, dataset_id must be provided

        dataset_id : typing.Optional[str]
            If null, dataset_name must be provided

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import DatasetItemWrite
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.create_or_update_dataset_items(items=[DatasetItemWrite(source="manual", data={'key': 'value'
            }, )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update_dataset_items(
            items=items, dataset_name=dataset_name, dataset_id=dataset_id, request_options=request_options
        )
        return _response.data

    async def create_dataset_items_from_csv(
        self,
        *,
        file: typing.Dict[str, typing.Optional[typing.Any]],
        dataset_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset items from uploaded CSV file. CSV should have headers in the first row. Processing happens asynchronously in batches.

        Parameters
        ----------
        file : typing.Dict[str, typing.Optional[typing.Any]]

        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.create_dataset_items_from_csv(file={'key': 'value'
            }, dataset_id='dataset_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_dataset_items_from_csv(
            file=file, dataset_id=dataset_id, request_options=request_options
        )
        return _response.data

    async def create_dataset_items_from_spans(
        self,
        dataset_id: str,
        *,
        span_ids: typing.Sequence[str],
        enrichment_options: SpanEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset items from spans with enriched metadata

        Parameters
        ----------
        dataset_id : str

        span_ids : typing.Sequence[str]
            Set of span IDs to add to the dataset

        enrichment_options : SpanEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import SpanEnrichmentOptions
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.create_dataset_items_from_spans(dataset_id='dataset_id', span_ids=['span_ids'], enrichment_options=SpanEnrichmentOptions(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_dataset_items_from_spans(
            dataset_id, span_ids=span_ids, enrichment_options=enrichment_options, request_options=request_options
        )
        return _response.data

    async def create_dataset_items_from_traces(
        self,
        dataset_id: str,
        *,
        trace_ids: typing.Sequence[str],
        enrichment_options: TraceEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset items from traces with enriched metadata

        Parameters
        ----------
        dataset_id : str

        trace_ids : typing.Sequence[str]
            Set of trace IDs to add to the dataset

        enrichment_options : TraceEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import TraceEnrichmentOptions
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.create_dataset_items_from_traces(dataset_id='dataset_id', trace_ids=['trace_ids'], enrichment_options=TraceEnrichmentOptions(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_dataset_items_from_traces(
            dataset_id, trace_ids=trace_ids, enrichment_options=enrichment_options, request_options=request_options
        )
        return _response.data

    async def get_dataset_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DatasetPublic:
        """
        Get dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetPublic
            Dataset resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.get_dataset_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_by_id(id, request_options=request_options)
        return _response.data

    async def update_dataset(
        self,
        id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetUpdateVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update dataset by id

        Parameters
        ----------
        id : str

        name : str

        description : typing.Optional[str]

        visibility : typing.Optional[DatasetUpdateVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.update_dataset(id='id', name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_dataset(
            id, name=name, description=description, visibility=visibility, tags=tags, request_options=request_options
        )
        return _response.data

    async def delete_dataset(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.delete_dataset(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_dataset(id, request_options=request_options)
        return _response.data

    async def delete_dataset_by_name(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.delete_dataset_by_name(dataset_name='dataset_name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_dataset_by_name(
            dataset_name=dataset_name, request_options=request_options
        )
        return _response.data

    async def delete_dataset_items(
        self, *, item_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete dataset items

        Parameters
        ----------
        item_ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.delete_dataset_items(item_ids=['item_ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_dataset_items(item_ids=item_ids, request_options=request_options)
        return _response.data

    async def delete_datasets_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete datasets batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.delete_datasets_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_datasets_batch(ids=ids, request_options=request_options)
        return _response.data

    async def expand_dataset(
        self,
        id: str,
        *,
        model: str,
        sample_count: typing.Optional[int] = OMIT,
        preserve_fields: typing.Optional[typing.Sequence[str]] = OMIT,
        variation_instructions: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetExpansionResponse:
        """
        Generate synthetic dataset samples using LLM based on existing data patterns

        Parameters
        ----------
        id : str

        model : str
            The model to use for synthetic data generation

        sample_count : typing.Optional[int]
            Number of synthetic samples to generate

        preserve_fields : typing.Optional[typing.Sequence[str]]
            Fields to preserve patterns from original data

        variation_instructions : typing.Optional[str]
            Additional instructions for data variation

        custom_prompt : typing.Optional[str]
            Custom prompt to use for generation instead of auto-generated one

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetExpansionResponse
            Generated synthetic samples

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.expand_dataset(id='id', model='gpt-4', )
        asyncio.run(main())
        """
        _response = await self._raw_client.expand_dataset(
            id,
            model=model,
            sample_count=sample_count,
            preserve_fields=preserve_fields,
            variation_instructions=variation_instructions,
            custom_prompt=custom_prompt,
            request_options=request_options,
        )
        return _response.data

    async def find_dataset_items_with_experiment_items(
        self,
        id: str,
        *,
        experiment_ids: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetItemPageCompare:
        """
        Find dataset items with experiment items

        Parameters
        ----------
        id : str

        experiment_ids : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        search : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetItemPageCompare
            Dataset item resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.find_dataset_items_with_experiment_items(id='id', experiment_ids='experiment_ids', )
        asyncio.run(main())
        """
        _response = await self._raw_client.find_dataset_items_with_experiment_items(
            id,
            experiment_ids=experiment_ids,
            page=page,
            size=size,
            filters=filters,
            sorting=sorting,
            search=search,
            truncate=truncate,
            request_options=request_options,
        )
        return _response.data

    async def get_dataset_by_identifier(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DatasetPublic:
        """
        Get dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetPublic
            Dataset resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.get_dataset_by_identifier(dataset_name='dataset_name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_by_identifier(
            dataset_name=dataset_name, request_options=request_options
        )
        return _response.data

    async def get_dataset_experiment_items_stats(
        self,
        id: str,
        *,
        experiment_ids: str,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectStatsPublic:
        """
        Get experiment items stats for dataset

        Parameters
        ----------
        id : str

        experiment_ids : str

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectStatsPublic
            Experiment items stats resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.get_dataset_experiment_items_stats(id='id', experiment_ids='experiment_ids', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_experiment_items_stats(
            id, experiment_ids=experiment_ids, filters=filters, request_options=request_options
        )
        return _response.data

    async def get_dataset_item_by_id(
        self, item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DatasetItemPublic:
        """
        Get dataset item by id

        Parameters
        ----------
        item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetItemPublic
            Dataset item resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.get_dataset_item_by_id(item_id='itemId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_item_by_id(item_id, request_options=request_options)
        return _response.data

    async def patch_dataset_item(
        self,
        item_id: str,
        *,
        source: DatasetItemWriteSource,
        data: JsonNode,
        id: typing.Optional[str] = OMIT,
        trace_id: typing.Optional[str] = OMIT,
        span_id: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Partially update dataset item by id. Only provided fields will be updated.

        Parameters
        ----------
        item_id : str

        source : DatasetItemWriteSource

        data : JsonNode

        id : typing.Optional[str]

        trace_id : typing.Optional[str]

        span_id : typing.Optional[str]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.patch_dataset_item(item_id='itemId', source="manual", data={'key': 'value'
            }, )
        asyncio.run(main())
        """
        _response = await self._raw_client.patch_dataset_item(
            item_id,
            source=source,
            data=data,
            id=id,
            trace_id=trace_id,
            span_id=span_id,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    async def get_dataset_items(
        self,
        id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetItemPagePublic:
        """
        Get dataset items

        Parameters
        ----------
        id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetItemPagePublic
            Dataset items resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.get_dataset_items(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_items(
            id, page=page, size=size, filters=filters, truncate=truncate, request_options=request_options
        )
        return _response.data

    async def get_dataset_items_output_columns(
        self,
        id: str,
        *,
        experiment_ids: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PageColumns:
        """
        Get dataset items output columns

        Parameters
        ----------
        id : str

        experiment_ids : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PageColumns
            Dataset item output columns

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.datasets.get_dataset_items_output_columns(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_items_output_columns(
            id, experiment_ids=experiment_ids, request_options=request_options
        )
        return _response.data

    async def stream_dataset_items(
        self,
        *,
        dataset_name: str,
        last_retrieved_id: typing.Optional[str] = OMIT,
        steam_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Stream dataset items

        Parameters
        ----------
        dataset_name : str

        last_retrieved_id : typing.Optional[str]

        steam_limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Dataset items stream or error during process
        """
        async with self._raw_client.stream_dataset_items(
            dataset_name=dataset_name,
            last_retrieved_id=last_retrieved_id,
            steam_limit=steam_limit,
            request_options=request_options,
        ) as r:
            async for data in r.data:
                yield data
