# This file was auto-generated by Fern from our API Definition.

import contextlib
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..types.dataset_expansion_response import DatasetExpansionResponse
from ..types.dataset_item_page_compare import DatasetItemPageCompare
from ..types.dataset_item_page_public import DatasetItemPagePublic
from ..types.dataset_item_public import DatasetItemPublic
from ..types.dataset_item_update import DatasetItemUpdate
from ..types.dataset_item_write import DatasetItemWrite
from ..types.dataset_item_write_source import DatasetItemWriteSource
from ..types.dataset_page_public import DatasetPagePublic
from ..types.dataset_public import DatasetPublic
from ..types.json_node import JsonNode
from ..types.page_columns import PageColumns
from ..types.project_stats_public import ProjectStatsPublic
from ..types.span_enrichment_options import SpanEnrichmentOptions
from ..types.trace_enrichment_options import TraceEnrichmentOptions
from .types.dataset_update_visibility import DatasetUpdateVisibility
from .types.dataset_write_visibility import DatasetWriteVisibility

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDatasetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def batch_update_dataset_items(
        self,
        *,
        ids: typing.Sequence[str],
        update: DatasetItemUpdate,
        merge_tags: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Update multiple dataset items

        Parameters
        ----------
        ids : typing.Sequence[str]
            List of dataset item IDs to update (max 1000)

        update : DatasetItemUpdate

        merge_tags : typing.Optional[bool]
            If true, merge tags with existing tags instead of replacing them. Default: false

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items/batch",
            method="PATCH",
            json={
                "ids": ids,
                "update": convert_and_respect_annotation_metadata(
                    object_=update, annotation=DatasetItemUpdate, direction="write"
                ),
                "merge_tags": merge_tags,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def find_datasets(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        with_experiments_only: typing.Optional[bool] = None,
        with_optimizations_only: typing.Optional[bool] = None,
        prompt_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DatasetPagePublic]:
        """
        Find datasets

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        with_experiments_only : typing.Optional[bool]

        with_optimizations_only : typing.Optional[bool]

        prompt_id : typing.Optional[str]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DatasetPagePublic]
            Dataset resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets",
            method="GET",
            params={
                "page": page,
                "size": size,
                "with_experiments_only": with_experiments_only,
                "with_optimizations_only": with_optimizations_only,
                "prompt_id": prompt_id,
                "name": name,
                "sorting": sorting,
                "filters": filters,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetPagePublic,
                    parse_obj_as(
                        type_=DatasetPagePublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_dataset(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetWriteVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Create dataset

        Parameters
        ----------
        name : str

        id : typing.Optional[str]

        visibility : typing.Optional[DatasetWriteVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets",
            method="POST",
            json={
                "id": id,
                "name": name,
                "visibility": visibility,
                "tags": tags,
                "description": description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_or_update_dataset_items(
        self,
        *,
        items: typing.Sequence[DatasetItemWrite],
        dataset_name: typing.Optional[str] = OMIT,
        dataset_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Create/update dataset items based on dataset item id

        Parameters
        ----------
        items : typing.Sequence[DatasetItemWrite]

        dataset_name : typing.Optional[str]
            If null, dataset_id must be provided

        dataset_id : typing.Optional[str]
            If null, dataset_name must be provided

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items",
            method="PUT",
            json={
                "dataset_name": dataset_name,
                "dataset_id": dataset_id,
                "items": convert_and_respect_annotation_metadata(
                    object_=items, annotation=typing.Sequence[DatasetItemWrite], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_dataset_items_from_csv(
        self,
        *,
        file: typing.Dict[str, typing.Optional[typing.Any]],
        dataset_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Create dataset items from uploaded CSV file. CSV should have headers in the first row. Processing happens asynchronously in batches.

        Parameters
        ----------
        file : typing.Dict[str, typing.Optional[typing.Any]]

        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items/from-csv",
            method="POST",
            data={
                "file": file,
                "dataset_id": dataset_id,
            },
            files={},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_dataset_items_from_spans(
        self,
        dataset_id: str,
        *,
        span_ids: typing.Sequence[str],
        enrichment_options: SpanEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Create dataset items from spans with enriched metadata

        Parameters
        ----------
        dataset_id : str

        span_ids : typing.Sequence[str]
            Set of span IDs to add to the dataset

        enrichment_options : SpanEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(dataset_id)}/items/from-spans",
            method="POST",
            json={
                "span_ids": span_ids,
                "enrichment_options": convert_and_respect_annotation_metadata(
                    object_=enrichment_options, annotation=SpanEnrichmentOptions, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_dataset_items_from_traces(
        self,
        dataset_id: str,
        *,
        trace_ids: typing.Sequence[str],
        enrichment_options: TraceEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Create dataset items from traces with enriched metadata

        Parameters
        ----------
        dataset_id : str

        trace_ids : typing.Sequence[str]
            Set of trace IDs to add to the dataset

        enrichment_options : TraceEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(dataset_id)}/items/from-traces",
            method="POST",
            json={
                "trace_ids": trace_ids,
                "enrichment_options": convert_and_respect_annotation_metadata(
                    object_=enrichment_options, annotation=TraceEnrichmentOptions, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DatasetPublic]:
        """
        Get dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DatasetPublic]
            Dataset resource
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetPublic,
                    parse_obj_as(
                        type_=DatasetPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_dataset(
        self,
        id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetUpdateVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Update dataset by id

        Parameters
        ----------
        id : str

        name : str

        description : typing.Optional[str]

        visibility : typing.Optional[DatasetUpdateVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "visibility": visibility,
                "tags": tags,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_dataset(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Delete dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_dataset_by_name(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Delete dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets/delete",
            method="POST",
            json={
                "dataset_name": dataset_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_dataset_items(
        self, *, item_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Delete dataset items

        Parameters
        ----------
        item_ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items/delete",
            method="POST",
            json={
                "item_ids": item_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_datasets_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Delete datasets batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets/delete-batch",
            method="POST",
            json={
                "ids": ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def expand_dataset(
        self,
        id: str,
        *,
        model: str,
        sample_count: typing.Optional[int] = OMIT,
        preserve_fields: typing.Optional[typing.Sequence[str]] = OMIT,
        variation_instructions: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DatasetExpansionResponse]:
        """
        Generate synthetic dataset samples using LLM based on existing data patterns

        Parameters
        ----------
        id : str

        model : str
            The model to use for synthetic data generation

        sample_count : typing.Optional[int]
            Number of synthetic samples to generate

        preserve_fields : typing.Optional[typing.Sequence[str]]
            Fields to preserve patterns from original data

        variation_instructions : typing.Optional[str]
            Additional instructions for data variation

        custom_prompt : typing.Optional[str]
            Custom prompt to use for generation instead of auto-generated one

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DatasetExpansionResponse]
            Generated synthetic samples
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/expansions",
            method="POST",
            json={
                "model": model,
                "sample_count": sample_count,
                "preserve_fields": preserve_fields,
                "variation_instructions": variation_instructions,
                "custom_prompt": custom_prompt,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetExpansionResponse,
                    parse_obj_as(
                        type_=DatasetExpansionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def find_dataset_items_with_experiment_items(
        self,
        id: str,
        *,
        experiment_ids: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DatasetItemPageCompare]:
        """
        Find dataset items with experiment items

        Parameters
        ----------
        id : str

        experiment_ids : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        search : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DatasetItemPageCompare]
            Dataset item resource
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items/experiments/items",
            method="GET",
            params={
                "page": page,
                "size": size,
                "experiment_ids": experiment_ids,
                "filters": filters,
                "sorting": sorting,
                "search": search,
                "truncate": truncate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetItemPageCompare,
                    parse_obj_as(
                        type_=DatasetItemPageCompare,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset_by_identifier(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DatasetPublic]:
        """
        Get dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DatasetPublic]
            Dataset resource
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/datasets/retrieve",
            method="POST",
            json={
                "dataset_name": dataset_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetPublic,
                    parse_obj_as(
                        type_=DatasetPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset_experiment_items_stats(
        self,
        id: str,
        *,
        experiment_ids: str,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProjectStatsPublic]:
        """
        Get experiment items stats for dataset

        Parameters
        ----------
        id : str

        experiment_ids : str

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProjectStatsPublic]
            Experiment items stats resource
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items/experiments/items/stats",
            method="GET",
            params={
                "experiment_ids": experiment_ids,
                "filters": filters,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectStatsPublic,
                    parse_obj_as(
                        type_=ProjectStatsPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset_item_by_id(
        self, item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DatasetItemPublic]:
        """
        Get dataset item by id

        Parameters
        ----------
        item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DatasetItemPublic]
            Dataset item resource
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/items/{jsonable_encoder(item_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetItemPublic,
                    parse_obj_as(
                        type_=DatasetItemPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def patch_dataset_item(
        self,
        item_id: str,
        *,
        source: DatasetItemWriteSource,
        data: JsonNode,
        id: typing.Optional[str] = OMIT,
        trace_id: typing.Optional[str] = OMIT,
        span_id: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Partially update dataset item by id. Only provided fields will be updated.

        Parameters
        ----------
        item_id : str

        source : DatasetItemWriteSource

        data : JsonNode

        id : typing.Optional[str]

        trace_id : typing.Optional[str]

        span_id : typing.Optional[str]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/items/{jsonable_encoder(item_id)}",
            method="PATCH",
            json={
                "id": id,
                "trace_id": trace_id,
                "span_id": span_id,
                "source": source,
                "data": data,
                "tags": tags,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset_items(
        self,
        id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DatasetItemPagePublic]:
        """
        Get dataset items

        Parameters
        ----------
        id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DatasetItemPagePublic]
            Dataset items resource
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items",
            method="GET",
            params={
                "page": page,
                "size": size,
                "filters": filters,
                "truncate": truncate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetItemPagePublic,
                    parse_obj_as(
                        type_=DatasetItemPagePublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset_items_output_columns(
        self,
        id: str,
        *,
        experiment_ids: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PageColumns]:
        """
        Get dataset items output columns

        Parameters
        ----------
        id : str

        experiment_ids : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PageColumns]
            Dataset item output columns
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items/experiments/items/output/columns",
            method="GET",
            params={
                "experiment_ids": experiment_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PageColumns,
                    parse_obj_as(
                        type_=PageColumns,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def stream_dataset_items(
        self,
        *,
        dataset_name: str,
        last_retrieved_id: typing.Optional[str] = OMIT,
        steam_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        Stream dataset items

        Parameters
        ----------
        dataset_name : str

        last_retrieved_id : typing.Optional[str]

        steam_limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            Dataset items stream or error during process
        """
        with self._client_wrapper.httpx_client.stream(
            "v1/private/datasets/items/stream",
            method="POST",
            json={
                "dataset_name": dataset_name,
                "last_retrieved_id": last_retrieved_id,
                "steam_limit": steam_limit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            def stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield stream()


class AsyncRawDatasetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def batch_update_dataset_items(
        self,
        *,
        ids: typing.Sequence[str],
        update: DatasetItemUpdate,
        merge_tags: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Update multiple dataset items

        Parameters
        ----------
        ids : typing.Sequence[str]
            List of dataset item IDs to update (max 1000)

        update : DatasetItemUpdate

        merge_tags : typing.Optional[bool]
            If true, merge tags with existing tags instead of replacing them. Default: false

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items/batch",
            method="PATCH",
            json={
                "ids": ids,
                "update": convert_and_respect_annotation_metadata(
                    object_=update, annotation=DatasetItemUpdate, direction="write"
                ),
                "merge_tags": merge_tags,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def find_datasets(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        with_experiments_only: typing.Optional[bool] = None,
        with_optimizations_only: typing.Optional[bool] = None,
        prompt_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DatasetPagePublic]:
        """
        Find datasets

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        with_experiments_only : typing.Optional[bool]

        with_optimizations_only : typing.Optional[bool]

        prompt_id : typing.Optional[str]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DatasetPagePublic]
            Dataset resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets",
            method="GET",
            params={
                "page": page,
                "size": size,
                "with_experiments_only": with_experiments_only,
                "with_optimizations_only": with_optimizations_only,
                "prompt_id": prompt_id,
                "name": name,
                "sorting": sorting,
                "filters": filters,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetPagePublic,
                    parse_obj_as(
                        type_=DatasetPagePublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_dataset(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetWriteVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Create dataset

        Parameters
        ----------
        name : str

        id : typing.Optional[str]

        visibility : typing.Optional[DatasetWriteVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets",
            method="POST",
            json={
                "id": id,
                "name": name,
                "visibility": visibility,
                "tags": tags,
                "description": description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_or_update_dataset_items(
        self,
        *,
        items: typing.Sequence[DatasetItemWrite],
        dataset_name: typing.Optional[str] = OMIT,
        dataset_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Create/update dataset items based on dataset item id

        Parameters
        ----------
        items : typing.Sequence[DatasetItemWrite]

        dataset_name : typing.Optional[str]
            If null, dataset_id must be provided

        dataset_id : typing.Optional[str]
            If null, dataset_name must be provided

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items",
            method="PUT",
            json={
                "dataset_name": dataset_name,
                "dataset_id": dataset_id,
                "items": convert_and_respect_annotation_metadata(
                    object_=items, annotation=typing.Sequence[DatasetItemWrite], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_dataset_items_from_csv(
        self,
        *,
        file: typing.Dict[str, typing.Optional[typing.Any]],
        dataset_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Create dataset items from uploaded CSV file. CSV should have headers in the first row. Processing happens asynchronously in batches.

        Parameters
        ----------
        file : typing.Dict[str, typing.Optional[typing.Any]]

        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items/from-csv",
            method="POST",
            data={
                "file": file,
                "dataset_id": dataset_id,
            },
            files={},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_dataset_items_from_spans(
        self,
        dataset_id: str,
        *,
        span_ids: typing.Sequence[str],
        enrichment_options: SpanEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Create dataset items from spans with enriched metadata

        Parameters
        ----------
        dataset_id : str

        span_ids : typing.Sequence[str]
            Set of span IDs to add to the dataset

        enrichment_options : SpanEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(dataset_id)}/items/from-spans",
            method="POST",
            json={
                "span_ids": span_ids,
                "enrichment_options": convert_and_respect_annotation_metadata(
                    object_=enrichment_options, annotation=SpanEnrichmentOptions, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_dataset_items_from_traces(
        self,
        dataset_id: str,
        *,
        trace_ids: typing.Sequence[str],
        enrichment_options: TraceEnrichmentOptions,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Create dataset items from traces with enriched metadata

        Parameters
        ----------
        dataset_id : str

        trace_ids : typing.Sequence[str]
            Set of trace IDs to add to the dataset

        enrichment_options : TraceEnrichmentOptions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(dataset_id)}/items/from-traces",
            method="POST",
            json={
                "trace_ids": trace_ids,
                "enrichment_options": convert_and_respect_annotation_metadata(
                    object_=enrichment_options, annotation=TraceEnrichmentOptions, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DatasetPublic]:
        """
        Get dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DatasetPublic]
            Dataset resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetPublic,
                    parse_obj_as(
                        type_=DatasetPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_dataset(
        self,
        id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        visibility: typing.Optional[DatasetUpdateVisibility] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Update dataset by id

        Parameters
        ----------
        id : str

        name : str

        description : typing.Optional[str]

        visibility : typing.Optional[DatasetUpdateVisibility]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "visibility": visibility,
                "tags": tags,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_dataset(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete dataset by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_dataset_by_name(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets/delete",
            method="POST",
            json={
                "dataset_name": dataset_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_dataset_items(
        self, *, item_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete dataset items

        Parameters
        ----------
        item_ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets/items/delete",
            method="POST",
            json={
                "item_ids": item_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_datasets_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete datasets batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets/delete-batch",
            method="POST",
            json={
                "ids": ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def expand_dataset(
        self,
        id: str,
        *,
        model: str,
        sample_count: typing.Optional[int] = OMIT,
        preserve_fields: typing.Optional[typing.Sequence[str]] = OMIT,
        variation_instructions: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DatasetExpansionResponse]:
        """
        Generate synthetic dataset samples using LLM based on existing data patterns

        Parameters
        ----------
        id : str

        model : str
            The model to use for synthetic data generation

        sample_count : typing.Optional[int]
            Number of synthetic samples to generate

        preserve_fields : typing.Optional[typing.Sequence[str]]
            Fields to preserve patterns from original data

        variation_instructions : typing.Optional[str]
            Additional instructions for data variation

        custom_prompt : typing.Optional[str]
            Custom prompt to use for generation instead of auto-generated one

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DatasetExpansionResponse]
            Generated synthetic samples
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/expansions",
            method="POST",
            json={
                "model": model,
                "sample_count": sample_count,
                "preserve_fields": preserve_fields,
                "variation_instructions": variation_instructions,
                "custom_prompt": custom_prompt,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetExpansionResponse,
                    parse_obj_as(
                        type_=DatasetExpansionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def find_dataset_items_with_experiment_items(
        self,
        id: str,
        *,
        experiment_ids: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DatasetItemPageCompare]:
        """
        Find dataset items with experiment items

        Parameters
        ----------
        id : str

        experiment_ids : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        search : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DatasetItemPageCompare]
            Dataset item resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items/experiments/items",
            method="GET",
            params={
                "page": page,
                "size": size,
                "experiment_ids": experiment_ids,
                "filters": filters,
                "sorting": sorting,
                "search": search,
                "truncate": truncate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetItemPageCompare,
                    parse_obj_as(
                        type_=DatasetItemPageCompare,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset_by_identifier(
        self, *, dataset_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DatasetPublic]:
        """
        Get dataset by name

        Parameters
        ----------
        dataset_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DatasetPublic]
            Dataset resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/datasets/retrieve",
            method="POST",
            json={
                "dataset_name": dataset_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetPublic,
                    parse_obj_as(
                        type_=DatasetPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset_experiment_items_stats(
        self,
        id: str,
        *,
        experiment_ids: str,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProjectStatsPublic]:
        """
        Get experiment items stats for dataset

        Parameters
        ----------
        id : str

        experiment_ids : str

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProjectStatsPublic]
            Experiment items stats resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items/experiments/items/stats",
            method="GET",
            params={
                "experiment_ids": experiment_ids,
                "filters": filters,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProjectStatsPublic,
                    parse_obj_as(
                        type_=ProjectStatsPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset_item_by_id(
        self, item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DatasetItemPublic]:
        """
        Get dataset item by id

        Parameters
        ----------
        item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DatasetItemPublic]
            Dataset item resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/items/{jsonable_encoder(item_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetItemPublic,
                    parse_obj_as(
                        type_=DatasetItemPublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def patch_dataset_item(
        self,
        item_id: str,
        *,
        source: DatasetItemWriteSource,
        data: JsonNode,
        id: typing.Optional[str] = OMIT,
        trace_id: typing.Optional[str] = OMIT,
        span_id: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Partially update dataset item by id. Only provided fields will be updated.

        Parameters
        ----------
        item_id : str

        source : DatasetItemWriteSource

        data : JsonNode

        id : typing.Optional[str]

        trace_id : typing.Optional[str]

        span_id : typing.Optional[str]

        tags : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/items/{jsonable_encoder(item_id)}",
            method="PATCH",
            json={
                "id": id,
                "trace_id": trace_id,
                "span_id": span_id,
                "source": source,
                "data": data,
                "tags": tags,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset_items(
        self,
        id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        truncate: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DatasetItemPagePublic]:
        """
        Get dataset items

        Parameters
        ----------
        id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        filters : typing.Optional[str]

        truncate : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DatasetItemPagePublic]
            Dataset items resource
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items",
            method="GET",
            params={
                "page": page,
                "size": size,
                "filters": filters,
                "truncate": truncate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DatasetItemPagePublic,
                    parse_obj_as(
                        type_=DatasetItemPagePublic,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset_items_output_columns(
        self,
        id: str,
        *,
        experiment_ids: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PageColumns]:
        """
        Get dataset items output columns

        Parameters
        ----------
        id : str

        experiment_ids : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PageColumns]
            Dataset item output columns
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/private/datasets/{jsonable_encoder(id)}/items/experiments/items/output/columns",
            method="GET",
            params={
                "experiment_ids": experiment_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PageColumns,
                    parse_obj_as(
                        type_=PageColumns,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def stream_dataset_items(
        self,
        *,
        dataset_name: str,
        last_retrieved_id: typing.Optional[str] = OMIT,
        steam_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        Stream dataset items

        Parameters
        ----------
        dataset_name : str

        last_retrieved_id : typing.Optional[str]

        steam_limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            Dataset items stream or error during process
        """
        async with self._client_wrapper.httpx_client.stream(
            "v1/private/datasets/items/stream",
            method="POST",
            json={
                "dataset_name": dataset_name,
                "last_retrieved_id": last_retrieved_id,
                "steam_limit": steam_limit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            async def stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await stream()
