# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.manual_evaluation_request_entity_type import ManualEvaluationRequestEntityType
from ..types.manual_evaluation_response import ManualEvaluationResponse
from .raw_client import AsyncRawManualEvaluationClient, RawManualEvaluationClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ManualEvaluationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawManualEvaluationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawManualEvaluationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawManualEvaluationClient
        """
        return self._raw_client

    def evaluate_threads(
        self,
        *,
        project_id: str,
        entity_ids: typing.Sequence[str],
        rule_ids: typing.Sequence[str],
        entity_type: ManualEvaluationRequestEntityType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ManualEvaluationResponse:
        """
        Manually trigger evaluation rules on selected threads. Bypasses sampling and enqueues all specified threads for evaluation.

        Parameters
        ----------
        project_id : str
            Project ID

        entity_ids : typing.Sequence[str]
            List of entity IDs (trace IDs or thread IDs) to evaluate

        rule_ids : typing.Sequence[str]
            List of automation rule IDs to apply

        entity_type : ManualEvaluationRequestEntityType
            Type of entity to evaluate (trace or thread)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ManualEvaluationResponse
            Accepted - Evaluation request queued successfully

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.manual_evaluation.evaluate_threads(project_id='550e8400-e29b-41d4-a716-446655440000', entity_ids=['550e8400-e29b-41d4-a716-446655440000', '550e8400-e29b-41d4-a716-446655440001'], rule_ids=['660e8400-e29b-41d4-a716-446655440000'], entity_type="trace", )
        """
        _response = self._raw_client.evaluate_threads(
            project_id=project_id,
            entity_ids=entity_ids,
            rule_ids=rule_ids,
            entity_type=entity_type,
            request_options=request_options,
        )
        return _response.data

    def evaluate_traces(
        self,
        *,
        project_id: str,
        entity_ids: typing.Sequence[str],
        rule_ids: typing.Sequence[str],
        entity_type: ManualEvaluationRequestEntityType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ManualEvaluationResponse:
        """
        Manually trigger evaluation rules on selected traces. Bypasses sampling and enqueues all specified traces for evaluation.

        Parameters
        ----------
        project_id : str
            Project ID

        entity_ids : typing.Sequence[str]
            List of entity IDs (trace IDs or thread IDs) to evaluate

        rule_ids : typing.Sequence[str]
            List of automation rule IDs to apply

        entity_type : ManualEvaluationRequestEntityType
            Type of entity to evaluate (trace or thread)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ManualEvaluationResponse
            Accepted - Evaluation request queued successfully

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.manual_evaluation.evaluate_traces(project_id='550e8400-e29b-41d4-a716-446655440000', entity_ids=['550e8400-e29b-41d4-a716-446655440000', '550e8400-e29b-41d4-a716-446655440001'], rule_ids=['660e8400-e29b-41d4-a716-446655440000'], entity_type="trace", )
        """
        _response = self._raw_client.evaluate_traces(
            project_id=project_id,
            entity_ids=entity_ids,
            rule_ids=rule_ids,
            entity_type=entity_type,
            request_options=request_options,
        )
        return _response.data


class AsyncManualEvaluationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawManualEvaluationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawManualEvaluationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawManualEvaluationClient
        """
        return self._raw_client

    async def evaluate_threads(
        self,
        *,
        project_id: str,
        entity_ids: typing.Sequence[str],
        rule_ids: typing.Sequence[str],
        entity_type: ManualEvaluationRequestEntityType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ManualEvaluationResponse:
        """
        Manually trigger evaluation rules on selected threads. Bypasses sampling and enqueues all specified threads for evaluation.

        Parameters
        ----------
        project_id : str
            Project ID

        entity_ids : typing.Sequence[str]
            List of entity IDs (trace IDs or thread IDs) to evaluate

        rule_ids : typing.Sequence[str]
            List of automation rule IDs to apply

        entity_type : ManualEvaluationRequestEntityType
            Type of entity to evaluate (trace or thread)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ManualEvaluationResponse
            Accepted - Evaluation request queued successfully

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.manual_evaluation.evaluate_threads(project_id='550e8400-e29b-41d4-a716-446655440000', entity_ids=['550e8400-e29b-41d4-a716-446655440000', '550e8400-e29b-41d4-a716-446655440001'], rule_ids=['660e8400-e29b-41d4-a716-446655440000'], entity_type="trace", )
        asyncio.run(main())
        """
        _response = await self._raw_client.evaluate_threads(
            project_id=project_id,
            entity_ids=entity_ids,
            rule_ids=rule_ids,
            entity_type=entity_type,
            request_options=request_options,
        )
        return _response.data

    async def evaluate_traces(
        self,
        *,
        project_id: str,
        entity_ids: typing.Sequence[str],
        rule_ids: typing.Sequence[str],
        entity_type: ManualEvaluationRequestEntityType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ManualEvaluationResponse:
        """
        Manually trigger evaluation rules on selected traces. Bypasses sampling and enqueues all specified traces for evaluation.

        Parameters
        ----------
        project_id : str
            Project ID

        entity_ids : typing.Sequence[str]
            List of entity IDs (trace IDs or thread IDs) to evaluate

        rule_ids : typing.Sequence[str]
            List of automation rule IDs to apply

        entity_type : ManualEvaluationRequestEntityType
            Type of entity to evaluate (trace or thread)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ManualEvaluationResponse
            Accepted - Evaluation request queued successfully

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.manual_evaluation.evaluate_traces(project_id='550e8400-e29b-41d4-a716-446655440000', entity_ids=['550e8400-e29b-41d4-a716-446655440000', '550e8400-e29b-41d4-a716-446655440001'], rule_ids=['660e8400-e29b-41d4-a716-446655440000'], entity_type="trace", )
        asyncio.run(main())
        """
        _response = await self._raw_client.evaluate_traces(
            project_id=project_id,
            entity_ids=entity_ids,
            rule_ids=rule_ids,
            entity_type=entity_type,
            request_options=request_options,
        )
        return _response.data
