# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DatasetExpansion(UniversalBaseModel):
    model: str = pydantic.Field()
    """
    The model to use for synthetic data generation
    """

    sample_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of synthetic samples to generate
    """

    preserve_fields: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Fields to preserve patterns from original data
    """

    variation_instructions: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional instructions for data variation
    """

    custom_prompt: typing.Optional[str] = pydantic.Field(default=None)
    """
    Custom prompt to use for generation instead of auto-generated one
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
