# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .error_info_write import ErrorInfoWrite
from .json_list_string_write import JsonListStringWrite
from .span_write_type import SpanWriteType


class SpanWrite(UniversalBaseModel):
    id: typing.Optional[str] = None
    project_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    If null, the default project is used
    """

    trace_id: typing.Optional[str] = None
    parent_span_id: typing.Optional[str] = None
    name: typing.Optional[str] = None
    type: typing.Optional[SpanWriteType] = None
    start_time: dt.datetime
    end_time: typing.Optional[dt.datetime] = None
    input: typing.Optional[JsonListStringWrite] = None
    output: typing.Optional[JsonListStringWrite] = None
    metadata: typing.Optional[JsonListStringWrite] = None
    model: typing.Optional[str] = None
    provider: typing.Optional[str] = None
    tags: typing.Optional[typing.List[str]] = None
    usage: typing.Optional[typing.Dict[str, int]] = None
    error_info: typing.Optional[ErrorInfoWrite] = None
    last_updated_at: typing.Optional[dt.datetime] = None
    total_estimated_cost: typing.Optional[float] = None
    total_estimated_cost_version: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
